/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.beans.BeanInfo;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.tree.BaseTree;
import org.antlr.runtime.tree.CommonTree;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class PTFUtils {
    public static String toString(List<?> col) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        boolean first = true;
        for (Object o : col) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(o.toString());
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(Map<?, ?> col) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        boolean first = true;
        for (Map.Entry<?, ?> o : col.entrySet()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(o.getKey().toString()).append(" : ").append(o.getValue().toString());
        }
        buf.append("]");
        return buf.toString();
    }

    public static String unescapeQueryString(String qry) {
        qry = qry.replace("\\\"", "\"");
        qry = qry.replace("\\'", "'");
        return qry;
    }

    public static void serialize(OutputStream out, Object o) {
        XMLEncoder e = new XMLEncoder(out);
        e.setExceptionListener(new EL());
        PTFUtils.addPersistenceDelegates(e);
        e.writeObject(o);
        e.close();
    }

    public static Object deserialize(InputStream in1) {
        XMLDecoder d = null;
        try {
            d = new XMLDecoder(in1, null, null);
            Object object = d.readObject();
            return object;
        }
        finally {
            if (null != d) {
                d.close();
            }
        }
    }

    public static void addPersistenceDelegates(XMLEncoder e) {
        PTFUtils.addAntlrPersistenceDelegates(e);
        PTFUtils.addHivePersistenceDelegates(e);
        PTFUtils.addEnumDelegates(e);
    }

    public static void addEnumDelegates(XMLEncoder e) {
        e.setPersistenceDelegate(WindowingSpec.Direction.class, new Utilities.EnumDelegate());
    }

    public static void addAntlrPersistenceDelegates(XMLEncoder e) {
        e.setPersistenceDelegate(ASTNode.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{((ASTNode)oldInstance).getToken()});
            }
        });
        e.setPersistenceDelegate(CommonTree.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{((CommonTree)oldInstance).getToken()});
            }
        });
        e.setPersistenceDelegate(BaseTree.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[0]);
            }

            protected void initialize(Class type, Object oldInstance, Object newInstance, Encoder out) {
                super.initialize(type, oldInstance, newInstance, out);
                BaseTree t = (BaseTree)oldInstance;
                for (int i = 0; i < t.getChildCount(); ++i) {
                    out.writeStatement(new Statement(oldInstance, "addChild", new Object[]{t.getChild(i)}));
                }
            }
        });
        e.setPersistenceDelegate(CommonToken.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{((CommonToken)oldInstance).getType(), ((CommonToken)oldInstance).getText()});
            }
        });
    }

    public static void addHivePersistenceDelegates(XMLEncoder e) {
        e.setPersistenceDelegate(PrimitiveTypeInfo.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, TypeInfoFactory.class, "getPrimitiveTypeInfo", new Object[]{((PrimitiveTypeInfo)oldInstance).getTypeName()});
            }
        });
    }

    public static void makeTransient(Class<?> beanClass, String ... pdNames) {
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] descs = info.getPropertyDescriptors();
            if (descs == null) {
                throw new RuntimeException("Cannot access property descriptor for class " + beanClass);
            }
            HashMap<String, PropertyDescriptor> mapping = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor desc : descs) {
                mapping.put(desc.getName(), desc);
            }
            for (String pdName : pdNames) {
                PropertyDescriptor desc = (PropertyDescriptor)mapping.get(pdName);
                if (desc == null) {
                    throw new RuntimeException("Property " + (String)pdName + " does not exist in " + beanClass);
                }
                desc.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException ie) {
            throw new RuntimeException(ie);
        }
    }

    static class EL
    implements ExceptionListener {
        EL() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot serialize the query plan", e);
        }
    }

    public static abstract class Predicate<T> {
        public abstract boolean apply(T var1);
    }

    public static class ReverseIterator<T>
    implements Iterator<T> {
        Stack<T> stack = new Stack();

        public ReverseIterator(Iterator<T> it) {
            while (it.hasNext()) {
                this.stack.push(it.next());
            }
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public T next() {
            return this.stack.pop();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

