/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.HashMap;
import java.util.Map;

public enum PrivilegeType {
    ALL(763, "All"),
    ALTER_DATA(764, "Update"),
    ALTER_METADATA(765, "Alter"),
    CREATE(766, "Create"),
    DROP(768, "Drop"),
    INDEX(769, "Index"),
    LOCK(771, "Lock"),
    SELECT(774, "Select"),
    SHOW_DATABASE(775, "Show_Database"),
    INSERT(770, "Insert"),
    DELETE(767, "Delete"),
    UNKNOWN(null, null);

    private final String name;
    private final Integer token;
    private static Map<Integer, PrivilegeType> token2Type;
    private static Map<String, PrivilegeType> name2Type;

    private PrivilegeType(Integer token, String name) {
        this.name = name;
        this.token = token;
    }

    public String toString() {
        return this.name == null ? "unkown" : this.name;
    }

    public Integer getToken() {
        return this.token;
    }

    public static PrivilegeType getPrivTypeByToken(int token) {
        PrivilegeType.populateToken2Type();
        PrivilegeType privType = token2Type.get(token);
        if (privType != null) {
            return privType;
        }
        return UNKNOWN;
    }

    private static synchronized void populateToken2Type() {
        if (token2Type != null) {
            return;
        }
        token2Type = new HashMap<Integer, PrivilegeType>();
        for (PrivilegeType privType : PrivilegeType.values()) {
            token2Type.put(privType.getToken(), privType);
        }
    }

    public static PrivilegeType getPrivTypeByName(String privilegeName) {
        PrivilegeType.populateName2Type();
        String canonicalizedName = privilegeName.toLowerCase();
        PrivilegeType privType = name2Type.get(canonicalizedName);
        if (privType != null) {
            return privType;
        }
        return UNKNOWN;
    }

    private static synchronized void populateName2Type() {
        if (name2Type != null) {
            return;
        }
        name2Type = new HashMap<String, PrivilegeType>();
        for (PrivilegeType privType : PrivilegeType.values()) {
            name2Type.put(privType.toString().toLowerCase(), privType);
        }
    }
}

