/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.PrunerUtils;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.OpProcFactory;
import org.apache.hadoop.hive.ql.optimizer.ppr.OpWalkerCtx;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartExprEvalUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class PartitionPruner
implements Transform {
    public static final String CLASS_NAME = PartitionPruner.class.getName();
    public static final Log LOG = LogFactory.getLog((String)CLASS_NAME);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        OpWalkerCtx opWalkerCtx = new OpWalkerCtx(pctx.getOpToPartPruner());
        PrunerUtils.walkOperatorTree(pctx, opWalkerCtx, OpProcFactory.getFilterProc(), OpProcFactory.getDefaultProc());
        return pctx;
    }

    public static boolean onlyContainsPartnCols(Table tab, ExprNodeDesc expr) {
        if (!tab.isPartitioned() || expr == null) {
            return true;
        }
        if (expr instanceof ExprNodeColumnDesc) {
            String colName = ((ExprNodeColumnDesc)expr).getColumn();
            return tab.isPartitionKey(colName);
        }
        if (expr instanceof ExprNodeGenericFuncDesc && !FunctionRegistry.isDeterministic(((ExprNodeGenericFuncDesc)expr).getGenericUDF())) {
            return false;
        }
        List<ExprNodeDesc> children = expr.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (PartitionPruner.onlyContainsPartnCols(tab, children.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static PrunedPartitionList prune(TableScanOperator ts, ParseContext parseCtx, String alias) throws SemanticException {
        return PartitionPruner.prune(((TableScanDesc)ts.getConf()).getTableMetadata(), parseCtx.getOpToPartPruner().get(ts), parseCtx.getConf(), alias, parseCtx.getPrunedPartitions());
    }

    public static PrunedPartitionList prune(Table tab, ExprNodeDesc prunerExpr, HiveConf conf, String alias, Map<String, PrunedPartitionList> prunedPartitionsMap) throws SemanticException {
        LOG.trace((Object)"Started pruning partiton");
        LOG.trace((Object)("dbname = " + tab.getDbName()));
        LOG.trace((Object)("tabname = " + tab.getTableName()));
        LOG.trace("prune Expression = " + prunerExpr == null ? "" : prunerExpr);
        String key = tab.getDbName() + "." + tab.getTableName() + ";";
        if (!tab.isPartitioned()) {
            return PartitionPruner.getAllPartsFromCacheOrServer(tab, key, false, prunedPartitionsMap);
        }
        if ("strict".equalsIgnoreCase(HiveConf.getVar(conf, HiveConf.ConfVars.HIVEMAPREDMODE)) && !PartitionPruner.hasColumnExpr(prunerExpr)) {
            throw new SemanticException(ErrorMsg.NO_PARTITION_PREDICATE.getMsg("for Alias \"" + alias + "\" Table \"" + tab.getTableName() + "\""));
        }
        if (prunerExpr == null) {
            return PartitionPruner.getAllPartsFromCacheOrServer(tab, key, false, prunedPartitionsMap);
        }
        LinkedHashSet<String> partColsUsedInFilter = new LinkedHashSet<String>();
        prunerExpr = PartitionPruner.removeNonPartCols(prunerExpr, PartitionPruner.extractPartColNames(tab), partColsUsedInFilter);
        ExprNodeDesc compactExpr = PartitionPruner.compactExpr(prunerExpr.clone());
        String oldFilter = prunerExpr.getExprString();
        if (PartitionPruner.isBooleanExpr(compactExpr)) {
            if (!PartitionPruner.isFalseExpr(compactExpr)) {
                LOG.debug((Object)("Filter " + oldFilter + " was null after compacting"));
                return PartitionPruner.getAllPartsFromCacheOrServer(tab, key, true, prunedPartitionsMap);
            }
            return new PrunedPartitionList(tab, new LinkedHashSet<Partition>(new ArrayList()), new ArrayList<String>(), false);
        }
        LOG.debug((Object)("Filter w/ compacting: " + compactExpr.getExprString() + "; filter w/o compacting: " + oldFilter));
        key = key + compactExpr.getExprString();
        PrunedPartitionList ppList = prunedPartitionsMap.get(key);
        if (ppList != null) {
            return ppList;
        }
        ppList = PartitionPruner.getPartitionsFromServer(tab, (ExprNodeGenericFuncDesc)compactExpr, conf, alias, partColsUsedInFilter, oldFilter.equals(compactExpr.getExprString()));
        prunedPartitionsMap.put(key, ppList);
        return ppList;
    }

    private static PrunedPartitionList getAllPartsFromCacheOrServer(Table tab, String key, boolean unknownPartitions, Map<String, PrunedPartitionList> partsCache) throws SemanticException {
        Set<Partition> parts;
        PrunedPartitionList ppList = partsCache.get(key);
        if (ppList != null) {
            return ppList;
        }
        try {
            parts = PartitionPruner.getAllPartitions(tab);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        ppList = new PrunedPartitionList(tab, parts, null, unknownPartitions);
        partsCache.put(key, ppList);
        return ppList;
    }

    private static boolean isBooleanExpr(ExprNodeDesc expr) {
        return expr != null && expr instanceof ExprNodeConstantDesc && ((ExprNodeConstantDesc)expr).getTypeInfo() instanceof PrimitiveTypeInfo && ((PrimitiveTypeInfo)((ExprNodeConstantDesc)expr).getTypeInfo()).getTypeName().equals("boolean");
    }

    private static boolean isTrueExpr(ExprNodeDesc expr) {
        return PartitionPruner.isBooleanExpr(expr) && ((ExprNodeConstantDesc)expr).getValue() != null && ((ExprNodeConstantDesc)expr).getValue().equals(Boolean.TRUE);
    }

    private static boolean isFalseExpr(ExprNodeDesc expr) {
        return PartitionPruner.isBooleanExpr(expr) && ((ExprNodeConstantDesc)expr).getValue() != null && ((ExprNodeConstantDesc)expr).getValue().equals(Boolean.FALSE);
    }

    private static ExprNodeDesc compactExpr(ExprNodeDesc expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof ExprNodeConstantDesc) {
            if (PartitionPruner.isBooleanExpr(expr)) {
                return expr;
            }
            throw new IllegalStateException("Unexpected non-null ExprNodeConstantDesc: " + expr.getExprString());
        }
        if (expr instanceof ExprNodeGenericFuncDesc) {
            GenericUDF udf = ((ExprNodeGenericFuncDesc)expr).getGenericUDF();
            boolean isAnd = udf instanceof GenericUDFOPAnd;
            boolean isOr = udf instanceof GenericUDFOPOr;
            if (isAnd || isOr) {
                List<ExprNodeDesc> children = expr.getChildren();
                ExprNodeDesc left = children.get(0);
                children.set(0, PartitionPruner.compactExpr(left));
                ExprNodeDesc right = children.get(1);
                children.set(1, PartitionPruner.compactExpr(right));
                if (PartitionPruner.isTrueExpr(children.get(0)) && PartitionPruner.isTrueExpr(children.get(1))) {
                    return new ExprNodeConstantDesc(Boolean.TRUE);
                }
                if (PartitionPruner.isTrueExpr(children.get(0))) {
                    return isAnd ? children.get(1) : new ExprNodeConstantDesc(Boolean.TRUE);
                }
                if (PartitionPruner.isTrueExpr(children.get(1))) {
                    return isAnd ? children.get(0) : new ExprNodeConstantDesc(Boolean.TRUE);
                }
                if (PartitionPruner.isFalseExpr(children.get(0)) && PartitionPruner.isFalseExpr(children.get(1))) {
                    return new ExprNodeConstantDesc(Boolean.FALSE);
                }
                if (PartitionPruner.isFalseExpr(children.get(0))) {
                    return isAnd ? new ExprNodeConstantDesc(Boolean.FALSE) : children.get(1);
                }
                if (PartitionPruner.isFalseExpr(children.get(1))) {
                    return isAnd ? new ExprNodeConstantDesc(Boolean.FALSE) : children.get(0);
                }
            }
            return expr;
        }
        throw new IllegalStateException("Unexpected type of ExprNodeDesc: " + expr.getExprString());
    }

    private static ExprNodeDesc removeNonPartCols(ExprNodeDesc expr, List<String> partCols, Set<String> referred) {
        if (expr instanceof ExprNodeColumnDesc) {
            String column = ((ExprNodeColumnDesc)expr).getColumn();
            if (!partCols.contains(column)) {
                return new ExprNodeConstantDesc(expr.getTypeInfo(), null);
            }
            referred.add(column);
        }
        if (expr instanceof ExprNodeGenericFuncDesc) {
            List<ExprNodeDesc> children = expr.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                children.set(i, PartitionPruner.removeNonPartCols(children.get(i), partCols, referred));
            }
        }
        return expr;
    }

    private static boolean hasUserFunctions(ExprNodeDesc expr) {
        if (!(expr instanceof ExprNodeGenericFuncDesc)) {
            return false;
        }
        if (!FunctionRegistry.isNativeFuncExpr((ExprNodeGenericFuncDesc)expr)) {
            return true;
        }
        for (ExprNodeDesc child : expr.getChildren()) {
            if (!PartitionPruner.hasUserFunctions(child)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrunedPartitionList getPartitionsFromServer(Table tab, ExprNodeGenericFuncDesc compactExpr, HiveConf conf, String alias, Set<String> partColsUsedInFilter, boolean isPruningByExactFilter) throws SemanticException {
        try {
            boolean doEvalClientSide = PartitionPruner.hasUserFunctions(compactExpr);
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            boolean hasUnknownPartitions = false;
            PerfLogger perfLogger = PerfLogger.getPerfLogger();
            if (!doEvalClientSide) {
                perfLogger.PerfLogBegin(CLASS_NAME, "partition-retrieving");
                try {
                    hasUnknownPartitions = Hive.get().getPartitionsByExpr(tab, compactExpr, conf, partitions);
                }
                catch (IMetaStoreClient.IncompatibleMetastoreException ime) {
                    LOG.warn((Object)"Metastore doesn't support getPartitionsByExpr", (Throwable)ime);
                    doEvalClientSide = true;
                }
                finally {
                    perfLogger.PerfLogEnd(CLASS_NAME, "partition-retrieving");
                }
            }
            if (doEvalClientSide) {
                hasUnknownPartitions = PartitionPruner.pruneBySequentialScan(tab, partitions, compactExpr, conf);
            }
            return new PrunedPartitionList(tab, new LinkedHashSet<Partition>(partitions), new ArrayList<String>(partColsUsedInFilter), hasUnknownPartitions || !isPruningByExactFilter);
        }
        catch (SemanticException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private static Set<Partition> getAllPartitions(Table tab) throws HiveException {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "partition-retrieving");
        Set<Partition> result = Hive.get().getAllPartitionsOf(tab);
        perfLogger.PerfLogEnd(CLASS_NAME, "partition-retrieving");
        return result;
    }

    private static boolean pruneBySequentialScan(Table tab, List<Partition> partitions, ExprNodeGenericFuncDesc prunerExpr, HiveConf conf) throws HiveException, MetaException {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "prune-listing");
        List<String> partNames = Hive.get().getPartitionNames(tab.getDbName(), tab.getTableName(), (short)-1);
        String defaultPartitionName = conf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        List<String> partCols = PartitionPruner.extractPartColNames(tab);
        List<PrimitiveTypeInfo> partColTypeInfos = PartitionPruner.extractPartColTypes(tab);
        boolean hasUnknownPartitions = PartitionPruner.prunePartitionNames(partCols, partColTypeInfos, prunerExpr, defaultPartitionName, partNames);
        perfLogger.PerfLogEnd(CLASS_NAME, "prune-listing");
        perfLogger.PerfLogBegin(CLASS_NAME, "partition-retrieving");
        if (!partNames.isEmpty()) {
            partitions.addAll(Hive.get().getPartitionsByNames(tab, partNames));
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "partition-retrieving");
        return hasUnknownPartitions;
    }

    private static List<String> extractPartColNames(Table tab) {
        List<FieldSchema> pCols = tab.getPartCols();
        ArrayList<String> partCols = new ArrayList<String>(pCols.size());
        for (FieldSchema pCol : pCols) {
            partCols.add(pCol.getName());
        }
        return partCols;
    }

    private static List<PrimitiveTypeInfo> extractPartColTypes(Table tab) {
        List<FieldSchema> pCols = tab.getPartCols();
        ArrayList<PrimitiveTypeInfo> partColTypeInfos = new ArrayList<PrimitiveTypeInfo>(pCols.size());
        for (FieldSchema pCol : pCols) {
            partColTypeInfos.add(TypeInfoFactory.getPrimitiveTypeInfo(pCol.getType()));
        }
        return partColTypeInfos;
    }

    public static boolean prunePartitionNames(List<String> partColumnNames, List<PrimitiveTypeInfo> partColumnTypeInfos, ExprNodeGenericFuncDesc prunerExpr, String defaultPartitionName, List<String> partNames) throws HiveException, MetaException {
        ObjectPair<PrimitiveObjectInspector, ExprNodeEvaluator> handle = PartExprEvalUtils.prepareExpr(prunerExpr, partColumnNames, partColumnTypeInfos);
        boolean inPlace = partNames instanceof AbstractSequentialList;
        LinkedList partNamesSeq = inPlace ? partNames : new LinkedList(partNames);
        ArrayList values = new ArrayList(partColumnNames.size());
        for (int i = 0; i < partColumnNames.size(); ++i) {
            values.add(null);
        }
        boolean hasUnknownPartitions = false;
        Iterator partIter = partNamesSeq.iterator();
        while (partIter.hasNext()) {
            boolean isUnknown;
            String partName = (String)partIter.next();
            Warehouse.makeValsFromName((String)partName, values);
            ArrayList<Object> convertedValues = new ArrayList<Object>(values.size());
            for (int i = 0; i < values.size(); ++i) {
                Object o = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(partColumnTypeInfos.get(i))).convert(values.get(i));
                convertedValues.add(o);
            }
            Boolean isNeeded = (Boolean)PartExprEvalUtils.evaluateExprOnPart(handle, convertedValues);
            boolean bl = isUnknown = isNeeded == null;
            if (!isUnknown && !isNeeded.booleanValue()) {
                partIter.remove();
                continue;
            }
            if (isUnknown && values.contains(defaultPartitionName)) {
                LOG.debug((Object)("skipping default/bad partition: " + partName));
                partIter.remove();
                continue;
            }
            hasUnknownPartitions |= isUnknown;
            LOG.debug((Object)("retained " + (isUnknown ? "unknown " : "") + "partition: " + partName));
        }
        if (!inPlace) {
            partNames.clear();
            partNames.addAll(partNamesSeq);
        }
        return hasUnknownPartitions;
    }

    public static boolean hasColumnExpr(ExprNodeDesc desc) {
        if (desc == null) {
            return false;
        }
        if (desc instanceof ExprNodeColumnDesc) {
            return true;
        }
        List<ExprNodeDesc> children = desc.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (!PartitionPruner.hasColumnExpr(children.get(i))) continue;
                return true;
            }
        }
        return false;
    }
}

