/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MuxOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TezDummyStoreOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.BigTableSelectorForAutoSMJ;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.TezBucketJoinProcCtx;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CommonMergeJoinDesc;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.util.ReflectionUtils;

public class ConvertJoinMapJoin
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog((String)ConvertJoinMapJoin.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        OptimizeTezProcContext context = (OptimizeTezProcContext)procCtx;
        JoinOperator joinOp = (JoinOperator)nd;
        TezBucketJoinProcCtx tezBucketJoinProcCtx = new TezBucketJoinProcCtx(context.conf);
        if (!context.conf.getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN)) {
            Object retval = this.checkAndConvertSMBJoin(context, joinOp, tezBucketJoinProcCtx);
            if (retval == null) {
                return retval;
            }
            int pos = 0;
            this.convertJoinSMBJoin(joinOp, context, pos, 0, false, false);
            return null;
        }
        int numBuckets = -1;
        int estimatedBuckets = -1;
        if (context.conf.getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ)) {
            for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
                if (parentOp.getOpTraits().getNumBuckets() > 0) {
                    int n = numBuckets = numBuckets < parentOp.getOpTraits().getNumBuckets() ? parentOp.getOpTraits().getNumBuckets() : numBuckets;
                }
                if (!(parentOp instanceof ReduceSinkOperator)) continue;
                ReduceSinkOperator rs = (ReduceSinkOperator)parentOp;
                estimatedBuckets = estimatedBuckets < ((ReduceSinkDesc)rs.getConf()).getNumReducers() ? ((ReduceSinkDesc)rs.getConf()).getNumReducers() : estimatedBuckets;
            }
            if (numBuckets <= 0 && (numBuckets = estimatedBuckets) <= 0) {
                numBuckets = 1;
            }
        } else {
            numBuckets = 1;
        }
        LOG.info((Object)("Estimated number of buckets " + numBuckets));
        int mapJoinConversionPos = this.getMapJoinConversionPos(joinOp, context, numBuckets);
        if (mapJoinConversionPos < 0) {
            Object retval = this.checkAndConvertSMBJoin(context, joinOp, tezBucketJoinProcCtx);
            if (retval == null) {
                return retval;
            }
            this.convertJoinSMBJoin(joinOp, context, 0, 0, false, false);
            return null;
        }
        if (numBuckets > 1 && context.conf.getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ) && this.convertJoinBucketMapJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx)) {
            return null;
        }
        LOG.info((Object)"Convert to non-bucketed map join");
        mapJoinConversionPos = this.getMapJoinConversionPos(joinOp, context, 1);
        if (mapJoinConversionPos < 0) {
            int pos = 0;
            this.convertJoinSMBJoin(joinOp, context, pos, 0, false, false);
            return null;
        }
        MapJoinOperator mapJoinOp = this.convertJoinMapJoin(joinOp, context, mapJoinConversionPos);
        mapJoinOp.setOpTraits(new OpTraits(null, -1, null));
        mapJoinOp.setStatistics(joinOp.getStatistics());
        for (Operator<OperatorDesc> childOp : mapJoinOp.getChildOperators()) {
            this.setAllChildrenTraitsToNull(childOp);
        }
        return null;
    }

    private Object checkAndConvertSMBJoin(OptimizeTezProcContext context, JoinOperator joinOp, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        if (!context.conf.getBoolVar(HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN)) {
            this.convertJoinSMBJoin(joinOp, context, 0, 0, false, false);
            return null;
        }
        Class<?> bigTableMatcherClass = null;
        try {
            bigTableMatcherClass = Class.forName(HiveConf.getVar(context.parseContext.getConf(), HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN_BIGTABLE_SELECTOR));
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e.getMessage());
        }
        BigTableSelectorForAutoSMJ bigTableMatcher = (BigTableSelectorForAutoSMJ)ReflectionUtils.newInstance(bigTableMatcherClass, null);
        JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
        JoinCondDesc[] joinCondns = joinDesc.getConds();
        Set<Integer> joinCandidates = MapJoinProcessor.getBigTableCandidates(joinCondns);
        if (joinCandidates.isEmpty()) {
            return false;
        }
        int mapJoinConversionPos = bigTableMatcher.getBigTablePosition(context.parseContext, joinOp, joinCandidates);
        if (mapJoinConversionPos < 0) {
            int pos = 0;
            this.convertJoinSMBJoin(joinOp, context, pos, 0, false, false);
            return null;
        }
        if (this.checkConvertJoinSMBJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx)) {
            this.convertJoinSMBJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx.getNumBuckets(), tezBucketJoinProcCtx.isSubQuery(), true);
        } else {
            int pos = 0;
            this.convertJoinSMBJoin(joinOp, context, pos, 0, false, false);
        }
        return null;
    }

    private void convertJoinSMBJoin(JoinOperator joinOp, OptimizeTezProcContext context, int mapJoinConversionPos, int numBuckets, boolean isSubQuery, boolean adjustParentsChildren) throws SemanticException {
        List<Operator<? extends OperatorDesc>> parentOperators;
        int pos;
        ParseContext parseContext = context.parseContext;
        MapJoinDesc mapJoinDesc = null;
        if (adjustParentsChildren) {
            mapJoinDesc = MapJoinProcessor.getMapJoinDesc(context.conf, parseContext.getOpParseCtx(), joinOp, ((JoinDesc)joinOp.getConf()).isLeftInputJoin(), ((JoinDesc)joinOp.getConf()).getBaseSrc(), ((JoinDesc)joinOp.getConf()).getMapAliases(), mapJoinConversionPos, true);
        } else {
            JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
            mapJoinDesc = new MapJoinDesc(MapJoinProcessor.getKeys(((JoinDesc)joinOp.getConf()).isLeftInputJoin(), ((JoinDesc)joinOp.getConf()).getBaseSrc(), joinOp).getSecond(), null, joinDesc.getExprs(), null, null, joinDesc.getOutputColumnNames(), mapJoinConversionPos, joinDesc.getConds(), joinDesc.getFilters(), joinDesc.getNoOuterJoin(), null);
            mapJoinDesc.setNullSafes(joinDesc.getNullSafes());
            mapJoinDesc.setFilterMap(joinDesc.getFilterMap());
            mapJoinDesc.resetOrder();
        }
        CommonMergeJoinOperator mergeJoinOp = (CommonMergeJoinOperator)OperatorFactory.get(new CommonMergeJoinDesc(numBuckets, isSubQuery, mapJoinConversionPos, mapJoinDesc), joinOp.getSchema(), new Operator[0]);
        OpTraits opTraits = new OpTraits(joinOp.getOpTraits().getBucketColNames(), numBuckets, joinOp.getOpTraits().getSortCols());
        mergeJoinOp.setOpTraits(opTraits);
        mergeJoinOp.setStatistics(joinOp.getStatistics());
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            pos = parentOp.getChildOperators().indexOf(joinOp);
            parentOp.getChildOperators().remove(pos);
            parentOp.getChildOperators().add(pos, mergeJoinOp);
        }
        for (Operator<OperatorDesc> childOp : joinOp.getChildOperators()) {
            pos = childOp.getParentOperators().indexOf(joinOp);
            childOp.getParentOperators().remove(pos);
            childOp.getParentOperators().add(pos, mergeJoinOp);
        }
        List<Operator<? extends OperatorDesc>> childOperators = mergeJoinOp.getChildOperators();
        if (childOperators == null) {
            childOperators = new ArrayList<Operator<OperatorDesc>>();
            mergeJoinOp.setChildOperators(childOperators);
        }
        if ((parentOperators = mergeJoinOp.getParentOperators()) == null) {
            parentOperators = new ArrayList<Operator<OperatorDesc>>();
            mergeJoinOp.setParentOperators(parentOperators);
        }
        childOperators.clear();
        parentOperators.clear();
        childOperators.addAll(joinOp.getChildOperators());
        parentOperators.addAll(joinOp.getParentOperators());
        ((CommonMergeJoinDesc)mergeJoinOp.getConf()).setGenJoinKeys(false);
        if (adjustParentsChildren) {
            ((CommonMergeJoinDesc)mergeJoinOp.getConf()).setGenJoinKeys(true);
            ArrayList<Operator<OperatorDesc>> newParentOpList = new ArrayList<Operator<OperatorDesc>>();
            for (Operator<OperatorDesc> parentOp : mergeJoinOp.getParentOperators()) {
                for (Operator<OperatorDesc> grandParentOp : parentOp.getParentOperators()) {
                    grandParentOp.getChildOperators().remove(parentOp);
                    grandParentOp.getChildOperators().add(mergeJoinOp);
                    newParentOpList.add(grandParentOp);
                }
            }
            mergeJoinOp.getParentOperators().clear();
            mergeJoinOp.getParentOperators().addAll(newParentOpList);
            ArrayList<Operator<OperatorDesc>> parentOps = new ArrayList<Operator<OperatorDesc>>(mergeJoinOp.getParentOperators());
            for (Operator operator : parentOps) {
                int parentIndex = mergeJoinOp.getParentOperators().indexOf(operator);
                if (parentIndex == mapJoinConversionPos) continue;
                TezDummyStoreOperator dummyStoreOp = new TezDummyStoreOperator();
                dummyStoreOp.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
                dummyStoreOp.setChildOperators(new ArrayList<Operator<? extends OperatorDesc>>());
                dummyStoreOp.getChildOperators().add(mergeJoinOp);
                int index = operator.getChildOperators().indexOf(mergeJoinOp);
                operator.getChildOperators().remove(index);
                operator.getChildOperators().add(index, dummyStoreOp);
                dummyStoreOp.getParentOperators().add(operator);
                mergeJoinOp.getParentOperators().remove(parentIndex);
                mergeJoinOp.getParentOperators().add(parentIndex, dummyStoreOp);
            }
        }
        mergeJoinOp.cloneOriginalParentsList(mergeJoinOp.getParentOperators());
    }

    private void setAllChildrenTraitsToNull(Operator<? extends OperatorDesc> currentOp) {
        if (currentOp instanceof ReduceSinkOperator) {
            return;
        }
        currentOp.setOpTraits(new OpTraits(null, -1, null));
        for (Operator<OperatorDesc> childOp : currentOp.getChildOperators()) {
            if (childOp instanceof ReduceSinkOperator || childOp instanceof GroupByOperator) break;
            this.setAllChildrenTraitsToNull(childOp);
        }
    }

    private boolean convertJoinBucketMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        if (!this.checkConvertJoinBucketMapJoin(joinOp, context, bigTablePosition, tezBucketJoinProcCtx)) {
            LOG.info((Object)"Check conversion to bucket map join failed.");
            return false;
        }
        MapJoinOperator mapJoinOp = this.convertJoinMapJoin(joinOp, context, bigTablePosition);
        MapJoinDesc joinDesc = (MapJoinDesc)mapJoinOp.getConf();
        joinDesc.setBucketMapJoin(true);
        OpTraits opTraits = new OpTraits(joinOp.getOpTraits().getBucketColNames(), tezBucketJoinProcCtx.getNumBuckets(), null);
        mapJoinOp.setOpTraits(opTraits);
        mapJoinOp.setStatistics(joinOp.getStatistics());
        this.setNumberOfBucketsOnChildren(mapJoinOp);
        HashMap<String, Integer> bigTableBucketNumMapping = new HashMap<String, Integer>();
        bigTableBucketNumMapping.put(joinDesc.getBigTableAlias(), tezBucketJoinProcCtx.getNumBuckets());
        joinDesc.setBigTableBucketNumMapping(bigTableBucketNumMapping);
        LOG.info((Object)("Setting legacy map join to " + !tezBucketJoinProcCtx.isSubQuery()));
        joinDesc.setCustomBucketMapJoin(!tezBucketJoinProcCtx.isSubQuery());
        return true;
    }

    private boolean checkConvertJoinSMBJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        ReduceSinkOperator bigTableRS = (ReduceSinkOperator)joinOp.getParentOperators().get(bigTablePosition);
        int numBuckets = bigTableRS.getParentOperators().get(0).getOpTraits().getNumBuckets();
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            if (!(parentOp instanceof ReduceSinkOperator)) {
                LOG.info((Object)"Found correlation optimizer operators. Cannot convert to SMB at this time.");
                return false;
            }
            ReduceSinkOperator rsOp = (ReduceSinkOperator)parentOp;
            if (!this.checkColEquality(rsOp.getParentOperators().get(0).getOpTraits().getSortCols(), rsOp.getOpTraits().getSortCols(), rsOp.getColumnExprMap(), tezBucketJoinProcCtx)) {
                LOG.info((Object)"We cannot convert to SMB because the sort column names do not match.");
                return false;
            }
            if (this.checkColEquality(rsOp.getParentOperators().get(0).getOpTraits().getBucketColNames(), rsOp.getOpTraits().getBucketColNames(), rsOp.getColumnExprMap(), tezBucketJoinProcCtx)) continue;
            LOG.info((Object)"We cannot convert to SMB because bucket column names do not match.");
            return false;
        }
        boolean isSubQuery = false;
        if (numBuckets < 0) {
            isSubQuery = true;
            numBuckets = ((ReduceSinkDesc)bigTableRS.getConf()).getNumReducers();
        }
        tezBucketJoinProcCtx.setNumBuckets(numBuckets);
        tezBucketJoinProcCtx.setIsSubQuery(isSubQuery);
        LOG.info((Object)"We can convert the join to an SMB join.");
        return true;
    }

    private void setNumberOfBucketsOnChildren(Operator<? extends OperatorDesc> currentOp) {
        int numBuckets = currentOp.getOpTraits().getNumBuckets();
        for (Operator<OperatorDesc> op : currentOp.getChildOperators()) {
            if (op instanceof ReduceSinkOperator || op instanceof GroupByOperator) continue;
            op.getOpTraits().setNumBuckets(numBuckets);
            this.setNumberOfBucketsOnChildren(op);
        }
    }

    private boolean checkConvertJoinBucketMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        if (!(joinOp.getParentOperators().get(0) instanceof ReduceSinkOperator)) {
            LOG.info((Object)("Operator is " + joinOp.getParentOperators().get(0).getName() + ". Cannot convert to bucket map join"));
            return false;
        }
        ReduceSinkOperator rs = (ReduceSinkOperator)joinOp.getParentOperators().get(bigTablePosition);
        List<List<String>> parentColNames = rs.getOpTraits().getBucketColNames();
        Operator<OperatorDesc> parentOfParent = rs.getParentOperators().get(0);
        List<List<String>> grandParentColNames = parentOfParent.getOpTraits().getBucketColNames();
        int numBuckets = parentOfParent.getOpTraits().getNumBuckets();
        if (!this.checkColEquality(grandParentColNames, parentColNames, rs.getColumnExprMap(), tezBucketJoinProcCtx)) {
            LOG.info((Object)"No info available to check for bucket map join. Cannot convert");
            return false;
        }
        boolean isSubQuery = false;
        if (numBuckets < 0) {
            isSubQuery = true;
            numBuckets = ((ReduceSinkDesc)rs.getConf()).getNumReducers();
        }
        tezBucketJoinProcCtx.setNumBuckets(numBuckets);
        tezBucketJoinProcCtx.setIsSubQuery(isSubQuery);
        return true;
    }

    private boolean checkColEquality(List<List<String>> grandParentColNames, List<List<String>> parentColNames, Map<String, ExprNodeDesc> colExprMap, TezBucketJoinProcCtx tezBucketJoinProcCtx) {
        if (grandParentColNames == null || parentColNames == null) {
            return false;
        }
        if (parentColNames != null && !parentColNames.isEmpty()) {
            block0: for (List<String> listBucketCols : grandParentColNames) {
                if (listBucketCols.isEmpty()) continue;
                int colCount = 0;
                for (String colName : parentColNames.get(0)) {
                    ExprNodeDesc exprNodeDesc = colExprMap.get(colName);
                    if (exprNodeDesc instanceof ExprNodeColumnDesc) {
                        if (!((ExprNodeColumnDesc)exprNodeDesc).getColumn().equals(listBucketCols.get(colCount))) continue block0;
                        ++colCount;
                    }
                    if (colCount != parentColNames.get(0).size()) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int getMapJoinConversionPos(JoinOperator joinOp, OptimizeTezProcContext context, int buckets) throws SemanticException {
        if (((JoinDesc)joinOp.getConf()).getConds().length > 1) {
            boolean hasOuter = false;
            block4: for (JoinCondDesc joinCondDesc : ((JoinDesc)joinOp.getConf()).getConds()) {
                switch (joinCondDesc.getType()) {
                    case 0: 
                    case 4: 
                    case 5: {
                        hasOuter = false;
                        continue block4;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        hasOuter = true;
                        continue block4;
                    }
                    default: {
                        throw new SemanticException("Unknown join type " + joinCondDesc.getType());
                    }
                }
            }
            if (hasOuter) {
                return -1;
            }
        }
        Set<Integer> bigTableCandidateSet = MapJoinProcessor.getBigTableCandidates(((JoinDesc)joinOp.getConf()).getConds());
        long maxSize = context.conf.getLongVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
        int bigTablePosition = -1;
        Statistics bigInputStat = null;
        long totalSize = 0L;
        int pos = 0;
        boolean bigTableFound = false;
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            Statistics currInputStat = parentOp.getStatistics();
            if (currInputStat == null) {
                LOG.warn((Object)("Couldn't get statistics from: " + parentOp));
                return -1;
            }
            long inputSize = currInputStat.getDataSize();
            if (bigInputStat == null || bigInputStat != null && inputSize > bigInputStat.getDataSize()) {
                if (bigTableFound) {
                    return -1;
                }
                if (inputSize / (long)buckets > maxSize) {
                    if (!bigTableCandidateSet.contains(pos)) {
                        return -1;
                    }
                    bigTableFound = true;
                }
                if (bigInputStat != null) {
                    totalSize += bigInputStat.getDataSize();
                }
                if (totalSize / (long)buckets > maxSize) {
                    return -1;
                }
                if (bigTableCandidateSet.contains(pos)) {
                    bigTablePosition = pos;
                    bigInputStat = currInputStat;
                }
            } else if ((totalSize += currInputStat.getDataSize()) / (long)buckets > maxSize) {
                return -1;
            }
            ++pos;
        }
        return bigTablePosition;
    }

    public MapJoinOperator convertJoinMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition) throws SemanticException {
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            if (!(parentOp instanceof MuxOperator)) continue;
            return null;
        }
        ParseContext parseContext = context.parseContext;
        MapJoinOperator mapJoinOp = MapJoinProcessor.convertJoinOpMapJoinOp(context.conf, parseContext.getOpParseCtx(), joinOp, ((JoinDesc)joinOp.getConf()).isLeftInputJoin(), ((JoinDesc)joinOp.getConf()).getBaseSrc(), ((JoinDesc)joinOp.getConf()).getMapAliases(), bigTablePosition, true);
        Operator<OperatorDesc> parentBigTableOp = mapJoinOp.getParentOperators().get(bigTablePosition);
        if (parentBigTableOp instanceof ReduceSinkOperator) {
            for (Operator<OperatorDesc> p : parentBigTableOp.getParentOperators()) {
                HashSet<Operator<OperatorDesc>> dynamicPartitionOperators = new HashSet<Operator<OperatorDesc>>();
                for (Operator<OperatorDesc> c : p.getChildOperators()) {
                    if (!this.hasDynamicPartitionBroadcast(c)) continue;
                    dynamicPartitionOperators.add(c);
                }
                for (Operator<OperatorDesc> c : dynamicPartitionOperators) {
                    p.removeChild(c);
                }
            }
            mapJoinOp.getParentOperators().remove(bigTablePosition);
            if (!mapJoinOp.getParentOperators().contains(parentBigTableOp.getParentOperators().get(0))) {
                mapJoinOp.getParentOperators().add(bigTablePosition, parentBigTableOp.getParentOperators().get(0));
            }
            parentBigTableOp.getParentOperators().get(0).removeChild(parentBigTableOp);
            for (Operator<OperatorDesc> op : mapJoinOp.getParentOperators()) {
                if (!op.getChildOperators().contains(mapJoinOp)) {
                    op.getChildOperators().add(mapJoinOp);
                }
                op.getChildOperators().remove(joinOp);
            }
        }
        return mapJoinOp;
    }

    private boolean hasDynamicPartitionBroadcast(Operator<?> parent) {
        boolean hasDynamicPartitionPruning = false;
        block0: for (Operator<OperatorDesc> op : parent.getChildOperators()) {
            while (op != null) {
                if (op instanceof AppMasterEventOperator && op.getConf() instanceof DynamicPruningEventDesc) {
                    hasDynamicPartitionPruning = true;
                    continue block0;
                }
                if (op instanceof ReduceSinkOperator || op instanceof FileSinkOperator || op.getChildOperators().size() != 1) continue block0;
                op = op.getChildOperators().get(0);
            }
        }
        return hasDynamicPartitionPruning;
    }
}

