/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;

abstract class InStream
extends InputStream {
    private static final Log LOG = LogFactory.getLog(InStream.class);

    InStream() {
    }

    public abstract void seek(PositionProvider var1) throws IOException;

    public static InStream create(String name, ByteBuffer[] input, long[] offsets, long length, CompressionCodec codec, int bufferSize) throws IOException {
        if (codec == null) {
            return new UncompressedStream(name, input, offsets, length);
        }
        return new CompressedStream(name, input, offsets, length, codec, bufferSize);
    }

    private static class CompressedStream
    extends InStream {
        private final String name;
        private final ByteBuffer[] bytes;
        private final long[] offsets;
        private final int bufferSize;
        private final long length;
        private ByteBuffer uncompressed;
        private final CompressionCodec codec;
        private ByteBuffer compressed;
        private long currentOffset;
        private int currentRange;
        private boolean isUncompressedOriginal;
        private boolean isDirect = false;

        public CompressedStream(String name, ByteBuffer[] input, long[] offsets, long length, CompressionCodec codec, int bufferSize) {
            this.bytes = input;
            this.name = name;
            this.codec = codec;
            this.length = length;
            if (this.length > 0L) {
                this.isDirect = this.bytes[0].isDirect();
            }
            this.offsets = offsets;
            this.bufferSize = bufferSize;
            this.currentOffset = 0L;
            this.currentRange = 0;
        }

        private ByteBuffer allocateBuffer(int size) {
            if (this.isDirect) {
                return ByteBuffer.allocateDirect(size);
            }
            return ByteBuffer.allocate(size);
        }

        private void readHeader() throws IOException {
            if (this.compressed == null || this.compressed.remaining() <= 0) {
                this.seek(this.currentOffset);
            }
            if (this.compressed.remaining() > 3) {
                int b0 = this.compressed.get() & 0xFF;
                int b1 = this.compressed.get() & 0xFF;
                int b2 = this.compressed.get() & 0xFF;
                boolean isOriginal = (b0 & 1) == 1;
                int chunkLength = b2 << 15 | b1 << 7 | b0 >> 1;
                if (chunkLength > this.bufferSize) {
                    throw new IllegalArgumentException("Buffer size too small. size = " + this.bufferSize + " needed = " + chunkLength);
                }
                this.currentOffset += 3L;
                ByteBuffer slice = this.slice(chunkLength);
                if (isOriginal) {
                    this.uncompressed = slice;
                    this.isUncompressedOriginal = true;
                } else {
                    if (this.isUncompressedOriginal) {
                        this.uncompressed = this.allocateBuffer(this.bufferSize);
                        this.isUncompressedOriginal = false;
                    } else if (this.uncompressed == null) {
                        this.uncompressed = this.allocateBuffer(this.bufferSize);
                    } else {
                        this.uncompressed.clear();
                    }
                    this.codec.decompress(slice, this.uncompressed);
                }
            } else {
                throw new IllegalStateException("Can't read header at " + this);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return -1;
                }
                this.readHeader();
            }
            return 0xFF & this.uncompressed.get();
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return -1;
                }
                this.readHeader();
            }
            int actualLength = Math.min(length, this.uncompressed.remaining());
            this.uncompressed.get(data, offset, actualLength);
            return actualLength;
        }

        @Override
        public int available() throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return 0;
                }
                this.readHeader();
            }
            return this.uncompressed.remaining();
        }

        @Override
        public void close() {
            this.uncompressed = null;
            this.compressed = null;
            this.currentRange = this.bytes.length;
            this.currentOffset = this.length;
            for (int i = 0; i < this.bytes.length; ++i) {
                this.bytes[i] = null;
            }
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.seek(index.getNext());
            long uncompressedBytes = index.getNext();
            if (uncompressedBytes != 0L) {
                this.readHeader();
                this.uncompressed.position(this.uncompressed.position() + (int)uncompressedBytes);
            } else if (this.uncompressed != null) {
                this.uncompressed.position(this.uncompressed.limit());
            }
        }

        private ByteBuffer slice(int chunkLength) throws IOException {
            int len = chunkLength;
            long oldOffset = this.currentOffset;
            if (this.compressed.remaining() >= len) {
                ByteBuffer slice = this.compressed.slice();
                slice.limit(len);
                this.currentOffset += (long)len;
                this.compressed.position(this.compressed.position() + len);
                return slice;
            }
            if (this.currentRange >= this.bytes.length - 1) {
                throw new IOException("EOF in " + this + " while trying to read " + chunkLength + " bytes");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Crossing into next BufferChunk because compressed only has %d bytes (needs %d)", this.compressed.remaining(), len));
            }
            ByteBuffer copy = this.allocateBuffer(chunkLength);
            this.currentOffset += (long)this.compressed.remaining();
            len -= this.compressed.remaining();
            copy.put(this.compressed);
            while (len > 0 && ++this.currentRange < this.bytes.length) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Read slow-path, >1 cross block reads with %s", this.toString()));
                }
                this.compressed = this.bytes[this.currentRange].duplicate();
                if (this.compressed.remaining() >= len) {
                    ByteBuffer slice = this.compressed.slice();
                    slice.limit(len);
                    copy.put(slice);
                    this.currentOffset += (long)len;
                    this.compressed.position(this.compressed.position() + len);
                    return copy;
                }
                this.currentOffset += (long)this.compressed.remaining();
                len -= this.compressed.remaining();
                copy.put(this.compressed);
            }
            this.seek(oldOffset);
            throw new IOException("EOF in " + this + " while trying to read " + chunkLength + " bytes");
        }

        private void seek(long desired) throws IOException {
            for (int i = 0; i < this.bytes.length; ++i) {
                if (this.offsets[i] > desired || desired - this.offsets[i] >= (long)this.bytes[i].remaining()) continue;
                this.currentRange = i;
                this.compressed = this.bytes[i].duplicate();
                int pos = this.compressed.position();
                this.compressed.position(pos += (int)(desired - this.offsets[i]));
                this.currentOffset = desired;
                return;
            }
            int segments = this.bytes.length;
            if (segments != 0 && desired == this.offsets[segments - 1] + (long)this.bytes[segments - 1].remaining()) {
                this.currentRange = segments - 1;
                this.compressed = this.bytes[this.currentRange].duplicate();
                this.compressed.position(this.compressed.limit());
                this.currentOffset = desired;
                return;
            }
            throw new IOException("Seek outside of data in " + this + " to " + desired);
        }

        private String rangeString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.offsets.length; ++i) {
                if (i != 0) {
                    builder.append("; ");
                }
                builder.append(" range " + i + " = " + this.offsets[i] + " to " + this.bytes[i].remaining());
            }
            return builder.toString();
        }

        public String toString() {
            return "compressed stream " + this.name + " position: " + this.currentOffset + " length: " + this.length + " range: " + this.currentRange + " offset: " + (this.compressed == null ? 0 : this.compressed.position()) + " limit: " + (this.compressed == null ? 0 : this.compressed.limit()) + this.rangeString() + (this.uncompressed == null ? "" : " uncompressed: " + this.uncompressed.position() + " to " + this.uncompressed.limit());
        }
    }

    private static class UncompressedStream
    extends InStream {
        private final String name;
        private final ByteBuffer[] bytes;
        private final long[] offsets;
        private final long length;
        private long currentOffset;
        private ByteBuffer range;
        private int currentRange;

        public UncompressedStream(String name, ByteBuffer[] input, long[] offsets, long length) {
            this.name = name;
            this.bytes = input;
            this.offsets = offsets;
            this.length = length;
            this.currentRange = 0;
            this.currentOffset = 0L;
        }

        @Override
        public int read() {
            if (this.range == null || this.range.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return -1;
                }
                this.seek(this.currentOffset);
            }
            ++this.currentOffset;
            return 0xFF & this.range.get();
        }

        @Override
        public int read(byte[] data, int offset, int length) {
            if (this.range == null || this.range.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return -1;
                }
                this.seek(this.currentOffset);
            }
            int actualLength = Math.min(length, this.range.remaining());
            this.range.get(data, offset, actualLength);
            this.currentOffset += (long)actualLength;
            return actualLength;
        }

        @Override
        public int available() {
            if (this.range != null && this.range.remaining() > 0) {
                return this.range.remaining();
            }
            return (int)(this.length - this.currentOffset);
        }

        @Override
        public void close() {
            this.currentRange = this.bytes.length;
            this.currentOffset = this.length;
            for (int i = 0; i < this.bytes.length; ++i) {
                this.bytes[i] = null;
            }
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.seek(index.getNext());
        }

        public void seek(long desired) {
            for (int i = 0; i < this.bytes.length; ++i) {
                if (this.offsets[i] > desired || desired - this.offsets[i] >= (long)this.bytes[i].remaining()) continue;
                this.currentOffset = desired;
                this.currentRange = i;
                this.range = this.bytes[i].duplicate();
                int pos = this.range.position();
                this.range.position(pos += (int)(desired - this.offsets[i]));
                return;
            }
            throw new IllegalArgumentException("Seek in " + this.name + " to " + desired + " is outside of the data");
        }

        public String toString() {
            return "uncompressed stream " + this.name + " position: " + this.currentOffset + " length: " + this.length + " range: " + this.currentRange + " offset: " + (this.range == null ? 0 : this.range.position()) + " limit: " + (this.range == null ? 0 : this.range.limit());
        }
    }
}

