/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.ReduceRecordSource;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValuesReader;

public class ReduceRecordProcessor
extends RecordProcessor {
    private static final String REDUCE_PLAN_KEY = "__REDUCE_PLAN__";
    public static final Log l4j = LogFactory.getLog(ReduceRecordProcessor.class);
    private ReduceWork redWork;
    private Operator<?> reducer;
    private ReduceRecordSource[] sources;
    private final byte position = 0;
    private boolean abort;

    @Override
    void init(JobConf jconf, ProcessorContext processorContext, MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        this.perfLogger.PerfLogBegin(this.CLASS_NAME, "TezInitializeOperators");
        super.init(jconf, processorContext, mrReporter, inputs, outputs);
        ObjectCache cache = ObjectCacheFactory.getCache((Configuration)jconf);
        this.redWork = (ReduceWork)cache.retrieve(REDUCE_PLAN_KEY);
        if (this.redWork == null) {
            this.redWork = Utilities.getReduceWork((Configuration)jconf);
            cache.cache(REDUCE_PLAN_KEY, this.redWork);
        } else {
            Utilities.setReduceWork((Configuration)jconf, this.redWork);
        }
        this.reducer = this.redWork.getReducer();
        this.reducer.getParentOperators().clear();
        this.reducer.setParentOperators(null);
        int numTags = this.redWork.getTagToValueDesc().size();
        ObjectInspector[] ois = new ObjectInspector[numTags];
        this.sources = new ReduceRecordSource[numTags];
        for (int tag = 0; tag < this.redWork.getTagToValueDesc().size(); ++tag) {
            TableDesc keyTableDesc = this.redWork.getKeyDesc();
            TableDesc tableDesc = this.redWork.getTagToValueDesc().get(tag);
            KeyValuesReader reader = (KeyValuesReader)inputs.get(this.redWork.getTagToInput().get(tag)).getReader();
            this.sources[tag] = new ReduceRecordSource();
            this.sources[tag].init(jconf, this.reducer, this.redWork.getVectorMode(), keyTableDesc, tableDesc, reader, tag == 0, (byte)tag, this.redWork.getAllScratchColumnVectorTypeMaps());
            ois[tag] = this.sources[tag].getObjectInspector();
        }
        MapredContext.init(false, new JobConf((Configuration)jconf));
        ((TezContext)MapredContext.get()).setInputs(inputs);
        ((TezContext)MapredContext.get()).setTezProcessorContext(processorContext);
        ((TezContext)MapredContext.get()).setRecordSources(this.sources);
        try {
            l4j.info((Object)this.reducer.dump(0));
            this.reducer.initialize((Configuration)jconf, ois);
            List<HashTableDummyOperator> dummyOps = this.redWork.getDummyOps();
            if (dummyOps != null) {
                for (Operator operator : dummyOps) {
                    operator.initialize((Configuration)jconf, null);
                }
            }
            LinkedList<Operator<? extends OperatorDesc>> children = new LinkedList<Operator<? extends OperatorDesc>>();
            children.add(this.reducer);
            if (dummyOps != null) {
                children.addAll(dummyOps);
            }
            this.createOutputMap();
            OperatorUtils.setChildrenCollector(children, this.outMap);
            this.reducer.setReporter((Reporter)this.reporter);
            MapredContext.get().setReporter((Reporter)this.reporter);
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Reduce operator initialization failed", e);
        }
        this.perfLogger.PerfLogEnd(this.CLASS_NAME, "TezInitializeOperators");
    }

    @Override
    void run() throws Exception {
        List<LogicalInput> shuffleInputs = this.getShuffleInputs(this.inputs);
        if (shuffleInputs != null) {
            l4j.info((Object)"Waiting for ShuffleInputs to become ready");
            this.processorContext.waitForAllInputsReady(new ArrayList<LogicalInput>(shuffleInputs));
        }
        for (Map.Entry outputEntry : this.outputs.entrySet()) {
            l4j.info((Object)("Starting Output: " + (String)outputEntry.getKey()));
            ((LogicalOutput)outputEntry.getValue()).start();
            ((TezProcessor.TezKVOutputCollector)this.outMap.get(outputEntry.getKey())).initialize();
        }
        while (this.sources[0].pushRecord()) {
        }
    }

    private List<LogicalInput> getShuffleInputs(Map<String, LogicalInput> inputs) {
        Map<Integer, String> tagToinput = this.redWork.getTagToInput();
        ArrayList<LogicalInput> shuffleInputs = new ArrayList<LogicalInput>();
        for (String inpStr : tagToinput.values()) {
            if (inputs.get(inpStr) == null) {
                throw new AssertionError((Object)("Cound not find input: " + inpStr));
            }
            shuffleInputs.add(inputs.get(inpStr));
        }
        return shuffleInputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    void close() {
        try {
            void var3_7;
            ReduceRecordSource[] arr$ = this.sources;
            int len$ = arr$.length;
            boolean bl = false;
            while (var3_7 < len$) {
                ReduceRecordSource rs = arr$[var3_7];
                this.abort = this.abort && rs.close();
                ++var3_7;
            }
            this.reducer.close(this.abort);
            List<HashTableDummyOperator> dummyOps = this.redWork.getDummyOps();
            if (dummyOps != null) {
                for (Operator operator : dummyOps) {
                    operator.close(this.abort);
                }
            }
            ExecMapper.ReportStats rps = new ExecMapper.ReportStats((Reporter)this.reporter, (Configuration)this.jconf);
            this.reducer.preorderMap(rps);
        }
        catch (Exception e) {
            if (!this.abort) {
                l4j.error((Object)"Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators: " + e.getMessage(), e);
            }
        }
        finally {
            Utilities.clearWorkMap();
            MapredContext.close();
        }
    }
}

