/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;

public class MapredContext {
    private static final Log logger = LogFactory.getLog((String)"MapredContext");
    private static final ThreadLocal<MapredContext> contexts = new ThreadLocal();
    private final boolean isMap;
    private final JobConf jobConf;
    private final List<Closeable> udfs;
    private Reporter reporter;

    public static MapredContext get() {
        return contexts.get();
    }

    public static MapredContext init(boolean isMap, JobConf jobConf) {
        MapredContext context = HiveConf.getVar((Configuration)jobConf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") ? new TezContext(isMap, jobConf) : new MapredContext(isMap, jobConf);
        contexts.set(context);
        return context;
    }

    public static void close() {
        MapredContext context = contexts.get();
        if (context != null) {
            context.closeAll();
        }
        contexts.remove();
    }

    protected MapredContext(boolean isMap, JobConf jobConf) {
        this.isMap = isMap;
        this.jobConf = jobConf;
        this.udfs = new ArrayList<Closeable>();
    }

    public boolean isMap() {
        return this.isMap;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    private void registerCloseable(Closeable closeable) {
        this.udfs.add(closeable);
    }

    private void closeAll() {
        for (Closeable eval : this.udfs) {
            try {
                eval.close();
            }
            catch (IOException e) {
                logger.info((Object)("Hit error while closing udf " + eval));
            }
        }
        this.udfs.clear();
    }

    void setup(GenericUDF genericUDF) {
        if (this.needConfigure(genericUDF)) {
            genericUDF.configure(this);
        }
        if (this.needClose(genericUDF)) {
            this.registerCloseable(genericUDF);
        }
    }

    void setup(GenericUDAFEvaluator genericUDAF) {
        if (this.needConfigure(genericUDAF)) {
            genericUDAF.configure(this);
        }
        if (this.needClose(genericUDAF)) {
            this.registerCloseable(genericUDAF);
        }
    }

    void setup(GenericUDTF genericUDTF) {
        if (this.needConfigure(genericUDTF)) {
            genericUDTF.configure(this);
        }
    }

    private boolean needConfigure(Object func) {
        try {
            Method initMethod = func.getClass().getMethod("configure", MapredContext.class);
            return initMethod.getDeclaringClass() != GenericUDF.class && initMethod.getDeclaringClass() != GenericUDAFEvaluator.class && initMethod.getDeclaringClass() != GenericUDTF.class;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean needClose(Closeable func) {
        try {
            Method closeMethod = func.getClass().getMethod("close", new Class[0]);
            return closeMethod.getDeclaringClass() != GenericUDF.class && closeMethod.getDeclaringClass() != GenericUDAFEvaluator.class;
        }
        catch (Exception e) {
            return false;
        }
    }
}

