/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseTypeParams;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeSpec;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public final class PrimitiveObjectInspectorUtils {
    private static Log LOG = LogFactory.getLog(PrimitiveObjectInspectorUtils.class);
    static final Map<PrimitiveObjectInspector.PrimitiveCategory, PrimitiveTypeEntry> primitiveCategoryToTypeEntry = new HashMap<PrimitiveObjectInspector.PrimitiveCategory, PrimitiveTypeEntry>();
    static final Map<Class<?>, PrimitiveTypeEntry> primitiveJavaTypeToTypeEntry = new HashMap();
    static final Map<Class<?>, PrimitiveTypeEntry> primitiveJavaClassToTypeEntry = new HashMap();
    static final Map<Class<?>, PrimitiveTypeEntry> primitiveWritableClassToTypeEntry = new HashMap();
    static final Map<String, PrimitiveTypeEntry> typeNameToTypeEntry = new HashMap<String, PrimitiveTypeEntry>();
    public static final PrimitiveTypeEntry binaryTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.BINARY, "binary", byte[].class, byte[].class, BytesWritable.class, null);
    public static final PrimitiveTypeEntry stringTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.STRING, "string", null, String.class, Text.class, null);
    public static final PrimitiveTypeEntry booleanTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, "boolean", Boolean.TYPE, Boolean.class, BooleanWritable.class, null);
    public static final PrimitiveTypeEntry intTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.INT, "int", Integer.TYPE, Integer.class, IntWritable.class, null);
    public static final PrimitiveTypeEntry longTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.LONG, "bigint", Long.TYPE, Long.class, LongWritable.class, null);
    public static final PrimitiveTypeEntry floatTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, "float", Float.TYPE, Float.class, FloatWritable.class, null);
    public static final PrimitiveTypeEntry voidTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.VOID, "void", Void.TYPE, Void.class, NullWritable.class, null);
    public static final PrimitiveTypeEntry doubleTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, "double", Double.TYPE, Double.class, DoubleWritable.class, null);
    public static final PrimitiveTypeEntry byteTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.BYTE, "tinyint", Byte.TYPE, Byte.class, ByteWritable.class, null);
    public static final PrimitiveTypeEntry shortTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.SHORT, "smallint", Short.TYPE, Short.class, ShortWritable.class, null);
    public static final PrimitiveTypeEntry dateTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.DATE, "date", null, Date.class, DateWritable.class, null);
    public static final PrimitiveTypeEntry timestampTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, "timestamp", null, Timestamp.class, TimestampWritable.class, null);
    public static final PrimitiveTypeEntry decimalTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.DECIMAL, "decimal", null, HiveDecimal.class, HiveDecimalWritable.class, null);
    public static final PrimitiveTypeEntry varcharTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, "varchar", null, HiveVarchar.class, HiveVarcharWritable.class, VarcharTypeParams.class);
    public static final PrimitiveTypeEntry unknownTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN, "unknown", null, Object.class, null, null);

    static void addParameterizedType(PrimitiveTypeEntry t) {
        typeNameToTypeEntry.put(t.toString(), t);
    }

    static void registerType(PrimitiveTypeEntry t) {
        if (t.primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN) {
            primitiveCategoryToTypeEntry.put(t.primitiveCategory, t);
        }
        if (t.primitiveJavaType != null) {
            primitiveJavaTypeToTypeEntry.put(t.primitiveJavaType, t);
        }
        if (t.primitiveJavaClass != null) {
            primitiveJavaClassToTypeEntry.put(t.primitiveJavaClass, t);
        }
        if (t.primitiveWritableClass != null) {
            primitiveWritableClassToTypeEntry.put(t.primitiveWritableClass, t);
        }
        if (t.typeName != null) {
            typeNameToTypeEntry.put(t.typeName, t);
        }
    }

    public static Class<?> primitiveJavaTypeToClass(Class<?> clazz) {
        PrimitiveTypeEntry t = primitiveJavaTypeToTypeEntry.get(clazz);
        return t == null ? clazz : t.primitiveJavaClass;
    }

    public static boolean isPrimitiveJava(Class<?> clazz) {
        return primitiveJavaTypeToTypeEntry.get(clazz) != null || primitiveJavaClassToTypeEntry.get(clazz) != null;
    }

    public static boolean isPrimitiveJavaType(Class<?> clazz) {
        return primitiveJavaTypeToTypeEntry.get(clazz) != null;
    }

    public static boolean isPrimitiveJavaClass(Class<?> clazz) {
        return primitiveJavaClassToTypeEntry.get(clazz) != null;
    }

    public static boolean isPrimitiveWritableClass(Class<?> clazz) {
        return primitiveWritableClassToTypeEntry.get(clazz) != null;
    }

    public static String getTypeNameFromPrimitiveJava(Class<?> clazz) {
        PrimitiveTypeEntry t = primitiveJavaTypeToTypeEntry.get(clazz);
        if (t == null) {
            t = primitiveJavaClassToTypeEntry.get(clazz);
        }
        return t == null ? null : t.typeName;
    }

    public static String getTypeNameFromPrimitiveWritable(Class<?> clazz) {
        PrimitiveTypeEntry t = primitiveWritableClassToTypeEntry.get(clazz);
        return t == null ? null : t.typeName;
    }

    public static PrimitiveTypeEntry getTypeEntryFromPrimitiveCategory(PrimitiveObjectInspector.PrimitiveCategory category) {
        return primitiveCategoryToTypeEntry.get((Object)category);
    }

    public static PrimitiveTypeEntry getTypeEntryFromPrimitiveJava(Class<?> clazz) {
        PrimitiveTypeEntry t = primitiveJavaTypeToTypeEntry.get(clazz);
        if (t == null) {
            t = primitiveJavaClassToTypeEntry.get(clazz);
        }
        return t;
    }

    public static PrimitiveTypeEntry getTypeEntryFromPrimitiveJavaType(Class<?> clazz) {
        return primitiveJavaTypeToTypeEntry.get(clazz);
    }

    public static PrimitiveTypeEntry getTypeEntryFromPrimitiveJavaClass(Class<?> clazz) {
        return primitiveJavaClassToTypeEntry.get(clazz);
    }

    public static PrimitiveTypeEntry getTypeEntryFromPrimitiveWritableClass(Class<?> clazz) {
        return primitiveWritableClassToTypeEntry.get(clazz);
    }

    public static PrimitiveTypeEntry getTypeEntryFromTypeName(String typeName) {
        return typeNameToTypeEntry.get(typeName);
    }

    public static PrimitiveTypeEntry getTypeEntryFromTypeSpecs(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, BaseTypeParams typeParams) {
        if (typeParams == null) {
            return PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveCategory(primitiveCategory);
        }
        String typeString = primitiveCategory.toString().toLowerCase();
        PrimitiveTypeEntry typeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(typeString = typeString + typeParams.toString());
        if (typeEntry == null) {
            typeEntry = (PrimitiveTypeEntry)PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveCategory(primitiveCategory).clone();
            if (!typeEntry.isParameterized()) {
                throw new IllegalArgumentException((Object)((Object)primitiveCategory) + " type was being used with type parameters " + typeParams + ", which should not be allowed");
            }
            typeEntry.typeParams = typeParams;
            PrimitiveObjectInspectorUtils.addParameterizedType(typeEntry);
        }
        return typeEntry;
    }

    public static boolean comparePrimitiveObjects(Object o1, PrimitiveObjectInspector oi1, Object o2, PrimitiveObjectInspector oi2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        if (oi1.getPrimitiveCategory() != oi2.getPrimitiveCategory()) {
            return false;
        }
        switch (oi1.getPrimitiveCategory()) {
            case BOOLEAN: {
                return ((BooleanObjectInspector)oi1).get(o1) == ((BooleanObjectInspector)oi2).get(o2);
            }
            case BYTE: {
                return ((ByteObjectInspector)oi1).get(o1) == ((ByteObjectInspector)oi2).get(o2);
            }
            case SHORT: {
                return ((ShortObjectInspector)oi1).get(o1) == ((ShortObjectInspector)oi2).get(o2);
            }
            case INT: {
                return ((IntObjectInspector)oi1).get(o1) == ((IntObjectInspector)oi2).get(o2);
            }
            case LONG: {
                return ((LongObjectInspector)oi1).get(o1) == ((LongObjectInspector)oi2).get(o2);
            }
            case FLOAT: {
                return ((FloatObjectInspector)oi1).get(o1) == ((FloatObjectInspector)oi2).get(o2);
            }
            case DOUBLE: {
                return ((DoubleObjectInspector)oi1).get(o1) == ((DoubleObjectInspector)oi2).get(o2);
            }
            case STRING: {
                Text t1 = ((StringObjectInspector)oi1).getPrimitiveWritableObject(o1);
                Text t2 = ((StringObjectInspector)oi2).getPrimitiveWritableObject(o2);
                return t1.equals(t2);
            }
            case VARCHAR: {
                return ((HiveVarcharObjectInspector)oi1).getPrimitiveWritableObject(o1).equals(((HiveVarcharObjectInspector)oi2).getPrimitiveWritableObject(o2));
            }
            case DATE: {
                return ((DateObjectInspector)oi1).getPrimitiveWritableObject(o1).equals(((DateObjectInspector)oi2).getPrimitiveWritableObject(o2));
            }
            case TIMESTAMP: {
                return ((TimestampObjectInspector)oi1).getPrimitiveWritableObject(o1).equals(((TimestampObjectInspector)oi2).getPrimitiveWritableObject(o2));
            }
            case BINARY: {
                return ((BinaryObjectInspector)oi1).getPrimitiveWritableObject(o1).equals((Object)((BinaryObjectInspector)oi2).getPrimitiveWritableObject(o2));
            }
            case DECIMAL: {
                return ((HiveDecimalObjectInspector)oi1).getPrimitiveJavaObject(o1).compareTo(((HiveDecimalObjectInspector)oi2).getPrimitiveJavaObject(o2)) == 0;
            }
        }
        return false;
    }

    public static double convertPrimitiveToDouble(Object o, PrimitiveObjectInspector oi) {
        switch (oi.getPrimitiveCategory()) {
            case BOOLEAN: {
                return ((BooleanObjectInspector)oi).get(o) ? 1.0 : 0.0;
            }
            case BYTE: {
                return ((ByteObjectInspector)oi).get(o);
            }
            case SHORT: {
                return ((ShortObjectInspector)oi).get(o);
            }
            case INT: {
                return ((IntObjectInspector)oi).get(o);
            }
            case LONG: {
                return ((LongObjectInspector)oi).get(o);
            }
            case FLOAT: {
                return ((FloatObjectInspector)oi).get(o);
            }
            case DOUBLE: {
                return ((DoubleObjectInspector)oi).get(o);
            }
            case STRING: {
                return Double.valueOf(((StringObjectInspector)oi).getPrimitiveJavaObject(o));
            }
            case TIMESTAMP: {
                return ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o).getDouble();
            }
            case DECIMAL: {
                return ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o).doubleValue();
            }
        }
        throw new NumberFormatException();
    }

    public static boolean comparePrimitiveObjectsWithConversion(Object o1, PrimitiveObjectInspector oi1, Object o2, PrimitiveObjectInspector oi2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        if (oi1.getPrimitiveCategory() == oi2.getPrimitiveCategory()) {
            return PrimitiveObjectInspectorUtils.comparePrimitiveObjects(o1, oi1, o2, oi2);
        }
        try {
            return PrimitiveObjectInspectorUtils.convertPrimitiveToDouble(o1, oi1) == PrimitiveObjectInspectorUtils.convertPrimitiveToDouble(o2, oi2);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean getBoolean(Object o, PrimitiveObjectInspector oi) {
        boolean result = false;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = false;
                break;
            }
            case BOOLEAN: {
                result = ((BooleanObjectInspector)oi).get(o);
                break;
            }
            case BYTE: {
                result = ((ByteObjectInspector)oi).get(o) != 0;
                break;
            }
            case SHORT: {
                result = ((ShortObjectInspector)oi).get(o) != 0;
                break;
            }
            case INT: {
                result = ((IntObjectInspector)oi).get(o) != 0;
                break;
            }
            case LONG: {
                result = (int)((LongObjectInspector)oi).get(o) != 0;
                break;
            }
            case FLOAT: {
                result = (int)((FloatObjectInspector)oi).get(o) != 0;
                break;
            }
            case DOUBLE: {
                result = (int)((DoubleObjectInspector)oi).get(o) != 0;
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                if (soi.preferWritable()) {
                    Text t = soi.getPrimitiveWritableObject(o);
                    result = t.getLength() != 0;
                    break;
                }
                String s = soi.getPrimitiveJavaObject(o);
                result = s.length() != 0;
                break;
            }
            case TIMESTAMP: {
                result = ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o).getSeconds() != 0L;
                break;
            }
            case DECIMAL: {
                result = HiveDecimal.ZERO.compareTo(((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o)) != 0;
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unsupported conversion from type: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static byte getByte(Object o, PrimitiveObjectInspector oi) {
        return (byte)PrimitiveObjectInspectorUtils.getInt(o, oi);
    }

    public static short getShort(Object o, PrimitiveObjectInspector oi) {
        return (short)PrimitiveObjectInspectorUtils.getInt(o, oi);
    }

    public static int getInt(Object o, PrimitiveObjectInspector oi) {
        int result = 0;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = 0;
                break;
            }
            case BOOLEAN: {
                result = ((BooleanObjectInspector)oi).get(o) ? 1 : 0;
                break;
            }
            case BYTE: {
                result = ((ByteObjectInspector)oi).get(o);
                break;
            }
            case SHORT: {
                result = ((ShortObjectInspector)oi).get(o);
                break;
            }
            case INT: {
                result = ((IntObjectInspector)oi).get(o);
                break;
            }
            case LONG: {
                result = (int)((LongObjectInspector)oi).get(o);
                break;
            }
            case FLOAT: {
                result = (int)((FloatObjectInspector)oi).get(o);
                break;
            }
            case DOUBLE: {
                result = (int)((DoubleObjectInspector)oi).get(o);
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                if (soi.preferWritable()) {
                    Text t = soi.getPrimitiveWritableObject(o);
                    result = LazyInteger.parseInt(t.getBytes(), 0, t.getLength());
                    break;
                }
                String s = soi.getPrimitiveJavaObject(o);
                result = Integer.parseInt(s);
                break;
            }
            case VARCHAR: {
                result = Integer.parseInt(PrimitiveObjectInspectorUtils.getString(o, oi));
                break;
            }
            case TIMESTAMP: {
                result = (int)((TimestampObjectInspector)oi).getPrimitiveWritableObject(o).getSeconds();
                break;
            }
            case DECIMAL: {
                result = ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o).intValue();
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unsupported conversion from type: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static long getLong(Object o, PrimitiveObjectInspector oi) {
        long result = 0L;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = 0L;
                break;
            }
            case BOOLEAN: {
                result = ((BooleanObjectInspector)oi).get(o) ? 1 : 0;
                break;
            }
            case BYTE: {
                result = ((ByteObjectInspector)oi).get(o);
                break;
            }
            case SHORT: {
                result = ((ShortObjectInspector)oi).get(o);
                break;
            }
            case INT: {
                result = ((IntObjectInspector)oi).get(o);
                break;
            }
            case LONG: {
                result = ((LongObjectInspector)oi).get(o);
                break;
            }
            case FLOAT: {
                result = (long)((FloatObjectInspector)oi).get(o);
                break;
            }
            case DOUBLE: {
                result = (long)((DoubleObjectInspector)oi).get(o);
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                if (soi.preferWritable()) {
                    Text t = soi.getPrimitiveWritableObject(o);
                    result = LazyLong.parseLong(t.getBytes(), 0, t.getLength());
                    break;
                }
                String s = soi.getPrimitiveJavaObject(o);
                result = Long.parseLong(s);
                break;
            }
            case VARCHAR: {
                result = Long.parseLong(PrimitiveObjectInspectorUtils.getString(o, oi));
                break;
            }
            case TIMESTAMP: {
                result = ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o).getSeconds();
                break;
            }
            case DECIMAL: {
                result = ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o).longValue();
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unsupported conversion from type: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static double getDouble(Object o, PrimitiveObjectInspector oi) {
        double result = 0.0;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = 0.0;
                break;
            }
            case BOOLEAN: {
                result = ((BooleanObjectInspector)oi).get(o) ? 1 : 0;
                break;
            }
            case BYTE: {
                result = ((ByteObjectInspector)oi).get(o);
                break;
            }
            case SHORT: {
                result = ((ShortObjectInspector)oi).get(o);
                break;
            }
            case INT: {
                result = ((IntObjectInspector)oi).get(o);
                break;
            }
            case LONG: {
                result = ((LongObjectInspector)oi).get(o);
                break;
            }
            case FLOAT: {
                result = ((FloatObjectInspector)oi).get(o);
                break;
            }
            case DOUBLE: {
                result = ((DoubleObjectInspector)oi).get(o);
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                String s = soi.getPrimitiveJavaObject(o);
                result = Double.parseDouble(s);
                break;
            }
            case VARCHAR: {
                result = Double.parseDouble(PrimitiveObjectInspectorUtils.getString(o, oi));
                break;
            }
            case TIMESTAMP: {
                result = ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o).getDouble();
                break;
            }
            case DECIMAL: {
                result = ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o).doubleValue();
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unsupported conversion from type: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static float getFloat(Object o, PrimitiveObjectInspector oi) {
        return (float)PrimitiveObjectInspectorUtils.getDouble(o, oi);
    }

    public static String getString(Object o, PrimitiveObjectInspector oi) {
        if (o == null) {
            return null;
        }
        String result = null;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = null;
                break;
            }
            case BOOLEAN: {
                result = String.valueOf(((BooleanObjectInspector)oi).get(o));
                break;
            }
            case BYTE: {
                result = String.valueOf(((ByteObjectInspector)oi).get(o));
                break;
            }
            case SHORT: {
                result = String.valueOf(((ShortObjectInspector)oi).get(o));
                break;
            }
            case INT: {
                result = String.valueOf(((IntObjectInspector)oi).get(o));
                break;
            }
            case LONG: {
                result = String.valueOf(((LongObjectInspector)oi).get(o));
                break;
            }
            case FLOAT: {
                result = String.valueOf(((FloatObjectInspector)oi).get(o));
                break;
            }
            case DOUBLE: {
                result = String.valueOf(((DoubleObjectInspector)oi).get(o));
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                result = soi.getPrimitiveJavaObject(o);
                break;
            }
            case VARCHAR: {
                HiveVarcharObjectInspector hcoi = (HiveVarcharObjectInspector)oi;
                result = hcoi.getPrimitiveJavaObject(o).toString();
                break;
            }
            case DATE: {
                result = ((DateObjectInspector)oi).getPrimitiveWritableObject(o).toString();
                break;
            }
            case TIMESTAMP: {
                result = ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o).toString();
                break;
            }
            case DECIMAL: {
                result = ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o).toString();
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unknown type: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static HiveVarchar getHiveVarchar(Object o, PrimitiveObjectInspector oi) {
        if (o == null) {
            return null;
        }
        HiveVarchar result = null;
        switch (oi.getPrimitiveCategory()) {
            case VARCHAR: {
                result = ((HiveVarcharObjectInspector)oi).getPrimitiveJavaObject(o);
                break;
            }
            default: {
                result = new HiveVarchar();
                result.setValue(PrimitiveObjectInspectorUtils.getString(o, oi));
            }
        }
        return result;
    }

    public static BytesWritable getBinary(Object o, PrimitiveObjectInspector oi) {
        if (null == o) {
            return null;
        }
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                return null;
            }
            case STRING: {
                Text text = ((StringObjectInspector)oi).getPrimitiveWritableObject(o);
                BytesWritable bw = new BytesWritable();
                bw.set(text.getBytes(), 0, text.getLength());
                return bw;
            }
            case BINARY: {
                return ((BinaryObjectInspector)oi).getPrimitiveWritableObject(o);
            }
        }
        throw new RuntimeException("Cannot convert to Binary from: " + oi.getTypeName());
    }

    public static HiveDecimal getHiveDecimal(Object o, PrimitiveObjectInspector oi) {
        if (o == null) {
            return null;
        }
        HiveDecimal result = null;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = null;
                break;
            }
            case BOOLEAN: {
                result = ((BooleanObjectInspector)oi).get(o) ? HiveDecimal.ONE : HiveDecimal.ZERO;
                break;
            }
            case BYTE: {
                result = new HiveDecimal(((ByteObjectInspector)oi).get(o));
                break;
            }
            case SHORT: {
                result = new HiveDecimal(((ShortObjectInspector)oi).get(o));
                break;
            }
            case INT: {
                result = new HiveDecimal(((IntObjectInspector)oi).get(o));
                break;
            }
            case LONG: {
                result = new HiveDecimal(((LongObjectInspector)oi).get(o));
                break;
            }
            case FLOAT: {
                Float f = Float.valueOf(((FloatObjectInspector)oi).get(o));
                result = new HiveDecimal(f.toString());
                break;
            }
            case DOUBLE: {
                Double d = ((DoubleObjectInspector)oi).get(o);
                result = new HiveDecimal(d.toString());
                break;
            }
            case STRING: {
                result = new HiveDecimal(((StringObjectInspector)oi).getPrimitiveJavaObject(o));
                break;
            }
            case VARCHAR: {
                result = new HiveDecimal(PrimitiveObjectInspectorUtils.getString(o, oi));
                break;
            }
            case TIMESTAMP: {
                Double ts = ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o).getDouble();
                result = new HiveDecimal(ts.toString());
                break;
            }
            case DECIMAL: {
                result = ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o);
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unsupported conversion from type: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static Date getDate(Object o, PrimitiveObjectInspector oi) {
        if (o == null) {
            return null;
        }
        Date result = null;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = null;
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                String s = soi.getPrimitiveJavaObject(o).trim();
                try {
                    result = Date.valueOf(s);
                }
                catch (IllegalArgumentException e) {
                    result = null;
                }
                break;
            }
            case VARCHAR: {
                try {
                    String val = PrimitiveObjectInspectorUtils.getString(o, oi).trim();
                    result = Date.valueOf(val);
                }
                catch (IllegalArgumentException e) {
                    result = null;
                }
                break;
            }
            case DATE: {
                result = ((DateObjectInspector)oi).getPrimitiveWritableObject(o).get();
                break;
            }
            case TIMESTAMP: {
                result = DateWritable.timeToDate(((TimestampObjectInspector)oi).getPrimitiveWritableObject(o).getSeconds());
                break;
            }
            default: {
                throw new RuntimeException("Cannot convert to Date from: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static Timestamp getTimestamp(Object o, PrimitiveObjectInspector oi) {
        if (o == null) {
            return null;
        }
        Timestamp result = null;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = null;
                break;
            }
            case BOOLEAN: {
                result = new Timestamp(((BooleanObjectInspector)oi).get(o) ? 1L : 0L);
                break;
            }
            case BYTE: {
                result = new Timestamp(((ByteObjectInspector)oi).get(o));
                break;
            }
            case SHORT: {
                result = new Timestamp(((ShortObjectInspector)oi).get(o));
                break;
            }
            case INT: {
                result = new Timestamp(((IntObjectInspector)oi).get(o));
                break;
            }
            case LONG: {
                result = new Timestamp(((LongObjectInspector)oi).get(o));
                break;
            }
            case FLOAT: {
                result = TimestampWritable.floatToTimestamp(((FloatObjectInspector)oi).get(o));
                break;
            }
            case DOUBLE: {
                result = TimestampWritable.doubleToTimestamp(((DoubleObjectInspector)oi).get(o));
                break;
            }
            case DECIMAL: {
                result = TimestampWritable.decimalToTimestamp(((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o));
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                String s = soi.getPrimitiveJavaObject(o);
                result = PrimitiveObjectInspectorUtils.getTimestampFromString(s);
                break;
            }
            case VARCHAR: {
                result = PrimitiveObjectInspectorUtils.getTimestampFromString(PrimitiveObjectInspectorUtils.getString(o, oi));
                break;
            }
            case DATE: {
                result = new Timestamp(((DateObjectInspector)oi).getPrimitiveWritableObject(o).get().getTime());
                break;
            }
            case TIMESTAMP: {
                result = ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o).getTimestamp();
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unknown type: " + oi.getTypeName());
            }
        }
        return result;
    }

    static Timestamp getTimestampFromString(String s) {
        Timestamp result;
        int periodIdx = (s = s.trim()).indexOf(".");
        if (periodIdx != -1 && s.length() - periodIdx > 9) {
            s = s.substring(0, periodIdx + 10);
        }
        try {
            result = Timestamp.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        return result;
    }

    public static Class<?> getJavaPrimitiveClassFromObjectInspector(ObjectInspector oi) {
        if (oi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
        PrimitiveTypeEntry t = PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveCategory(poi.getPrimitiveCategory());
        return t == null ? null : t.primitiveJavaClass;
    }

    public static PrimitiveGrouping getPrimitiveGrouping(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return PrimitiveGrouping.NUMERIC_GROUP;
            }
            case STRING: 
            case VARCHAR: {
                return PrimitiveGrouping.STRING_GROUP;
            }
            case BOOLEAN: {
                return PrimitiveGrouping.BOOLEAN_GROUP;
            }
            case DATE: 
            case TIMESTAMP: {
                return PrimitiveGrouping.DATE_GROUP;
            }
            case BINARY: {
                return PrimitiveGrouping.BINARY_GROUP;
            }
            case VOID: {
                return PrimitiveGrouping.VOID_GROUP;
            }
        }
        return PrimitiveGrouping.UNKNOWN_GROUP;
    }

    private PrimitiveObjectInspectorUtils() {
    }

    static {
        PrimitiveObjectInspectorUtils.registerType(binaryTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(stringTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(varcharTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(booleanTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(intTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(longTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(floatTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(voidTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(doubleTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(byteTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(shortTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(dateTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(timestampTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(decimalTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(unknownTypeEntry);
    }

    public static class ParameterizedObjectInspectorMap {
        HashMap<PrimitiveObjectInspector.PrimitiveCategory, HashMap<String, PrimitiveObjectInspector>> entries = new HashMap();

        public PrimitiveObjectInspector getObjectInspector(PrimitiveTypeSpec typeSpec) {
            PrimitiveObjectInspector.PrimitiveCategory category = typeSpec.getPrimitiveCategory();
            BaseTypeParams params = typeSpec.getTypeParams();
            HashMap<String, PrimitiveObjectInspector> entriesForCategory = this.entries.get((Object)category);
            if (entriesForCategory == null) {
                return null;
            }
            return entriesForCategory.get(params.toString());
        }

        public void setObjectInspector(PrimitiveObjectInspector oi) {
            PrimitiveObjectInspector.PrimitiveCategory category = oi.getPrimitiveCategory();
            HashMap<String, PrimitiveObjectInspector> entriesForCategory = this.entries.get((Object)category);
            if (entriesForCategory == null) {
                entriesForCategory = new HashMap();
                this.entries.put(category, entriesForCategory);
            }
            entriesForCategory.put(oi.getTypeParams().toString(), oi);
        }
    }

    public static enum PrimitiveGrouping {
        NUMERIC_GROUP,
        STRING_GROUP,
        BOOLEAN_GROUP,
        DATE_GROUP,
        BINARY_GROUP,
        VOID_GROUP,
        UNKNOWN_GROUP;

    }

    public static class PrimitiveTypeEntry
    implements Writable,
    Cloneable,
    PrimitiveTypeSpec {
        public PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        public Class<?> primitiveJavaType;
        public Class<?> primitiveJavaClass;
        public Class<?> primitiveWritableClass;
        public String typeName;
        public Class<?> typeParamsClass;
        public BaseTypeParams typeParams;

        PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, String typeName, Class<?> primitiveType, Class<?> javaClass, Class<?> hiveClass, Class<?> paramsClass) {
            this.primitiveCategory = primitiveCategory;
            this.primitiveJavaType = primitiveType;
            this.primitiveJavaClass = javaClass;
            this.primitiveWritableClass = hiveClass;
            this.typeParamsClass = paramsClass;
            this.typeName = typeName;
        }

        public void readFields(DataInput in) throws IOException {
            this.primitiveCategory = (PrimitiveObjectInspector.PrimitiveCategory)WritableUtils.readEnum((DataInput)in, PrimitiveObjectInspector.PrimitiveCategory.class);
            this.typeName = WritableUtils.readString((DataInput)in);
            int typeParamsIndicator = WritableUtils.readVInt((DataInput)in);
            try {
                this.primitiveJavaType = Class.forName(WritableUtils.readString((DataInput)in));
                this.primitiveJavaClass = Class.forName(WritableUtils.readString((DataInput)in));
                this.primitiveWritableClass = Class.forName(WritableUtils.readString((DataInput)in));
                if (typeParamsIndicator == 1) {
                    this.typeParamsClass = Class.forName(WritableUtils.readString((DataInput)in));
                    this.typeParams = (BaseTypeParams)this.typeParamsClass.newInstance();
                    this.typeParams.readFields(in);
                } else {
                    this.typeParamsClass = null;
                    this.typeParams = null;
                }
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
        }

        public void write(DataOutput out) throws IOException {
            int typeParamsIndicator = this.isParameterized() && this.typeParams != null ? 1 : 0;
            WritableUtils.writeEnum((DataOutput)out, (Enum)this.primitiveCategory);
            WritableUtils.writeString((DataOutput)out, (String)this.typeName);
            WritableUtils.writeVInt((DataOutput)out, (int)typeParamsIndicator);
            WritableUtils.writeString((DataOutput)out, (String)this.primitiveJavaType.getName());
            WritableUtils.writeString((DataOutput)out, (String)this.primitiveJavaClass.getName());
            WritableUtils.writeString((DataOutput)out, (String)this.primitiveWritableClass.getName());
            if (typeParamsIndicator == 1) {
                WritableUtils.writeString((DataOutput)out, (String)this.typeParamsClass.getName());
                this.typeParams.write(out);
            }
        }

        public PrimitiveTypeEntry addParameters(String[] parameters) {
            if (parameters == null || parameters.length == 0) {
                return this;
            }
            try {
                BaseTypeParams newTypeParams = (BaseTypeParams)this.typeParamsClass.newInstance();
                newTypeParams.set(parameters);
                String typeNameWithParams = this.typeName + newTypeParams.toString();
                if (typeNameToTypeEntry.containsKey(typeNameWithParams)) {
                    return typeNameToTypeEntry.get(typeNameWithParams);
                }
                PrimitiveTypeEntry result = (PrimitiveTypeEntry)this.clone();
                result.typeParams = newTypeParams;
                PrimitiveObjectInspectorUtils.addParameterizedType(result);
                return result;
            }
            catch (Exception err) {
                LOG.error((Object)("Error while setting type parameters: " + err));
                throw new RuntimeException(err);
            }
        }

        public boolean isParameterized() {
            return null != this.typeParamsClass;
        }

        public Object clone() {
            PrimitiveTypeEntry result = new PrimitiveTypeEntry(this.primitiveCategory, this.typeName, this.primitiveJavaType, this.primitiveJavaClass, this.primitiveWritableClass, this.typeParamsClass);
            return result;
        }

        public String toString() {
            if (this.typeParams != null) {
                return this.typeName + this.typeParams.toString();
            }
            return this.typeName;
        }

        public static BaseTypeParams createTypeParams(String typeName, String[] parameters) throws SerDeException {
            try {
                PrimitiveTypeEntry typeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(typeName);
                if (typeEntry != null && typeEntry.typeParamsClass != null) {
                    BaseTypeParams newTypeParams = (BaseTypeParams)typeEntry.typeParamsClass.newInstance();
                    newTypeParams.set(parameters);
                    return newTypeParams;
                }
                return null;
            }
            catch (Exception err) {
                throw new SerDeException("Error creating type params for " + typeName + ": " + err, err);
            }
        }

        @Override
        public PrimitiveObjectInspector.PrimitiveCategory getPrimitiveCategory() {
            return this.primitiveCategory;
        }

        @Override
        public BaseTypeParams getTypeParams() {
            return this.typeParams;
        }
    }
}

