/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import org.apache.hadoop.hive.ql.udf.generic.NumDistinctValueEstimator;
import org.apache.hadoop.hive.ql.udf.generic.NumericHistogram;

public enum JavaDataModel {
    JAVA32{

        @Override
        public int object() {
            return 16;
        }

        @Override
        public int array() {
            return 20;
        }

        @Override
        public int ref() {
            return 4;
        }

        @Override
        public int hashMap(int entry) {
            return 64 + 24 * entry;
        }

        @Override
        public int hashSet(int entry) {
            return 80 + 24 * entry;
        }

        @Override
        public int linkedHashMap(int entry) {
            return 72 + 32 * entry;
        }

        @Override
        public int linkedList(int entry) {
            return 28 + 24 * entry;
        }

        @Override
        public int arrayList() {
            return 44;
        }
    }
    ,
    JAVA64{

        @Override
        public int object() {
            return 32;
        }

        @Override
        public int array() {
            return 40;
        }

        @Override
        public int ref() {
            return 8;
        }

        @Override
        public int hashMap(int entry) {
            return 112 + 44 * entry;
        }

        @Override
        public int hashSet(int entry) {
            return 144 + 44 * entry;
        }

        @Override
        public int linkedHashMap(int entry) {
            return 128 + 60 * entry;
        }

        @Override
        public int linkedList(int entry) {
            return 48 + 48 * entry;
        }

        @Override
        public int arrayList() {
            return 80;
        }
    };

    public static final int JAVA32_META = 12;
    public static final int JAVA32_ARRAY_META = 16;
    public static final int JAVA32_REF = 4;
    public static final int JAVA32_OBJECT = 16;
    public static final int JAVA32_ARRAY = 20;
    public static final int JAVA64_META = 24;
    public static final int JAVA64_ARRAY_META = 32;
    public static final int JAVA64_REF = 8;
    public static final int JAVA64_OBJECT = 32;
    public static final int JAVA64_ARRAY = 40;
    public static final int PRIMITIVES1 = 4;
    public static final int PRIMITIVES2 = 8;
    private static JavaDataModel current;

    public abstract int object();

    public abstract int array();

    public abstract int ref();

    public abstract int hashMap(int var1);

    public abstract int hashSet(int var1);

    public abstract int linkedHashMap(int var1);

    public abstract int linkedList(int var1);

    public abstract int arrayList();

    public int lengthFor(String string) {
        return this.object() + this.primitive1() * 3 + this.array() + string.length();
    }

    public int lengthFor(NumericHistogram histogram) {
        int length = this.object();
        length += this.primitive1() * 2;
        int numBins = histogram.getNumBins();
        if (numBins > 0) {
            length += this.arrayList();
            length += numBins * (this.object() + this.primitive2() * 2);
        }
        return length += this.lengthForRandom();
    }

    public int lengthFor(NumDistinctValueEstimator estimator) {
        int length = this.object();
        length += this.primitive1() * 2;
        length += this.primitive2();
        length += this.lengthForRandom() * 2;
        int numVector = estimator.getnumBitVectors();
        if (numVector > 0) {
            length += this.array() * 3;
            length += this.primitive1() * numVector * 2;
            length += (this.object() + this.array() + this.primitive1() + this.primitive2()) * numVector;
        }
        return length;
    }

    public int lengthForRandom() {
        return this.object() + this.primitive1() + this.primitive2() + this.object() + this.primitive2();
    }

    public int primitive1() {
        return 4;
    }

    public int primitive2() {
        return 8;
    }

    public static JavaDataModel get() {
        if (current != null) {
            return current;
        }
        try {
            String props = System.getProperty("sun.arch.data.model");
            if ("32".equals(props)) {
                current = JAVA32;
                return current;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        current = JAVA64;
        return current;
    }

    public static int round(int size) {
        JavaDataModel model = JavaDataModel.get();
        if (model == JAVA32 || size % 8 == 0) {
            return size;
        }
        return size + 8 >> 3 << 3;
    }
}

