/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DropFunctionDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;

public class FunctionSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog(FunctionSemanticAnalyzer.class);

    public FunctionSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (ast.getToken().getType() == 594) {
            this.analyzeCreateFunction(ast);
        }
        if (ast.getToken().getType() == 621) {
            this.analyzeDropFunction(ast);
        }
        LOG.info((Object)"analyze done");
    }

    private void analyzeCreateFunction(ASTNode ast) throws SemanticException {
        String functionName = ast.getChild(0).getText();
        String className = FunctionSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        CreateFunctionDesc desc = new CreateFunctionDesc(functionName, className);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc), this.conf, new Task[0]));
    }

    private void analyzeDropFunction(ASTNode ast) throws SemanticException {
        boolean throwException;
        String functionName = ast.getChild(0).getText();
        boolean ifExists = ast.getFirstChildWithType(654) != null;
        boolean bl = throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        if (throwException && FunctionRegistry.getFunctionInfo(functionName) == null) {
            throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(functionName));
        }
        DropFunctionDesc desc = new DropFunctionDesc(functionName);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc), this.conf, new Task[0]));
    }
}

