/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.physical.AbstractJoinTaskDispatcher;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverCommonJoin;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;

public class CommonJoinTaskDispatcher
extends AbstractJoinTaskDispatcher
implements Dispatcher {
    HashMap<String, Long> aliasToSize = null;

    public CommonJoinTaskDispatcher(PhysicalContext context) {
        super(context);
    }

    private long calculateLocalTableTotalSize(MapredLocalWork localWork) {
        long localTableTotalSize = 0L;
        if (localWork == null) {
            return localTableTotalSize;
        }
        for (String alias : localWork.getAliasToWork().keySet()) {
            Long tabSize = this.aliasToSize.get(alias);
            if (tabSize == null) {
                return -1L;
            }
            localTableTotalSize += tabSize.longValue();
        }
        return localTableTotalSize;
    }

    private boolean isLocalTableTotalSizeUnderLimitAfterMerge(Configuration conf, MapredLocalWork ... localWorks) {
        long localTableTotalSizeLimit = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
        long localTableTotalSize = 0L;
        for (int i = 0; i < localWorks.length; ++i) {
            long localWorkTableTotalSize = this.calculateLocalTableTotalSize(localWorks[i]);
            if (localWorkTableTotalSize < 0L) {
                return false;
            }
            localTableTotalSize += localWorkTableTotalSize;
        }
        return localTableTotalSize <= localTableTotalSizeLimit;
    }

    private int getPosition(MapWork work, Operator<? extends OperatorDesc> joinOp, String alias) {
        Operator<? extends OperatorDesc> parentOp = work.getAliasToWork().get(alias);
        while (parentOp.getChildOperators() != null && !parentOp.getChildOperators().isEmpty()) {
            parentOp = parentOp.getChildOperators().get(0);
        }
        return joinOp.getParentOperators().indexOf(parentOp);
    }

    private ObjectPair<MapRedTask, String> convertTaskToMapJoinTask(MapredWork newWork, int bigTablePosition) throws UnsupportedEncodingException, SemanticException {
        MapRedTask newTask = (MapRedTask)TaskFactory.get(newWork, this.physicalContext.getParseContext().getConf(), new Task[0]);
        JoinOperator newJoinOp = this.getJoinOp(newTask);
        String bigTableAlias = MapJoinProcessor.genMapJoinOpAndLocalWork(newWork, newJoinOp, bigTablePosition);
        return new ObjectPair<MapRedTask, String>(newTask, bigTableAlias);
    }

    private void mergeMapJoinTaskIntoItsChildMapRedTask(MapRedTask mapJoinTask, Configuration conf) throws SemanticException {
        if (mapJoinTask.getChildTasks() == null || mapJoinTask.getChildTasks().size() > 1) {
            return;
        }
        Task<Serializable> childTask = mapJoinTask.getChildTasks().get(0);
        if (!(childTask instanceof MapRedTask)) {
            return;
        }
        MapRedTask childMapRedTask = (MapRedTask)childTask;
        MapWork mapJoinMapWork = ((MapredWork)mapJoinTask.getWork()).getMapWork();
        MapWork childMapWork = ((MapredWork)childMapRedTask.getWork()).getMapWork();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> mapJoinAliasToWork = mapJoinMapWork.getAliasToWork();
        if (mapJoinAliasToWork.size() > 1) {
            return;
        }
        Map.Entry mapJoinAliasToWorkEntry = mapJoinAliasToWork.entrySet().iterator().next();
        String mapJoinAlias = (String)mapJoinAliasToWorkEntry.getKey();
        TableScanOperator mapJoinTaskTableScanOperator = OperatorUtils.findSingleOperator((Operator)mapJoinAliasToWorkEntry.getValue(), TableScanOperator.class);
        if (mapJoinTaskTableScanOperator == null) {
            throw new SemanticException("Expected a " + TableScanOperator.getOperatorName() + " operator as the work associated with alias " + mapJoinAlias + ". Found a " + ((Operator)mapJoinAliasToWork.get(mapJoinAlias)).getName() + " operator.");
        }
        FileSinkOperator mapJoinTaskFileSinkOperator = OperatorUtils.findSingleOperator(mapJoinTaskTableScanOperator, FileSinkOperator.class);
        if (mapJoinTaskFileSinkOperator == null) {
            throw new SemanticException("Cannot find the " + FileSinkOperator.getOperatorName() + " operator at the last operator of the MapJoin Task.");
        }
        String childMRPath = ((FileSinkDesc)mapJoinTaskFileSinkOperator.getConf()).getDirName();
        List childMRAliases = childMapWork.getPathToAliases().get(childMRPath);
        if (childMRAliases == null || childMRAliases.size() != 1) {
            return;
        }
        String childMRAlias = (String)childMRAliases.get(0);
        MapredLocalWork mapJoinLocalWork = mapJoinMapWork.getMapLocalWork();
        MapredLocalWork childLocalWork = childMapWork.getMapLocalWork();
        if (mapJoinLocalWork != null && mapJoinLocalWork.getBucketMapjoinContext() != null || childLocalWork != null && childLocalWork.getBucketMapjoinContext() != null) {
            return;
        }
        if (!this.isLocalTableTotalSizeUnderLimitAfterMerge(conf, mapJoinLocalWork, childLocalWork)) {
            return;
        }
        TableScanOperator childMRTaskTableScanOperator = OperatorUtils.findSingleOperator(childMapWork.getAliasToWork().get(childMRAlias), TableScanOperator.class);
        if (childMRTaskTableScanOperator == null) {
            throw new SemanticException("Expected a " + TableScanOperator.getOperatorName() + " operator as the work associated with alias " + childMRAlias + ". Found a " + childMapWork.getAliasToWork().get(childMRAlias).getName() + " operator.");
        }
        List<Operator<OperatorDesc>> parentsInMapJoinTask = mapJoinTaskFileSinkOperator.getParentOperators();
        List<Operator<OperatorDesc>> childrenInChildMRTask = childMRTaskTableScanOperator.getChildOperators();
        if (parentsInMapJoinTask.size() > 1 || childrenInChildMRTask.size() > 1) {
            return;
        }
        Operator<OperatorDesc> parentInMapJoinTask = parentsInMapJoinTask.get(0);
        Operator<OperatorDesc> childInChildMRTask = childrenInChildMRTask.get(0);
        parentInMapJoinTask.replaceChild(mapJoinTaskFileSinkOperator, childInChildMRTask);
        childInChildMRTask.replaceParent(childMRTaskTableScanOperator, parentInMapJoinTask);
        GenMapRedUtils.replaceMapWork(mapJoinAlias, childMRAlias, mapJoinMapWork, childMapWork);
        if (mapJoinLocalWork != null) {
            if (childLocalWork == null) {
                childMapWork.setMapLocalWork(mapJoinLocalWork);
            } else {
                childLocalWork.getAliasToFetchWork().putAll(mapJoinLocalWork.getAliasToFetchWork());
                childLocalWork.getAliasToWork().putAll(mapJoinLocalWork.getAliasToWork());
            }
        }
        List<Task<Serializable>> parentTasks = mapJoinTask.getParentTasks();
        mapJoinTask.setParentTasks(null);
        mapJoinTask.setChildTasks(null);
        childMapRedTask.getParentTasks().remove(mapJoinTask);
        if (parentTasks != null) {
            childMapRedTask.getParentTasks().addAll(parentTasks);
            for (Task<Serializable> parentTask : parentTasks) {
                parentTask.getChildTasks().remove(mapJoinTask);
                if (parentTask.getChildTasks().contains(childMapRedTask)) continue;
                parentTask.getChildTasks().add(childMapRedTask);
            }
        } else if (this.physicalContext.getRootTasks().contains(mapJoinTask)) {
            this.physicalContext.removeFromRootTask(mapJoinTask);
            if (childMapRedTask.getParentTasks() != null && childMapRedTask.getParentTasks().size() == 0 && !this.physicalContext.getRootTasks().contains(childMapRedTask)) {
                this.physicalContext.addToRootTask(childMapRedTask);
            }
        }
        if (childMapRedTask.getParentTasks().size() == 0) {
            childMapRedTask.setParentTasks(null);
        }
    }

    public static boolean cannotConvert(String bigTableAlias, Map<String, Long> aliasToSize, long aliasTotalKnownInputSize, long ThresholdOfSmallTblSizeSum) {
        long smallTblTotalKnownSize;
        boolean ret = false;
        Long aliasKnownSize = aliasToSize.get(bigTableAlias);
        if (aliasKnownSize != null && aliasKnownSize > 0L && (smallTblTotalKnownSize = aliasTotalKnownInputSize - aliasKnownSize) > ThresholdOfSmallTblSizeSum) {
            ret = true;
        }
        return ret;
    }

    @Override
    public Task<? extends Serializable> processCurrentTask(MapRedTask currTask, ConditionalTask conditionalTask, Context context) throws SemanticException {
        JoinOperator joinOp = this.getJoinOp(currTask);
        if (joinOp == null || ((JoinDesc)joinOp.getConf()).isFixedAsSorted()) {
            return null;
        }
        currTask.setTaskTag(1);
        MapWork currWork = ((MapredWork)currTask.getWork()).getMapWork();
        ArrayList listWorks = new ArrayList();
        ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
        HashMap<String, Task<? extends Serializable>> aliasToTask = new HashMap<String, Task<? extends Serializable>>();
        LinkedHashMap<String, ArrayList<String>> pathToAliases = currWork.getPathToAliases();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = currWork.getAliasToWork();
        ParseContext parseCtx = this.physicalContext.getParseContext();
        QBJoinTree joinTree = parseCtx.getJoinContext().get(joinOp);
        JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
        Byte[] order = joinDesc.getTagOrder();
        int numAliases = order.length;
        if (this.aliasToSize == null) {
            this.aliasToSize = new HashMap();
        }
        try {
            long aliasTotalKnownInputSize = this.getTotalKnownInputSize(context, currWork, pathToAliases, this.aliasToSize);
            Set<Integer> bigTableCandidates = MapJoinProcessor.getBigTableCandidates(joinDesc.getConds());
            if (bigTableCandidates == null) {
                return null;
            }
            Configuration conf = context.getConf();
            boolean convertJoinMapJoin = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASK);
            int bigTablePosition = -1;
            if (convertJoinMapJoin) {
                long mapJoinSize = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
                boolean bigTableFound = false;
                long largestBigTableCandidateSize = -1L;
                long sumTableSizes = 0L;
                for (String alias : aliasToWork.keySet()) {
                    int tablePosition = this.getPosition(currWork, joinOp, alias);
                    boolean bigTableCandidate = bigTableCandidates.contains(tablePosition);
                    Long size = this.aliasToSize.get(alias);
                    if (size == null || size > mapJoinSize) {
                        if (bigTableFound || (sumTableSizes += largestBigTableCandidateSize) > mapJoinSize || !bigTableCandidate) {
                            convertJoinMapJoin = false;
                            break;
                        }
                        bigTableFound = true;
                        bigTablePosition = tablePosition;
                        largestBigTableCandidateSize = mapJoinSize + 1L;
                        continue;
                    }
                    if (bigTableCandidate && size > largestBigTableCandidateSize) {
                        bigTablePosition = tablePosition;
                        sumTableSizes += largestBigTableCandidateSize;
                        largestBigTableCandidateSize = size;
                    } else {
                        sumTableSizes += size.longValue();
                    }
                    if (sumTableSizes <= mapJoinSize) continue;
                    convertJoinMapJoin = false;
                    break;
                }
            }
            String bigTableAlias = null;
            currWork.setOpParseCtxMap(parseCtx.getOpParseCtx());
            currWork.setJoinTree(joinTree);
            if (convertJoinMapJoin) {
                MapRedTask newTask = this.convertTaskToMapJoinTask((MapredWork)currTask.getWork(), bigTablePosition).getFirst();
                newTask.setTaskTag(6);
                this.replaceTask(currTask, newTask, this.physicalContext);
                if (newTask.getChildTasks() != null && newTask.getChildTasks().size() == 1) {
                    this.mergeMapJoinTaskIntoItsChildMapRedTask(newTask, conf);
                }
                return newTask;
            }
            long ThresholdOfSmallTblSizeSum = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVESMALLTABLESFILESIZE);
            for (int i = 0; i < numAliases; ++i) {
                if (!bigTableCandidates.contains(i)) continue;
                MapredWork newWork = (MapredWork)Utilities.clonePlan(currTask.getWork());
                ObjectPair<MapRedTask, String> newTaskAlias = this.convertTaskToMapJoinTask(newWork, i);
                MapRedTask newTask = newTaskAlias.getFirst();
                bigTableAlias = newTaskAlias.getSecond();
                if (CommonJoinTaskDispatcher.cannotConvert(bigTableAlias, this.aliasToSize, aliasTotalKnownInputSize, ThresholdOfSmallTblSizeSum)) continue;
                listWorks.add(newTask.getWork());
                listTasks.add(newTask);
                newTask.setTaskTag(2);
                newTask.setBackupTask(currTask);
                newTask.setBackupChildrenTasks(currTask.getChildTasks());
                aliasToTask.put(bigTableAlias, newTask);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SemanticException("Generate Map Join Task Error: " + e.getMessage());
        }
        listWorks.add(currTask.getWork());
        listTasks.add(currTask);
        currWork.setOpParseCtxMap(null);
        currWork.setJoinTree(null);
        ConditionalWork cndWork = new ConditionalWork(listWorks);
        ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(cndWork, parseCtx.getConf(), new Task[0]);
        cndTsk.setListTasks(listTasks);
        cndTsk.setResolver(new ConditionalResolverCommonJoin());
        ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx resolverCtx = new ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx();
        resolverCtx.setPathToAliases(pathToAliases);
        resolverCtx.setAliasToKnownSize(this.aliasToSize);
        resolverCtx.setAliasToTask(aliasToTask);
        resolverCtx.setCommonJoinTask(currTask);
        resolverCtx.setLocalTmpDir(context.getLocalScratchDir(false));
        resolverCtx.setHdfsTmpDir(context.getMRScratchDir());
        cndTsk.setResolverCtx(resolverCtx);
        this.replaceTaskWithConditionalTask(currTask, cndTsk, this.physicalContext);
        return cndTsk;
    }

    private boolean checkOperatorOKMapJoinConversion(Operator<? extends OperatorDesc> op) {
        if (!op.opAllowedConvertMapJoin()) {
            return false;
        }
        if (op.getChildOperators() == null) {
            return true;
        }
        for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
            if (this.checkOperatorOKMapJoinConversion(childOp)) continue;
            return false;
        }
        return true;
    }

    private JoinOperator getJoinOp(MapRedTask task) throws SemanticException {
        MapWork mWork = ((MapredWork)task.getWork()).getMapWork();
        ReduceWork rWork = ((MapredWork)task.getWork()).getReduceWork();
        if (rWork == null) {
            return null;
        }
        Operator<?> reducerOp = rWork.getReducer();
        if (reducerOp instanceof JoinOperator) {
            LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = mWork.getAliasToWork();
            for (Operator op : aliasToWork.values()) {
                if (this.checkOperatorOKMapJoinConversion(op)) continue;
                return null;
            }
            return (JoinOperator)reducerOp;
        }
        return null;
    }
}

