/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class TimestampWritable
implements WritableComparable<TimestampWritable> {
    private static final Log LOG = LogFactory.getLog(TimestampWritable.class);
    public static final byte[] nullBytes = new byte[]{0, 0, 0, 0};
    private static final int NO_DECIMAL_MASK = Integer.MAX_VALUE;
    private static final int HAS_DECIMAL_MASK = Integer.MIN_VALUE;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Timestamp timestamp = new Timestamp(0L);
    private boolean bytesEmpty;
    private boolean timestampEmpty;
    private byte[] currentBytes;
    private final byte[] internalBytes = new byte[9];
    private byte[] externalBytes;
    private int offset;
    private static final LazyBinaryUtils.VInt vInt = new LazyBinaryUtils.VInt();

    public TimestampWritable() {
        Arrays.fill(this.internalBytes, (byte)0);
        this.bytesEmpty = false;
        this.currentBytes = this.internalBytes;
        this.offset = 0;
        this.clearTimestamp();
    }

    public TimestampWritable(byte[] bytes, int offset) {
        this.set(bytes, offset);
    }

    public TimestampWritable(TimestampWritable t) {
        this(t.getBytes(), 0);
    }

    public TimestampWritable(Timestamp t) {
        this.set(t);
    }

    public void set(byte[] bytes, int offset) {
        this.externalBytes = bytes;
        this.offset = offset;
        this.bytesEmpty = false;
        this.currentBytes = this.externalBytes;
        this.clearTimestamp();
    }

    public void set(Timestamp t) {
        if (t == null) {
            this.timestamp.setTime(0L);
            this.timestamp.setNanos(0);
            return;
        }
        this.timestamp = t;
        this.bytesEmpty = true;
        this.timestampEmpty = false;
    }

    public void set(TimestampWritable t) {
        if (t.bytesEmpty) {
            this.set(t.getTimestamp());
            return;
        }
        if (t.currentBytes == t.externalBytes) {
            this.set(t.currentBytes, t.offset);
        } else {
            this.set(t.currentBytes, 0);
        }
    }

    private void clearTimestamp() {
        this.timestampEmpty = true;
    }

    public void writeToByteStream(ByteStream.Output byteStream) {
        this.checkBytes();
        byteStream.write(this.currentBytes, this.offset, this.getTotalLength());
    }

    public int getSeconds() {
        if (this.bytesEmpty) {
            return (int)(this.timestamp.getTime() / 1000L);
        }
        return TimestampWritable.getSeconds(this.currentBytes, this.offset);
    }

    public int getNanos() {
        if (!this.timestampEmpty) {
            return this.timestamp.getNanos();
        }
        return this.hasDecimal() ? TimestampWritable.getNanos(this.currentBytes, this.offset + 4) : 0;
    }

    private int getTotalLength() {
        return 4 + this.getDecimalLength();
    }

    private int getDecimalLength() {
        this.checkBytes();
        return this.hasDecimal() ? WritableUtils.decodeVIntSize((byte)this.currentBytes[this.offset + 4]) : 0;
    }

    public Timestamp getTimestamp() {
        if (this.timestampEmpty) {
            this.populateTimestamp();
        }
        return this.timestamp;
    }

    public byte[] getBytes() {
        this.checkBytes();
        int len = this.getTotalLength();
        byte[] b = new byte[len];
        System.arraycopy(this.currentBytes, this.offset, b, 0, len);
        return b;
    }

    public byte[] getBinarySortable() {
        byte[] b = new byte[8];
        int nanos = this.getNanos();
        int seconds = Integer.MIN_VALUE | this.getSeconds();
        TimestampWritable.intToBytes(seconds, b, 0);
        TimestampWritable.intToBytes(nanos, b, 4);
        return b;
    }

    public void setBinarySortable(byte[] bytes, int offset) {
        int seconds = TimestampWritable.bytesToInt(bytes, offset);
        int nanos = TimestampWritable.bytesToInt(bytes, offset + 4);
        seconds = nanos == 0 ? (seconds &= Integer.MAX_VALUE) : (seconds |= Integer.MIN_VALUE);
        TimestampWritable.intToBytes(seconds, this.internalBytes, 0);
        TimestampWritable.setNanosBytes(nanos, this.internalBytes, 4);
        this.currentBytes = this.internalBytes;
        this.offset = 0;
    }

    private void checkBytes() {
        if (this.bytesEmpty) {
            TimestampWritable.convertTimestampToBytes(this.timestamp, this.internalBytes, 0);
            this.offset = 0;
            this.currentBytes = this.internalBytes;
            this.bytesEmpty = false;
        }
    }

    public double getDouble() {
        double nanos;
        double seconds;
        if (this.bytesEmpty) {
            seconds = this.timestamp.getTime() / 1000L;
            nanos = this.timestamp.getNanos();
        } else {
            seconds = this.getSeconds();
            nanos = this.getNanos();
        }
        return seconds + nanos / 1.0E9;
    }

    public void readFields(DataInput in) throws IOException {
        in.readFully(this.internalBytes, 0, 4);
        if (TimestampWritable.hasDecimal(this.internalBytes[0])) {
            in.readFully(this.internalBytes, 4, 1);
            byte len = (byte)WritableUtils.decodeVIntSize((byte)this.internalBytes[4]);
            in.readFully(this.internalBytes, 5, len - 1);
        }
        this.currentBytes = this.internalBytes;
        this.offset = 0;
    }

    public void write(OutputStream out) throws IOException {
        this.checkBytes();
        out.write(this.currentBytes, this.offset, this.getTotalLength());
    }

    public void write(DataOutput out) throws IOException {
        this.write((OutputStream)((Object)out));
    }

    public int compareTo(TimestampWritable t) {
        this.checkBytes();
        int s1 = this.getSeconds();
        int s2 = t.getSeconds();
        if (s1 == s2) {
            int n2;
            int n1 = this.getNanos();
            if (n1 == (n2 = t.getNanos())) {
                return 0;
            }
            return n1 - n2;
        }
        return s1 - s2;
    }

    public boolean equals(Object o) {
        return this.compareTo((TimestampWritable)o) == 0;
    }

    public String toString() {
        String timestampString;
        if (this.timestampEmpty) {
            this.populateTimestamp();
        }
        if ((timestampString = this.timestamp.toString()).length() > 19) {
            if (timestampString.length() == 21 && timestampString.substring(19).compareTo(".0") == 0) {
                return dateFormat.format(this.timestamp);
            }
            return dateFormat.format(this.timestamp) + timestampString.substring(19);
        }
        return dateFormat.format(this.timestamp);
    }

    public int hashCode() {
        long seconds = this.getSeconds();
        seconds <<= 32;
        return (int)((seconds |= (long)this.getNanos()) >>> 32 ^ seconds);
    }

    private void populateTimestamp() {
        long seconds = this.getSeconds();
        int nanos = this.getNanos();
        this.timestamp.setTime(seconds * 1000L);
        this.timestamp.setNanos(nanos);
    }

    public static int getSeconds(byte[] bytes, int offset) {
        return Integer.MAX_VALUE & TimestampWritable.bytesToInt(bytes, offset);
    }

    public static int getNanos(byte[] bytes, int offset) {
        int val;
        LazyBinaryUtils.readVInt(bytes, offset, vInt);
        int len = (int)Math.floor(Math.log10(val)) + 1;
        int tmp = 0;
        for (val = TimestampWritable.vInt.value; val != 0; val /= 10) {
            tmp *= 10;
            tmp += val % 10;
        }
        val = tmp;
        if (len < 9) {
            val = (int)((double)val * Math.pow(10.0, 9 - len));
        }
        return val;
    }

    public static void convertTimestampToBytes(Timestamp t, byte[] b, int offset) {
        if (b.length < 9) {
            LOG.error((Object)"byte array too short");
        }
        long millis = t.getTime();
        int nanos = t.getNanos();
        boolean hasDecimal = nanos != 0 && TimestampWritable.setNanosBytes(nanos, b, offset + 4);
        TimestampWritable.setSecondsBytes(millis, b, offset, hasDecimal);
    }

    private static void setSecondsBytes(long millis, byte[] b, int offset, boolean hasDecimal) {
        int seconds = (int)(millis / 1000L);
        seconds = !hasDecimal ? (seconds &= Integer.MAX_VALUE) : (seconds |= Integer.MIN_VALUE);
        TimestampWritable.intToBytes(seconds, b, offset);
    }

    private static boolean setNanosBytes(int nanos, byte[] b, int offset) {
        int decimal = 0;
        if (nanos != 0) {
            for (int counter = 0; counter < 9; ++counter) {
                decimal *= 10;
                decimal += nanos % 10;
                nanos /= 10;
            }
        }
        LazyBinaryUtils.writeVLongToByteArray(b, offset, decimal);
        return decimal != 0;
    }

    public static Timestamp floatToTimestamp(float f) {
        return TimestampWritable.doubleToTimestamp(f);
    }

    public static Timestamp doubleToTimestamp(double f) {
        long seconds = (long)f;
        BigDecimal bd = new BigDecimal(String.valueOf(f));
        bd = bd.subtract(new BigDecimal(seconds)).multiply(new BigDecimal(1000000000));
        int nanos = bd.intValue();
        long millis = seconds * 1000L;
        Timestamp t = new Timestamp(millis);
        t.setNanos(nanos);
        return t;
    }

    public static void setTimestamp(Timestamp t, byte[] bytes, int offset) {
        boolean hasDecimal = TimestampWritable.hasDecimal(bytes[offset]);
        t.setTime((long)TimestampWritable.getSeconds(bytes, offset) * 1000L);
        if (hasDecimal) {
            t.setNanos(TimestampWritable.getNanos(bytes, offset + 4));
        }
    }

    public static Timestamp createTimestamp(byte[] bytes, int offset) {
        Timestamp t = new Timestamp(0L);
        TimestampWritable.setTimestamp(t, bytes, offset);
        return t;
    }

    public boolean hasDecimal() {
        return TimestampWritable.hasDecimal(this.currentBytes[this.offset]);
    }

    public static boolean hasDecimal(byte b) {
        return b >> 7 != 0;
    }

    private static void intToBytes(int value, byte[] dest, int offset) {
        dest[offset] = (byte)(value >> 24 & 0xFF);
        dest[offset + 1] = (byte)(value >> 16 & 0xFF);
        dest[offset + 2] = (byte)(value >> 8 & 0xFF);
        dest[offset + 3] = (byte)(value & 0xFF);
    }

    private static int bytesToInt(byte[] bytes, int offset) {
        return (0xFF & bytes[offset]) << 24 | (0xFF & bytes[offset + 1]) << 16 | (0xFF & bytes[offset + 2]) << 8 | 0xFF & bytes[offset + 3];
    }
}

