/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="in", value="test _FUNC_(val1, val2...) - returns true if test equals any valN ")
public class GenericUDFIn
extends GenericUDF {
    private ObjectInspector[] argumentOIs;
    private Set<Object> constantInSet;
    private boolean isInSetConstant = true;
    BooleanWritable bw = new BooleanWritable();
    GenericUDFUtils.ReturnObjectInspectorResolver conversionHelper;
    ObjectInspector compareOI;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("The function IN requires at least two arguments, got " + arguments.length);
        }
        this.argumentOIs = arguments;
        this.conversionHelper = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        for (ObjectInspector oi : arguments) {
            if (this.conversionHelper.update(oi)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("The arguments for IN should be the same type! Types are: {");
            sb.append(arguments[0].getTypeName());
            sb.append(" IN (");
            for (int i = 1; i < arguments.length; ++i) {
                if (i != 1) {
                    sb.append(", ");
                }
                sb.append(arguments[i].getTypeName());
            }
            sb.append(")}");
            throw new UDFArgumentException(sb.toString());
        }
        this.compareOI = this.conversionHelper.get();
        this.checkIfInSetConstant();
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    private void checkIfInSetConstant() {
        for (int i = 1; i < this.argumentOIs.length; ++i) {
            if (this.argumentOIs[i] instanceof ConstantObjectInspector) continue;
            this.isInSetConstant = false;
            return;
        }
    }

    private void prepareInSet(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.constantInSet = new HashSet<Object>();
        if (this.compareOI.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
            for (int i = 1; i < arguments.length; ++i) {
                this.constantInSet.add(((PrimitiveObjectInspector)this.compareOI).getPrimitiveJavaObject(this.conversionHelper.convertIfNecessary(arguments[i].get(), this.argumentOIs[i])));
            }
        } else {
            for (int i = 1; i < arguments.length; ++i) {
                this.constantInSet.add(((ConstantObjectInspector)this.argumentOIs[i]).getWritableConstantValue());
            }
        }
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.bw.set(false);
        if (arguments[0].get() == null) {
            return null;
        }
        if (this.isInSetConstant) {
            if (this.constantInSet == null) {
                this.prepareInSet(arguments);
            }
            switch (this.compareOI.getCategory()) {
                case PRIMITIVE: {
                    if (!this.constantInSet.contains(((PrimitiveObjectInspector)this.compareOI).getPrimitiveJavaObject(this.conversionHelper.convertIfNecessary(arguments[0].get(), this.argumentOIs[0])))) break;
                    this.bw.set(true);
                    return this.bw;
                }
                case LIST: {
                    if (!this.constantInSet.contains(((ListObjectInspector)this.compareOI).getList(this.conversionHelper.convertIfNecessary(arguments[0].get(), this.argumentOIs[0])))) break;
                    this.bw.set(true);
                    return this.bw;
                }
                case MAP: {
                    if (!this.constantInSet.contains(((MapObjectInspector)this.compareOI).getMap(this.conversionHelper.convertIfNecessary(arguments[0].get(), this.argumentOIs[0])))) break;
                    this.bw.set(true);
                    return this.bw;
                }
                default: {
                    throw new RuntimeException("Compare of unsupported constant type: " + (Object)((Object)this.compareOI.getCategory()));
                }
            }
            if (this.constantInSet.contains(null)) {
                return null;
            }
        } else {
            int i;
            for (i = 1; i < arguments.length; ++i) {
                if (ObjectInspectorUtils.compare(this.conversionHelper.convertIfNecessary(arguments[0].get(), this.argumentOIs[0]), this.compareOI, this.conversionHelper.convertIfNecessary(arguments[i].get(), this.argumentOIs[i]), this.compareOI) != 0) continue;
                this.bw.set(true);
                return this.bw;
            }
            for (i = 1; i < arguments.length; ++i) {
                if (arguments[i].get() != null) continue;
                return null;
            }
        }
        return this.bw;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length >= 2);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(children[0]);
        sb.append(") ");
        sb.append("IN (");
        for (int i = 1; i < children.length; ++i) {
            sb.append(children[i]);
            if (i + 1 == children.length) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

