/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="assert_true", value="_FUNC_(condition) - Throw an exception if 'condition' is not true.", extended="Example:\n   > SELECT _FUNC_(x >= 0) FROM src LIMIT 1;\n  NULL")
@UDFType(deterministic=false)
public class GenericUDFAssertTrue
extends GenericUDF {
    private ObjectInspectorConverters.Converter conditionConverter = null;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("ASSERT_TRUE() expects one argument.");
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Argument to ASSERT_TRUE() should be primitive.");
        }
        this.conditionConverter = ObjectInspectorConverters.getConverter(arguments[0], PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
        return PrimitiveObjectInspectorFactory.writableVoidObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        BooleanWritable condition = (BooleanWritable)this.conditionConverter.convert(arguments[0].get());
        if (condition == null || !condition.get()) {
            throw new HiveException("ASSERT_TRUE(): assertion failed.");
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("assert_true(");
        for (int i = 0; i < children.length; ++i) {
            sb.append(children[i]);
            if (i == children.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

