/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCovariance;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="covar_samp", value="_FUNC_(x,y) - Returns the sample covariance of a set of number pairs", extended="The function takes as arguments any pair of numeric types and returns a double.\nAny pair with a NULL is ignored. If the function is applied to an empty set, NULL\nwill be returned. Otherwise, it computes the following:\n   (SUM(x*y)-SUM(x)*SUM(y)/COUNT(x,y))/(COUNT(x,y)-1)\nwhere neither x nor y is null.")
public class GenericUDAFCovarianceSample
extends GenericUDAFCovariance {
    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 2) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly two arguments are expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        if (parameters[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + parameters[1].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case TIMESTAMP: {
                switch (((PrimitiveTypeInfo)parameters[1]).getPrimitiveCategory()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case TIMESTAMP: {
                        return new GenericUDAFCovarianceSampleEvaluator();
                    }
                }
                throw new UDFArgumentTypeException(1, "Only numeric or string type arguments are accepted but " + parameters[1].getTypeName() + " is passed.");
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    public static class GenericUDAFCovarianceSampleEvaluator
    extends GenericUDAFCovariance.GenericUDAFCovarianceEvaluator {
        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            GenericUDAFCovariance.GenericUDAFCovarianceEvaluator.StdAgg myagg = (GenericUDAFCovariance.GenericUDAFCovarianceEvaluator.StdAgg)agg;
            if (myagg.count == 0L) {
                return null;
            }
            if (myagg.count > 1L) {
                this.getResult().set(myagg.covar / (double)(myagg.count - 1L));
            } else {
                this.getResult().set(0.0);
            }
            return this.getResult();
        }
    }
}

