/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.ppd.OpProcFactory;

public class ExprWalkerInfo
implements NodeProcessorCtx {
    protected static final Log LOG = LogFactory.getLog((String)OpProcFactory.class.getName());
    private Operator<? extends OperatorDesc> op = null;
    private RowResolver toRR = null;
    private final Map<String, List<ExprNodeDesc>> pushdownPreds;
    private final Map<String, List<ExprNodeDesc>> nonFinalPreds;
    private final Map<ExprNodeDesc, ExprInfo> exprInfoMap;
    private final Map<ExprNodeDesc, ExprNodeDesc> newToOldExprMap;
    private boolean isDeterministic = true;

    public ExprWalkerInfo() {
        this.pushdownPreds = new HashMap<String, List<ExprNodeDesc>>();
        this.nonFinalPreds = new HashMap<String, List<ExprNodeDesc>>();
        this.exprInfoMap = new HashMap<ExprNodeDesc, ExprInfo>();
        this.newToOldExprMap = new HashMap<ExprNodeDesc, ExprNodeDesc>();
    }

    public ExprWalkerInfo(Operator<? extends OperatorDesc> op, RowResolver toRR) {
        this.op = op;
        this.toRR = toRR;
        this.pushdownPreds = new HashMap<String, List<ExprNodeDesc>>();
        this.exprInfoMap = new HashMap<ExprNodeDesc, ExprInfo>();
        this.nonFinalPreds = new HashMap<String, List<ExprNodeDesc>>();
        this.newToOldExprMap = new HashMap<ExprNodeDesc, ExprNodeDesc>();
    }

    public Operator<? extends OperatorDesc> getOp() {
        return this.op;
    }

    public RowResolver getToRR() {
        return this.toRR;
    }

    public Map<ExprNodeDesc, ExprNodeDesc> getNewToOldExprMap() {
        return this.newToOldExprMap;
    }

    public ExprNodeDesc getConvertedNode(Node nd) {
        ExprInfo ei = this.exprInfoMap.get(nd);
        if (ei == null) {
            return null;
        }
        return ei.convertedExpr;
    }

    public void addConvertedNode(ExprNodeDesc oldNode, ExprNodeDesc newNode) {
        ExprInfo ei = this.exprInfoMap.get(oldNode);
        if (ei == null) {
            ei = new ExprInfo();
            this.exprInfoMap.put(oldNode, ei);
        }
        ei.convertedExpr = newNode;
        this.exprInfoMap.put(newNode, new ExprInfo(ei.isCandidate, ei.alias, null));
    }

    public boolean isCandidate(ExprNodeDesc expr) {
        ExprInfo ei = this.exprInfoMap.get(expr);
        if (ei == null) {
            return false;
        }
        return ei.isCandidate;
    }

    public void setIsCandidate(ExprNodeDesc expr, boolean b) {
        ExprInfo ei = this.exprInfoMap.get(expr);
        if (ei == null) {
            ei = new ExprInfo();
            this.exprInfoMap.put(expr, ei);
        }
        ei.isCandidate = b;
    }

    public String getAlias(ExprNodeDesc expr) {
        ExprInfo ei = this.exprInfoMap.get(expr);
        if (ei == null) {
            return null;
        }
        return ei.alias;
    }

    public void addAlias(ExprNodeDesc expr, String alias) {
        if (alias == null) {
            return;
        }
        ExprInfo ei = this.exprInfoMap.get(expr);
        if (ei == null) {
            ei = new ExprInfo();
            this.exprInfoMap.put(expr, ei);
        }
        ei.alias = alias;
    }

    public void addFinalCandidate(ExprNodeDesc expr) {
        String alias = this.getAlias(expr);
        if (this.pushdownPreds.get(alias) == null) {
            this.pushdownPreds.put(alias, new ArrayList());
        }
        this.pushdownPreds.get(alias).add(expr);
    }

    public void addPushDowns(String alias, List<ExprNodeDesc> pushDowns) {
        if (this.pushdownPreds.get(alias) == null) {
            this.pushdownPreds.put(alias, new ArrayList());
        }
        this.pushdownPreds.get(alias).addAll(pushDowns);
    }

    public Map<String, List<ExprNodeDesc>> getFinalCandidates() {
        return this.pushdownPreds;
    }

    public void addNonFinalCandidate(ExprNodeDesc expr) {
        String alias = this.getAlias(expr);
        if (this.nonFinalPreds.get(alias) == null) {
            this.nonFinalPreds.put(alias, new ArrayList());
        }
        this.nonFinalPreds.get(alias).add(expr);
    }

    public Map<String, List<ExprNodeDesc>> getNonFinalCandidates() {
        return this.nonFinalPreds;
    }

    public void merge(ExprWalkerInfo ewi) {
        List<ExprNodeDesc> predList;
        if (ewi == null) {
            return;
        }
        for (Map.Entry<String, List<ExprNodeDesc>> e : ewi.getFinalCandidates().entrySet()) {
            predList = this.pushdownPreds.get(e.getKey());
            if (predList != null) {
                predList.addAll((Collection<ExprNodeDesc>)e.getValue());
                continue;
            }
            this.pushdownPreds.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, List<ExprNodeDesc>> e : ewi.getNonFinalCandidates().entrySet()) {
            predList = this.nonFinalPreds.get(e.getKey());
            if (predList != null) {
                predList.addAll((Collection<ExprNodeDesc>)e.getValue());
                continue;
            }
            this.nonFinalPreds.put(e.getKey(), e.getValue());
        }
        this.newToOldExprMap.putAll(ewi.getNewToOldExprMap());
    }

    public void setDeterministic(boolean b) {
        this.isDeterministic = b;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    private static class ExprInfo {
        public boolean isCandidate = false;
        public String alias = null;
        public ExprNodeDesc convertedExpr = null;

        public ExprInfo() {
        }

        public ExprInfo(boolean isCandidate, String alias, ExprNodeDesc replacedNode) {
            this.isCandidate = isCandidate;
            this.alias = alias;
            this.convertedExpr = replacedNode;
        }
    }
}

