/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;

public class TableDesc
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Class<? extends Deserializer> deserializerClass;
    private Class<? extends InputFormat> inputFileFormatClass;
    private Class<? extends HiveOutputFormat> outputFileFormatClass;
    private Properties properties;
    private String serdeClassName;
    private Map<String, String> jobProperties;

    public TableDesc() {
    }

    public TableDesc(Class<? extends Deserializer> serdeClass, Class<? extends InputFormat> inputFileFormatClass, Class<?> class1, Properties properties) {
        this.deserializerClass = serdeClass;
        this.inputFileFormatClass = inputFileFormatClass;
        this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(class1);
        this.properties = properties;
        this.serdeClassName = properties.getProperty("serialization.lib");
    }

    public Class<? extends Deserializer> getDeserializerClass() {
        return this.deserializerClass;
    }

    public void setDeserializerClass(Class<? extends Deserializer> serdeClass) {
        this.deserializerClass = serdeClass;
    }

    public Class<? extends InputFormat> getInputFileFormatClass() {
        return this.inputFileFormatClass;
    }

    public Deserializer getDeserializer() throws Exception {
        Deserializer de = this.deserializerClass.newInstance();
        de.initialize(null, this.properties);
        return de;
    }

    public void setInputFileFormatClass(Class<? extends InputFormat> inputFileFormatClass) {
        this.inputFileFormatClass = inputFileFormatClass;
    }

    public Class<? extends HiveOutputFormat> getOutputFileFormatClass() {
        return this.outputFileFormatClass;
    }

    public void setOutputFileFormatClass(Class<?> outputFileFormatClass) {
        this.outputFileFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(outputFileFormatClass);
    }

    @Explain(displayName="properties", normalExplain=false)
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setJobProperties(Map<String, String> jobProperties) {
        this.jobProperties = jobProperties;
    }

    @Explain(displayName="jobProperties", normalExplain=false)
    public Map<String, String> getJobProperties() {
        return this.jobProperties;
    }

    @Explain(displayName="serde")
    public String getSerdeClassName() {
        return this.serdeClassName;
    }

    public void setSerdeClassName(String serdeClassName) {
        this.serdeClassName = serdeClassName;
    }

    @Explain(displayName="name")
    public String getTableName() {
        return this.properties.getProperty("name");
    }

    @Explain(displayName="input format")
    public String getInputFileFormatClassName() {
        return this.getInputFileFormatClass().getName();
    }

    @Explain(displayName="output format")
    public String getOutputFileFormatClassName() {
        return this.getOutputFileFormatClass().getName();
    }

    public boolean isNonNative() {
        return this.properties.getProperty("storage_handler") != null;
    }

    public Object clone() {
        TableDesc ret = new TableDesc();
        ret.setSerdeClassName(this.serdeClassName);
        ret.setDeserializerClass(this.deserializerClass);
        ret.setInputFileFormatClass(this.inputFileFormatClass);
        ret.setOutputFileFormatClass(this.outputFileFormatClass);
        Properties newProp = new Properties();
        Enumeration<Object> keysProp = this.properties.keys();
        while (keysProp.hasMoreElements()) {
            Object key = keysProp.nextElement();
            newProp.put(key, this.properties.get(key));
        }
        ret.setProperties(newProp);
        if (this.jobProperties != null) {
            ret.jobProperties = new LinkedHashMap<String, String>(this.jobProperties);
        }
        return ret;
    }
}

