/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ExprNodeDescUtils {
    public static int indexOf(ExprNodeDesc origin, List<ExprNodeDesc> sources) {
        for (int i = 0; i < sources.size(); ++i) {
            if (!origin.isSame(sources.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static ExprNodeDesc replace(ExprNodeDesc origin, List<ExprNodeDesc> sources, List<ExprNodeDesc> targets) {
        int index = ExprNodeDescUtils.indexOf(origin, sources);
        if (index >= 0) {
            return targets.get(index);
        }
        if (origin instanceof ExprNodeColumnDesc || origin instanceof ExprNodeFieldDesc) {
            return null;
        }
        if (origin instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)origin;
            if (!FunctionRegistry.isDeterministic(func.getGenericUDF()) || FunctionRegistry.isStateful(func.getGenericUDF())) {
                return null;
            }
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            for (int i = 0; i < origin.getChildren().size(); ++i) {
                ExprNodeDesc child = ExprNodeDescUtils.replace(origin.getChildren().get(i), sources, targets);
                if (child == null) {
                    return null;
                }
                children.add(child);
            }
            ExprNodeGenericFuncDesc clone = (ExprNodeGenericFuncDesc)func.clone();
            clone.setChildExprs(children);
            return clone;
        }
        return origin;
    }

    public static boolean containsPredicate(ExprNodeDesc source, ExprNodeDesc predicate) {
        if (source.isSame(predicate)) {
            return true;
        }
        return FunctionRegistry.isOpAnd(source) && (ExprNodeDescUtils.containsPredicate(source.getChildren().get(0), predicate) || ExprNodeDescUtils.containsPredicate(source.getChildren().get(1), predicate));
    }

    public static ExprNodeDesc mergePredicates(ExprNodeDesc prev, ExprNodeDesc next) {
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(2);
        children.add(prev);
        children.add(next);
        return new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
    }
}

