/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExplainWork;

public class ExplainSemanticAnalyzer
extends BaseSemanticAnalyzer {
    List<FieldSchema> fieldList;

    public ExplainSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.ctx.setExplain(true);
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.conf, (ASTNode)ast.getChild(0));
        sem.analyze((ASTNode)ast.getChild(0), this.ctx);
        sem.validate();
        boolean extended = false;
        boolean formatted = false;
        boolean dependency = false;
        if (ast.getChildCount() == 2) {
            int explainOptions = ast.getChild(1).getType();
            formatted = explainOptions == 255;
            extended = explainOptions == 254;
            dependency = explainOptions == 256;
        }
        this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
        List<Task<? extends Serializable>> tasks = sem.getRootTasks();
        FetchTask fetchTask = sem.getFetchTask();
        if (tasks == null) {
            if (fetchTask != null) {
                tasks = new ArrayList<Task<? extends Serializable>>();
                tasks.add(fetchTask);
            }
        } else if (fetchTask != null) {
            tasks.add(fetchTask);
        }
        Task<ExplainWork> explTask = TaskFactory.get(new ExplainWork(this.ctx.getResFile().toString(), tasks, ((ASTNode)ast.getChild(0)).toStringTree(), sem.getInputs(), extended, formatted, dependency), this.conf, new Task[0]);
        this.fieldList = explTask.getResultSchema();
        this.rootTasks.add(explTask);
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        return this.fieldList;
    }
}

