/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;

public class ColumnStatsSemanticAnalyzer
extends SemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog(ColumnStatsSemanticAnalyzer.class);
    private ASTNode originalTree;
    private ASTNode rewrittenTree;
    private String rewrittenQuery;
    private Context ctx;
    private boolean isRewritten;
    private boolean isTableLevel;
    private String tableName;
    private List<String> colNames;
    private List<String> colType;
    private String partName;

    public ColumnStatsSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    private boolean shouldRewrite(ASTNode tree) {
        ASTNode child1;
        ASTNode child0;
        boolean rwt = false;
        if (tree.getChildCount() > 1 && (child0 = (ASTNode)tree.getChild(0)).getToken().getType() == 10 && (child0 = (ASTNode)child0.getChild(0)).getToken().getType() == 239 && (child1 = (ASTNode)tree.getChild(1)).getToken().getType() == 160) {
            rwt = true;
        }
        return rwt;
    }

    private boolean isPartitionLevelStats(ASTNode tree) {
        boolean isPartitioned = false;
        ASTNode child = (ASTNode)tree.getChild(0);
        if (child.getChildCount() > 1 && (child = (ASTNode)child.getChild(1)).getToken().getType() == 11) {
            isPartitioned = true;
        }
        return isPartitioned;
    }

    private String getTableName(ASTNode tree) {
        return ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(0).getChild(0));
    }

    private PartitionList getPartKeyValuePairsFromAST(ASTNode tree) {
        ASTNode child = (ASTNode)tree.getChild(0).getChild(1);
        int numParts = child.getChildCount();
        PartitionList partList = new PartitionList(numParts);
        int numPartValue = 0;
        for (int i = 0; i < numParts; ++i) {
            String partValue;
            String partKey = new String(ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)child.getChild(i).getChild(0)));
            if (child.getChild(i).getChildCount() > 1) {
                partValue = new String(ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)child.getChild(i).getChild(1)));
                partValue = partValue.replaceAll("'", "");
                ++numPartValue;
            } else {
                partValue = null;
            }
            partList.addPartKey(partKey, i);
            if (partValue == null) continue;
            partList.addPartValue(partValue, i);
        }
        partList.setNumPartValues(numPartValue);
        return partList;
    }

    private List<String> getColumnName(ASTNode tree) {
        int numCols = tree.getChild(1).getChildCount();
        LinkedList<String> colName = new LinkedList<String>();
        for (int i = 0; i < numCols; ++i) {
            colName.add(i, new String(ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(1).getChild(i))));
        }
        return colName;
    }

    private int getNumColumns(ASTNode tree) {
        return tree.getChild(1).getChildCount();
    }

    private void validatePartitionKeys(String tableName, PartitionList partList) throws SemanticException {
        Table tbl;
        try {
            tbl = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        List<FieldSchema> partKeys = tbl.getPartitionKeys();
        String[] inputPartKeys = partList.getPartKeys();
        if (inputPartKeys.length != partKeys.size()) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INCORRECT_NUM_PART_KEY.getMsg());
        }
        LinkedHashMap<String, Integer> partKeysMap = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < inputPartKeys.length; ++i) {
            partKeysMap.put(inputPartKeys[i].toLowerCase(), new Integer(1));
        }
        for (FieldSchema partKey : partKeys) {
            if (partKeysMap.containsKey(partKey.getName().toLowerCase())) continue;
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PART_KEY.getMsg());
        }
    }

    private String[] getPartitionKeysType(String tableName, PartitionList partList) throws SemanticException {
        Table tbl;
        try {
            tbl = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        List<FieldSchema> partKeys = tbl.getPartitionKeys();
        String[] inputPartKeys = partList.getPartKeys();
        String[] inputPartKeyTypes = new String[inputPartKeys.length];
        block2: for (int i = 0; i < inputPartKeys.length; ++i) {
            for (FieldSchema partKey : partKeys) {
                if (!inputPartKeys[i].equalsIgnoreCase(partKey.getName())) continue;
                inputPartKeyTypes[i] = new String(partKey.getType());
                continue block2;
            }
        }
        return inputPartKeyTypes;
    }

    private String constructPartitionName(String tableName, PartitionList partList) throws SemanticException {
        Partition part;
        Table tbl;
        String[] partKeys = partList.getPartKeys();
        String[] partValues = partList.getPartValues();
        try {
            tbl = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partKeys.length; ++i) {
            partSpec.put(partKeys[i].toLowerCase(), partValues[i]);
        }
        try {
            part = this.db.getPartition(tbl, partSpec, false);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(this.partName));
        }
        if (part == null) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PARTITION.getMsg());
        }
        return part.getName();
    }

    private void validatePartitionClause(String tableName, PartitionList partList) throws SemanticException {
        int numPartValues;
        int numPartKeys = partList.getNumPartitions();
        if (numPartKeys != (numPartValues = partList.getNumPartValues())) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_SYNTAX.getMsg());
        }
        this.validatePartitionKeys(tableName, partList);
    }

    private StringBuilder genPartitionClause(PartitionList partList) throws SemanticException {
        StringBuilder whereClause = new StringBuilder(" where ");
        boolean predPresent = false;
        StringBuilder groupByClause = new StringBuilder(" group by ");
        boolean aggPresent = false;
        StringBuilder retClause = null;
        String[] partKeys = partList.getPartKeys();
        String[] partValues = partList.getPartValues();
        String[] partKeysType = this.getPartitionKeysType(this.tableName, partList);
        for (int i = 0; i < partList.getNumPartitions(); ++i) {
            if (partValues[i] != null) {
                if (!predPresent) {
                    whereClause.append(partKeys[i]);
                    whereClause.append(" = ");
                    if (partKeysType[i].equalsIgnoreCase("string")) {
                        whereClause.append("'");
                    }
                    whereClause.append(partValues[i]);
                    if (partKeysType[i].equalsIgnoreCase("string")) {
                        whereClause.append("'");
                    }
                    predPresent = true;
                    continue;
                }
                whereClause.append(" and ");
                whereClause.append(partKeys[i]);
                whereClause.append(" = ");
                if (partKeysType[i].equalsIgnoreCase("string")) {
                    whereClause.append("'");
                }
                whereClause.append(partValues[i]);
                if (!partKeysType[i].equalsIgnoreCase("string")) continue;
                whereClause.append("'");
                continue;
            }
            if (!aggPresent) {
                groupByClause.append(partKeys[i]);
                aggPresent = true;
                continue;
            }
            groupByClause.append(",");
            groupByClause.append(partKeys[i]);
        }
        if (predPresent) {
            retClause = new StringBuilder(whereClause);
        }
        if (aggPresent) {
            retClause.append((CharSequence)groupByClause);
        }
        return retClause;
    }

    private int getNumBitVectorsForNDVEstimation(HiveConf conf) {
        float percentageError = HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_STATS_NDV_ERROR);
        int numBitVectors = (double)percentageError <= 2.4 ? 1024 : ((double)percentageError <= 3.4 ? 1024 : ((double)percentageError <= 4.8 ? 512 : ((double)percentageError <= 6.8 ? 256 : ((double)percentageError <= 9.7 ? 128 : ((double)percentageError <= 13.8 ? 64 : ((double)percentageError <= 19.6 ? 32 : ((double)percentageError <= 28.2 ? 16 : ((double)percentageError <= 40.9 ? 8 : ((double)percentageError <= 61.0 ? 4 : 2)))))))));
        return numBitVectors;
    }

    private List<String> getTableColumnType(String tableName, List<String> colNames, int numCols) throws SemanticException {
        Table tbl;
        LinkedList<String> colTypes = new LinkedList<String>();
        try {
            tbl = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        List<FieldSchema> cols = tbl.getCols();
        for (int i = 0; i < numCols; ++i) {
            String colName = colNames.get(i);
            for (FieldSchema col : cols) {
                if (!colName.equalsIgnoreCase(col.getName())) continue;
                colTypes.add(i, new String(col.getType()));
            }
        }
        return colTypes;
    }

    private List<String> getPartitionColumnType(String tableName, String partName, List<String> colNames, int numCols) throws SemanticException {
        List<Partition> partitionList;
        Table tbl;
        LinkedList<String> colTypes = new LinkedList<String>();
        try {
            tbl = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(partName);
        try {
            partitionList = this.db.getPartitionsByNames(tbl, partNames);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partName));
        }
        Partition part = partitionList.get(0);
        List<FieldSchema> cols = part.getCols();
        for (int i = 0; i < numCols; ++i) {
            String colName = colNames.get(i);
            for (FieldSchema col : cols) {
                if (!colName.equalsIgnoreCase(col.getName())) continue;
                colTypes.add(i, new String(col.getType()));
            }
        }
        return colTypes;
    }

    private String genRewrittenQuery(List<String> colNames, int numBitVectors, PartitionList partList, boolean isPartitionStats) throws SemanticException {
        StringBuilder rewrittenQueryBuilder = new StringBuilder("select ");
        for (int i = 0; i < colNames.size(); ++i) {
            if (i > 0) {
                rewrittenQueryBuilder.append(" , ");
            }
            rewrittenQueryBuilder.append("compute_stats(");
            rewrittenQueryBuilder.append(colNames.get(i));
            rewrittenQueryBuilder.append(" , ");
            rewrittenQueryBuilder.append(numBitVectors);
            rewrittenQueryBuilder.append(" )");
        }
        rewrittenQueryBuilder.append(" from ");
        rewrittenQueryBuilder.append(this.tableName);
        this.isRewritten = true;
        if (isPartitionStats) {
            rewrittenQueryBuilder.append((CharSequence)this.genPartitionClause(partList));
        }
        String rewrittenQuery = rewrittenQueryBuilder.toString();
        rewrittenQuery = new VariableSubstitution().substitute(this.conf, rewrittenQuery);
        return rewrittenQuery;
    }

    private ASTNode genRewrittenTree(String rewrittenQuery) throws SemanticException {
        ASTNode rewrittenTree;
        try {
            this.ctx = new Context(this.conf);
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_IO_ERROR.getMsg());
        }
        this.ctx.setCmd(rewrittenQuery);
        ParseDriver pd = new ParseDriver();
        try {
            rewrittenTree = pd.parse(rewrittenQuery, this.ctx);
        }
        catch (ParseException e) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_PARSE_ERROR.getMsg());
        }
        rewrittenTree = ParseUtils.findRootNonNullToken(rewrittenTree);
        return rewrittenTree;
    }

    public ColumnStatsSemanticAnalyzer(HiveConf conf, ASTNode tree) throws SemanticException {
        super(conf);
        if (this.shouldRewrite(tree)) {
            this.tableName = new String(this.getTableName(tree));
            this.colNames = this.getColumnName(tree);
            int numCols = this.getNumColumns(tree);
            this.originalTree = tree;
            boolean isPartitionStats = this.isPartitionLevelStats(tree);
            PartitionList partList = null;
            if (isPartitionStats) {
                this.isTableLevel = false;
                partList = this.getPartKeyValuePairsFromAST(tree);
                this.validatePartitionClause(this.tableName, partList);
                this.partName = this.constructPartitionName(this.tableName, partList);
                this.colType = this.getPartitionColumnType(this.tableName, this.partName, this.colNames, numCols);
            } else {
                this.isTableLevel = true;
                this.colType = this.getTableColumnType(this.tableName, this.colNames, numCols);
            }
            int numBitVectors = this.getNumBitVectorsForNDVEstimation(conf);
            this.rewrittenQuery = this.genRewrittenQuery(this.colNames, numBitVectors, partList, isPartitionStats);
            this.rewrittenTree = this.genRewrittenTree(this.rewrittenQuery);
        } else {
            this.originalTree = this.rewrittenTree = tree;
            this.rewrittenQuery = null;
            this.isRewritten = false;
        }
    }

    @Override
    public void analyze(ASTNode ast, Context origCtx) throws SemanticException {
        this.init();
        if (this.isRewritten) {
            QB qb = this.getQB();
            qb.setAnalyzeRewrite(true);
            QBParseInfo qbp = qb.getParseInfo();
            qbp.setTableName(this.tableName);
            qbp.setTblLvl(this.isTableLevel);
            if (!this.isTableLevel) {
                qbp.setPartName(this.partName);
            }
            qbp.setColName(this.colNames);
            qbp.setColType(this.colType);
            this.initCtx(this.ctx);
            LOG.info((Object)"Invoking analyze on rewritten query");
            this.analyzeInternal(this.rewrittenTree);
        } else {
            this.initCtx(origCtx);
            LOG.info((Object)"Invoking analyze on original query");
            this.analyzeInternal(this.originalTree);
        }
    }

    private class PartitionList {
        private final String[] partKeys;
        private String[] partKeyTypes;
        private final String[] partValues;
        private int numPartitions;
        private int numPartitionValues;

        PartitionList(int numPartitions) {
            this.numPartitions = numPartitions;
            this.partKeys = new String[numPartitions];
            this.partValues = new String[numPartitions];
        }

        public int getNumPartitions() {
            return this.numPartitions;
        }

        public void setNumPartitions(int numPartitions) {
            this.numPartitions = numPartitions;
        }

        public String[] getPartValues() {
            return this.partValues;
        }

        public String[] getPartKeys() {
            return this.partKeys;
        }

        public void addPartValue(String partValue, int index) {
            this.partValues[index] = new String(partValue);
        }

        public void addPartKey(String partKey, int index) {
            this.partKeys[index] = new String(partKey);
        }

        public int getNumPartValues() {
            return this.numPartitionValues;
        }

        public void setNumPartValues(int numPartValues) {
            this.numPartitionValues = numPartValues;
        }

        public String[] getPartKeyTypes() {
            return this.partKeyTypes;
        }

        public void setPartKeyTypes(String[] partKeyTypes) {
            this.partKeyTypes = partKeyTypes;
        }

        public void setPartKeyType(String partKeyType, int index) {
            this.partKeyTypes[index] = partKeyType;
        }
    }
}

