/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapRedTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverCommonJoin;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;

public class CommonJoinResolver
implements PhysicalPlanResolver {
    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        CommonJoinTaskDispatcher disp = new CommonJoinTaskDispatcher(pctx);
        TaskGraphWalker ogw = new TaskGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.rootTasks);
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    class CommonJoinTaskDispatcher
    implements Dispatcher {
        private final PhysicalContext physicalContext;

        public CommonJoinTaskDispatcher(PhysicalContext context) {
            this.physicalContext = context;
        }

        private ConditionalTask processCurrentTask(MapRedTask currTask, ConditionalTask conditionalTask, Context context) throws SemanticException {
            JoinOperator joinOp = this.getJoinOp(currTask);
            if (joinOp == null) {
                return null;
            }
            currTask.setTaskTag(1);
            MapredWork currWork = (MapredWork)currTask.getWork();
            ArrayList<MapredWork> listWorks = new ArrayList<MapredWork>();
            ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
            HashMap<String, Task<? extends Serializable>> aliasToTask = new HashMap<String, Task<? extends Serializable>>();
            LinkedHashMap<String, ArrayList<String>> pathToAliases = ((MapredWork)currTask.getWork()).getPathToAliases();
            ParseContext parseCtx = this.physicalContext.getParseContext();
            QBJoinTree joinTree = parseCtx.getJoinContext().get(joinOp);
            JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
            Byte[] order = joinDesc.getTagOrder();
            int numAliases = order.length;
            long aliasTotalKnownInputSize = 0L;
            HashMap<String, Long> aliasToSize = new HashMap<String, Long>();
            try {
                Utilities.getInputSummary(context, currWork, null).getLength();
                for (Map.Entry entry : ((HashMap)pathToAliases).entrySet()) {
                    String path = (String)entry.getKey();
                    List aliasList = (List)entry.getValue();
                    ContentSummary cs = context.getCS(path);
                    if (cs == null) continue;
                    long size = cs.getLength();
                    for (String alias : aliasList) {
                        aliasTotalKnownInputSize += size;
                        Long es = (Long)aliasToSize.get(alias);
                        if (es == null) {
                            es = new Long(0L);
                        }
                        es = es + size;
                        aliasToSize.put(alias, es);
                    }
                }
                HashSet<Integer> bigTableCandidates = MapJoinProcessor.getBigTableCandidates(joinDesc.getConds());
                if (bigTableCandidates == null) {
                    return null;
                }
                currWork.setOpParseCtxMap(parseCtx.getOpParseCtx());
                currWork.setJoinTree(joinTree);
                String xml = currWork.toXML();
                String bigTableAlias = null;
                long ThresholdOfSmallTblSizeSum = HiveConf.getLongVar(context.getConf(), HiveConf.ConfVars.HIVESMALLTABLESFILESIZE);
                for (int i = 0; i < numAliases; ++i) {
                    long smallTblTotalKnownSize;
                    MapRedTask newTask;
                    JoinOperator newJoinOp;
                    ByteArrayInputStream in;
                    MapredWork newWork;
                    Long aliasKnownSize;
                    if (!bigTableCandidates.contains(i) || (aliasKnownSize = (Long)aliasToSize.get(bigTableAlias = MapJoinProcessor.genMapJoinOpAndLocalWork(newWork = Utilities.deserializeMapRedWork(in = new ByteArrayInputStream(xml.getBytes("UTF-8")), this.physicalContext.getConf()), newJoinOp = this.getJoinOp(newTask = (MapRedTask)TaskFactory.get(newWork, this.physicalContext.getParseContext().getConf(), new Task[0])), i))) != null && aliasKnownSize > 0L && (smallTblTotalKnownSize = aliasTotalKnownInputSize - aliasKnownSize) > ThresholdOfSmallTblSizeSum) continue;
                    listWorks.add(newWork);
                    listTasks.add(newTask);
                    newTask.setTaskTag(2);
                    newTask.setBackupTask(currTask);
                    newTask.setBackupChildrenTasks(currTask.getChildTasks());
                    aliasToTask.put(bigTableAlias, newTask);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SemanticException("Generate Map Join Task Error: " + e.getMessage());
            }
            listWorks.add((MapredWork)currTask.getWork());
            listTasks.add(currTask);
            currWork.setOpParseCtxMap(null);
            currWork.setJoinTree(null);
            ConditionalWork cndWork = new ConditionalWork(listWorks);
            ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(cndWork, parseCtx.getConf(), new Task[0]);
            cndTsk.setListTasks(listTasks);
            cndTsk.setResolver(new ConditionalResolverCommonJoin());
            ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx resolverCtx = new ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx();
            resolverCtx.setPathToAliases(pathToAliases);
            resolverCtx.setAliasToKnownSize(aliasToSize);
            resolverCtx.setAliasToTask(aliasToTask);
            resolverCtx.setCommonJoinTask(currTask);
            resolverCtx.setLocalTmpDir(context.getLocalScratchDir(false));
            resolverCtx.setHdfsTmpDir(context.getMRScratchDir());
            cndTsk.setResolverCtx(resolverCtx);
            this.replaceTaskWithConditionalTask(currTask, cndTsk, this.physicalContext);
            return cndTsk;
        }

        private void replaceTaskWithConditionalTask(Task<? extends Serializable> currTask, ConditionalTask cndTsk, PhysicalContext physicalContext) {
            List<Task<Serializable>> parentTasks = currTask.getParentTasks();
            currTask.setParentTasks(null);
            if (parentTasks != null) {
                for (Task<Serializable> tsk : parentTasks) {
                    tsk.addDependentTask(cndTsk);
                    tsk.removeDependentTask(currTask);
                }
            } else {
                physicalContext.removeFromRootTask(currTask);
                physicalContext.addToRootTask(cndTsk);
            }
            List<Task<Serializable>> oldChildTasks = currTask.getChildTasks();
            if (oldChildTasks != null) {
                for (Task<? extends Serializable> tsk : cndTsk.getListTasks()) {
                    if (tsk.equals(currTask)) continue;
                    for (Task<Serializable> oldChild : oldChildTasks) {
                        tsk.addDependentTask(oldChild);
                    }
                }
            }
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            if (nodeOutputs == null || nodeOutputs.length == 0) {
                throw new SemanticException("No Dispatch Context");
            }
            TaskGraphWalker.TaskGraphWalkerContext walkerCtx = (TaskGraphWalker.TaskGraphWalkerContext)nodeOutputs[0];
            Task currTask = (Task)nd;
            if (currTask.isMapRedTask()) {
                if (currTask instanceof ConditionalTask) {
                    List<Task<? extends Serializable>> taskList = ((ConditionalTask)currTask).getListTasks();
                    for (Task<? extends Serializable> tsk : taskList) {
                        if (!tsk.isMapRedTask()) continue;
                        ConditionalTask cndTask = this.processCurrentTask((MapRedTask)tsk, (ConditionalTask)currTask, this.physicalContext.getContext());
                        walkerCtx.addToDispatchList(cndTask);
                    }
                } else {
                    ConditionalTask cndTask = this.processCurrentTask((MapRedTask)currTask, null, this.physicalContext.getContext());
                    walkerCtx.addToDispatchList(cndTask);
                }
            }
            return null;
        }

        private JoinOperator getJoinOp(MapRedTask task) throws SemanticException {
            if (task.getWork() == null) {
                return null;
            }
            Operator<?> reducerOp = ((MapredWork)task.getWork()).getReducer();
            if (reducerOp instanceof JoinOperator) {
                return (JoinOperator)reducerOp;
            }
            return null;
        }
    }
}

