/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.util.StringUtils;

public class SortedMergeBucketMapJoinOptimizer
implements Transform {
    private static final Log LOG = LogFactory.getLog((String)SortedMergeBucketMapJoinOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", MapJoinOperator.getOperatorName() + "%"), this.getSortedMergeBucketMapjoinProc(pctx));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this.getDefaultProc(), opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private NodeProcessor getSortedMergeBucketMapjoinProc(ParseContext pctx) {
        return new SortedMergeBucketMapjoinProc(pctx);
    }

    private NodeProcessor getDefaultProc() {
        return new NodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        };
    }

    class SortedMergeBucketMapjoinProc
    implements NodeProcessor {
        private ParseContext pGraphContext;

        public SortedMergeBucketMapjoinProc(ParseContext pctx) {
            this.pGraphContext = pctx;
        }

        public SortedMergeBucketMapjoinProc() {
        }

        private boolean convertSMBJoin(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            if (nd instanceof SMBMapJoinOperator) {
                return false;
            }
            MapJoinOperator mapJoinOp = (MapJoinOperator)nd;
            if (((MapJoinDesc)mapJoinOp.getConf()).getAliasBucketFileNameMapping() == null || ((MapJoinDesc)mapJoinOp.getConf()).getAliasBucketFileNameMapping().size() == 0) {
                return false;
            }
            boolean tableSorted = true;
            QBJoinTree joinCxt = this.pGraphContext.getMapJoinContext().get(mapJoinOp);
            if (joinCxt == null) {
                return false;
            }
            String[] srcs = joinCxt.getBaseSrc();
            int pos = 0;
            ArrayList<Order> sortColumnsFirstTable = new ArrayList<Order>();
            for (String src : srcs) {
                tableSorted = tableSorted && this.isTableSorted(this.pGraphContext, mapJoinOp, joinCxt, src, pos, sortColumnsFirstTable);
                ++pos;
            }
            if (!tableSorted) {
                MapJoinProcessor.checkMapJoin(((MapJoinDesc)((MapJoinOperator)nd).getConf()).getPosBigTable(), ((MapJoinDesc)((MapJoinOperator)nd).getConf()).getConds());
                return false;
            }
            this.convertToSMBJoin(mapJoinOp, srcs);
            return true;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            boolean convert = this.convertSMBJoin(nd, stack, procCtx, nodeOutputs);
            if (!convert && this.pGraphContext.getConf().getBoolVar(HiveConf.ConfVars.HIVEENFORCESORTMERGEBUCKETMAPJOIN)) {
                throw new SemanticException(ErrorMsg.SORTMERGE_MAPJOIN_FAILED.getMsg());
            }
            return null;
        }

        private SMBMapJoinOperator convertToSMBJoin(MapJoinOperator mapJoinOp, String[] srcs) {
            SMBMapJoinOperator smbJop = new SMBMapJoinOperator(mapJoinOp);
            SMBJoinDesc smbJoinDesc = new SMBJoinDesc((MapJoinDesc)mapJoinOp.getConf());
            smbJop.setConf(smbJoinDesc);
            HashMap<Byte, String> tagToAlias = new HashMap<Byte, String>();
            for (int i = 0; i < srcs.length; ++i) {
                tagToAlias.put((byte)i, srcs[i]);
            }
            smbJoinDesc.setTagToAlias(tagToAlias);
            int indexInListMapJoinNoReducer = this.pGraphContext.getListMapJoinOpsNoReducer().indexOf(mapJoinOp);
            if (indexInListMapJoinNoReducer >= 0) {
                this.pGraphContext.getListMapJoinOpsNoReducer().remove(indexInListMapJoinNoReducer);
                this.pGraphContext.getListMapJoinOpsNoReducer().add(indexInListMapJoinNoReducer, smbJop);
            }
            List<Operator<OperatorDesc>> parentOperators = mapJoinOp.getParentOperators();
            for (int i = 0; i < parentOperators.size(); ++i) {
                Operator<OperatorDesc> par = parentOperators.get(i);
                int index = par.getChildOperators().indexOf(mapJoinOp);
                par.getChildOperators().remove(index);
                par.getChildOperators().add(index, smbJop);
            }
            List<Operator<OperatorDesc>> childOps = mapJoinOp.getChildOperators();
            for (int i = 0; i < childOps.size(); ++i) {
                Operator<OperatorDesc> child = childOps.get(i);
                int index = child.getParentOperators().indexOf(mapJoinOp);
                child.getParentOperators().remove(index);
                child.getParentOperators().add(index, smbJop);
            }
            return smbJop;
        }

        private boolean isTableSorted(ParseContext pctx, MapJoinOperator op, QBJoinTree joinTree, String alias, int pos, List<Order> sortColumnsFirstTable) throws SemanticException {
            HashMap<String, Operator<? extends OperatorDesc>> topOps = this.pGraphContext.getTopOps();
            HashMap<TableScanOperator, Table> topToTable = this.pGraphContext.getTopToTable();
            TableScanOperator tso = (TableScanOperator)topOps.get(alias);
            if (tso == null) {
                return false;
            }
            List<ExprNodeDesc> keys = ((MapJoinDesc)op.getConf()).getKeys().get((byte)pos);
            ArrayList<String> joinCols = new ArrayList<String>();
            ArrayList<ExprNodeDesc> joinKeys = new ArrayList<ExprNodeDesc>();
            joinKeys.addAll(keys);
            while (joinKeys.size() > 0) {
                ExprNodeDesc node = (ExprNodeDesc)joinKeys.remove(0);
                if (node instanceof ExprNodeColumnDesc) {
                    joinCols.addAll(node.getCols());
                    continue;
                }
                if (!(node instanceof ExprNodeGenericFuncDesc)) continue;
                ExprNodeGenericFuncDesc udfNode = (ExprNodeGenericFuncDesc)node;
                GenericUDF udf = udfNode.getGenericUDF();
                if (!FunctionRegistry.isDeterministic(udf)) {
                    return false;
                }
                joinKeys.addAll(0, udfNode.getChildExprs());
            }
            Table tbl = (Table)topToTable.get(tso);
            if (tbl.isPartitioned()) {
                PrunedPartitionList prunedParts = null;
                try {
                    prunedParts = this.pGraphContext.getOpToPartList().get(tso);
                    if (prunedParts == null) {
                        prunedParts = PartitionPruner.prune(tbl, this.pGraphContext.getOpToPartPruner().get(tso), this.pGraphContext.getConf(), alias, this.pGraphContext.getPrunedPartitions());
                        this.pGraphContext.getOpToPartList().put(tso, prunedParts);
                    }
                }
                catch (HiveException e) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                    throw new SemanticException(e.getMessage(), e);
                }
                List<Partition> partitions = prunedParts.getNotDeniedPartns();
                if (pos == 0 && partitions != null && !partitions.isEmpty()) {
                    Partition firstPartition = partitions.get(0);
                    sortColumnsFirstTable.addAll(firstPartition.getSortCols());
                }
                for (Partition partition : prunedParts.getNotDeniedPartns()) {
                    if (this.checkSortColsAndJoinCols(partition.getSortCols(), joinCols, sortColumnsFirstTable)) continue;
                    return false;
                }
                return true;
            }
            if (pos == 0) {
                sortColumnsFirstTable.addAll(tbl.getSortCols());
            }
            return this.checkSortColsAndJoinCols(tbl.getSortCols(), joinCols, sortColumnsFirstTable);
        }

        private boolean checkSortColsAndJoinCols(List<Order> sortCols, List<String> joinCols, List<Order> sortColumnsFirstPartition) {
            if (sortCols == null || sortCols.size() != joinCols.size()) {
                return false;
            }
            ArrayList<String> sortColNames = new ArrayList<String>();
            for (int pos = 0; pos < sortCols.size(); ++pos) {
                Order o = sortCols.get(pos);
                if (o.getOrder() != sortColumnsFirstPartition.get(pos).getOrder()) {
                    return false;
                }
                sortColNames.add(o.getCol());
            }
            return sortColNames.containsAll(joinCols);
        }
    }
}

