/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.GenMapRedWalker;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class MapJoinProcessor
implements Transform {
    private static final Log LOG = LogFactory.getLog((String)MapJoinProcessor.class.getName());
    private ParseContext pGraphContext = null;

    private Operator<? extends OperatorDesc> putOpInsertMap(Operator<? extends OperatorDesc> op, RowResolver rr) {
        OpParseContext ctx = new OpParseContext(rr);
        this.pGraphContext.getOpParseCtx().put(op, ctx);
        return op;
    }

    private static String genMapJoinLocalWork(MapredWork newWork, MapJoinOperator mapJoinOp, int bigTablePos) throws SemanticException {
        ArrayList<String> smallTableAliasList = new ArrayList<String>();
        String bigTableAlias = null;
        MapredLocalWork newLocalWork = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>(), new LinkedHashMap<String, FetchWork>());
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : newWork.getAliasToWork().entrySet()) {
            Operator<? extends OperatorDesc> op;
            String alias = entry.getKey();
            Operator<? extends OperatorDesc> parentOp = op = entry.getValue();
            Operator<OperatorDesc> childOp = op.getChildOperators().get(0);
            while (childOp != null && !childOp.equals(mapJoinOp)) {
                parentOp = childOp;
                assert (parentOp.getChildOperators().size() == 1);
                childOp = parentOp.getChildOperators().get(0);
            }
            if (childOp == null) {
                throw new SemanticException("Cannot find join op by tracing down the table scan operator tree");
            }
            int i = childOp.getParentOperators().indexOf(parentOp);
            if (i == bigTablePos) {
                bigTableAlias = alias;
                continue;
            }
            newLocalWork.getAliasToWork().put(alias, op);
            smallTableAliasList.add(alias);
            LinkedHashMap<String, ArrayList<String>> pathToAliases = newWork.getPathToAliases();
            HashSet<String> pathSet = new HashSet<String>();
            HashSet<String> emptyPath = new HashSet<String>();
            for (Map.Entry<String, ArrayList<String>> entry2 : pathToAliases.entrySet()) {
                String path = entry2.getKey();
                ArrayList<String> list = entry2.getValue();
                if (!list.contains(alias)) continue;
                if (!pathSet.contains(path)) {
                    pathSet.add(path);
                }
                list.remove(alias);
                if (list.size() != 0) continue;
                emptyPath.add(path);
            }
            for (String path : emptyPath) {
                pathToAliases.remove(path);
            }
            FetchWork fetchWork = null;
            ArrayList<String> partDir = new ArrayList<String>();
            ArrayList<PartitionDesc> partDesc = new ArrayList<PartitionDesc>();
            for (String tablePath : pathSet) {
                PartitionDesc partitionDesc = newWork.getPathToPartitionInfo().get(tablePath);
                if (partitionDesc.getPartSpec() == null || partitionDesc.getPartSpec().size() == 0) {
                    fetchWork = new FetchWork(tablePath, partitionDesc.getTableDesc());
                    break;
                }
                partDir.add(tablePath);
                partDesc.add(partitionDesc);
            }
            if (fetchWork == null) {
                TableDesc table = newWork.getAliasToPartnInfo().get(alias).getTableDesc();
                fetchWork = new FetchWork(partDir, partDesc, table);
            }
            newLocalWork.getAliasToFetchWork().put(alias, fetchWork);
        }
        for (String alias : smallTableAliasList) {
            newWork.getAliasToWork().remove(alias);
        }
        newWork.setMapLocalWork(newLocalWork);
        newWork.setReducer(null);
        if (bigTableAlias == null) {
            throw new SemanticException("Big Table Alias is null");
        }
        return bigTableAlias;
    }

    public static String genMapJoinOpAndLocalWork(MapredWork newWork, JoinOperator op, int mapJoinPos) throws SemanticException {
        try {
            LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext> opParseCtxMap = newWork.getOpParseCtxMap();
            QBJoinTree newJoinTree = newWork.getJoinTree();
            MapJoinOperator newMapJoinOp = MapJoinProcessor.convertMapJoin(opParseCtxMap, op, newJoinTree, mapJoinPos, true);
            String bigTableAlias = MapJoinProcessor.genMapJoinLocalWork(newWork, newMapJoinOp, mapJoinPos);
            newWork.setOpParseCtxMap(null);
            newWork.setJoinTree(null);
            return bigTableAlias;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SemanticException("Generate New MapJoin Opertor Exeception " + e.getMessage());
        }
    }

    public static MapJoinOperator convertMapJoin(LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext> opParseCtxMap, JoinOperator op, QBJoinTree joinTree, int mapJoinPos, boolean noCheckOuterJoin) throws SemanticException {
        JoinDesc desc = (JoinDesc)op.getConf();
        JoinCondDesc[] condns = desc.getConds();
        Byte[] tagOrder = desc.getTagOrder();
        if (!noCheckOuterJoin) {
            MapJoinProcessor.checkMapJoin(mapJoinPos, condns);
        }
        RowResolver oldOutputRS = opParseCtxMap.get(op).getRowResolver();
        RowResolver outputRS = new RowResolver();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        HashMap<Byte, List<ExprNodeDesc>> keyExprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        HashMap<Byte, List<ExprNodeDesc>> valueExprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        QBJoinTree leftSrc = joinTree.getJoinSrc();
        List<Operator<OperatorDesc>> parentOps = op.getParentOperators();
        ArrayList<Operator<? extends OperatorDesc>> newParentOps = new ArrayList<Operator<? extends OperatorDesc>>();
        ArrayList<Operator<OperatorDesc>> oldReduceSinkParentOps = new ArrayList<Operator<OperatorDesc>>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        HashMap<Byte, HashMap> columnTransfer = new HashMap<Byte, HashMap>();
        if (leftSrc != null) {
            Operator<OperatorDesc> parentOp = parentOps.get(0);
            assert (parentOp.getParentOperators().size() == 1);
            Operator<OperatorDesc> grandParentOp = parentOp.getParentOperators().get(0);
            oldReduceSinkParentOps.add(parentOp);
            grandParentOp.removeChild(parentOp);
            newParentOps.add(grandParentOp);
        }
        int pos = 0;
        for (String src : joinTree.getBaseSrc()) {
            if (src != null) {
                Operator<OperatorDesc> operator = parentOps.get(pos);
                assert (operator.getParentOperators().size() == 1);
                Operator<OperatorDesc> grandParentOp = operator.getParentOperators().get(0);
                grandParentOp.removeChild(operator);
                oldReduceSinkParentOps.add(operator);
                newParentOps.add(grandParentOp);
            }
            ++pos;
        }
        for (pos = 0; pos < newParentOps.size(); ++pos) {
            ReduceSinkOperator oldPar = (ReduceSinkOperator)oldReduceSinkParentOps.get(pos);
            ReduceSinkDesc rsconf = (ReduceSinkDesc)oldPar.getConf();
            Byte tag = (byte)rsconf.getTag();
            ArrayList<ExprNodeDesc> keys = rsconf.getKeyCols();
            keyExprMap.put(tag, keys);
            HashMap hashMap = (HashMap)oldPar.getColumnExprMap();
            columnTransfer.put(tag, hashMap);
        }
        for (pos = 0; pos < newParentOps.size(); ++pos) {
            RowResolver inputRS = opParseCtxMap.get(newParentOps.get(pos)).getRowResolver();
            ArrayList<ExprNodeColumnDesc> values = new ArrayList<ExprNodeColumnDesc>();
            for (String key : inputRS.getTableNames()) {
                HashMap<String, ColumnInfo> hashMap = inputRS.getFieldMap(key);
                for (String field : hashMap.keySet()) {
                    ColumnInfo valueInfo = inputRS.get(key, field);
                    ColumnInfo oldValueInfo = oldOutputRS.get(key, field);
                    if (oldValueInfo == null) continue;
                    String outputCol = oldValueInfo.getInternalName();
                    if (outputRS.get(key, field) != null) continue;
                    outputColumnNames.add(outputCol);
                    ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), valueInfo.getTabAlias(), valueInfo.getIsVirtualCol());
                    values.add(colDesc);
                    outputRS.put(key, field, new ColumnInfo(outputCol, valueInfo.getType(), valueInfo.getTabAlias(), valueInfo.getIsVirtualCol(), valueInfo.isHiddenVirtualCol()));
                    colExprMap.put(outputCol, colDesc);
                }
            }
            valueExprMap.put((byte)pos, values);
        }
        Map<Byte, List<ExprNodeDesc>> filters = desc.getFilters();
        for (Map.Entry<Byte, List<ExprNodeDesc>> entry : filters.entrySet()) {
            Byte srcAlias = entry.getKey();
            List<ExprNodeDesc> list = entry.getValue();
            for (ExprNodeDesc nodeExpr : list) {
                ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)nodeExpr;
                for (ExprNodeDesc childDesc : funcDesc.getChildExprs()) {
                    if (!(childDesc instanceof ExprNodeColumnDesc)) continue;
                    ExprNodeColumnDesc columnDesc = (ExprNodeColumnDesc)childDesc;
                    String column = columnDesc.getColumn();
                    String newColumn = null;
                    HashMap map = (HashMap)columnTransfer.get(srcAlias);
                    ExprNodeColumnDesc tmpDesc = (ExprNodeColumnDesc)map.get(column);
                    if (tmpDesc != null) {
                        newColumn = tmpDesc.getColumn();
                    }
                    if (newColumn == null) {
                        throw new SemanticException("No Column name found in parent reduce sink op");
                    }
                    columnDesc.setColumn(newColumn);
                }
            }
        }
        JoinCondDesc[] joinCondns = ((JoinDesc)op.getConf()).getConds();
        Operator[] newPar = new Operator[newParentOps.size()];
        pos = 0;
        for (Operator operator : newParentOps) {
            newPar[pos++] = operator;
        }
        List keyCols = (List)keyExprMap.get((byte)0);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < keyCols.size(); ++i) {
            stringBuilder.append("+");
        }
        TableDesc keyTableDesc = PlanUtils.getMapJoinKeyTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyCols, "mapjoinkey"));
        ArrayList<TableDesc> valueTableDescs = new ArrayList<TableDesc>();
        ArrayList<TableDesc> valueFiltedTableDescs = new ArrayList<TableDesc>();
        int[][] filterMap = desc.getFilterMap();
        for (pos = 0; pos < newParentOps.size(); ++pos) {
            List valueCols = (List)valueExprMap.get((byte)pos);
            int length = valueCols.size();
            ArrayList<ExprNodeDesc> valueFilteredCols = new ArrayList<ExprNodeDesc>(length);
            for (int i = 0; i < length; ++i) {
                valueFilteredCols.add(((ExprNodeDesc)valueCols.get(i)).clone());
            }
            if (filterMap != null && filterMap[pos] != null && pos != mapJoinPos) {
                ExprNodeColumnDesc isFilterDesc = new ExprNodeColumnDesc(TypeInfoFactory.getPrimitiveTypeInfo("tinyint"), "filter", "filter", false);
                valueFilteredCols.add(isFilterDesc);
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 0; i < valueCols.size(); ++i) {
                stringBuilder2.append("+");
            }
            TableDesc valueTableDesc = PlanUtils.getMapJoinValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueCols, "mapjoinvalue"));
            TableDesc valueFilteredTableDesc = PlanUtils.getMapJoinValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueFilteredCols, "mapjoinvalue"));
            valueTableDescs.add(valueTableDesc);
            valueFiltedTableDescs.add(valueFilteredTableDesc);
        }
        String dumpFilePrefix = "";
        if (joinTree.getMapAliases() != null) {
            for (String mapAlias : joinTree.getMapAliases()) {
                dumpFilePrefix = dumpFilePrefix + mapAlias;
            }
            dumpFilePrefix = dumpFilePrefix + "-" + PlanUtils.getCountForMapJoinDumpFilePrefix();
        } else {
            dumpFilePrefix = "mapfile" + PlanUtils.getCountForMapJoinDumpFilePrefix();
        }
        MapJoinDesc mapJoinDescriptor = new MapJoinDesc(keyExprMap, keyTableDesc, valueExprMap, valueTableDescs, valueFiltedTableDescs, outputColumnNames, mapJoinPos, joinCondns, filters, ((JoinDesc)op.getConf()).getNoOuterJoin(), dumpFilePrefix);
        mapJoinDescriptor.setTagOrder(tagOrder);
        mapJoinDescriptor.setNullSafes(desc.getNullSafes());
        mapJoinDescriptor.setFilterMap(desc.getFilterMap());
        MapJoinOperator mapJoinOp = (MapJoinOperator)OperatorFactory.getAndMakeChild(mapJoinDescriptor, new RowSchema(outputRS.getColumnInfos()), newPar);
        OpParseContext ctx = new OpParseContext(outputRS);
        opParseCtxMap.put(mapJoinOp, ctx);
        ((MapJoinDesc)mapJoinOp.getConf()).setReversedExprs(((JoinDesc)op.getConf()).getReversedExprs());
        mapJoinOp.setColumnExprMap(colExprMap);
        List<Operator<? extends OperatorDesc>> childOps = op.getChildOperators();
        for (Operator<OperatorDesc> operator : childOps) {
            operator.replaceParent(op, mapJoinOp);
        }
        mapJoinOp.setChildOperators(childOps);
        mapJoinOp.setParentOperators(newParentOps);
        op.setChildOperators(null);
        op.setParentOperators(null);
        return mapJoinOp;
    }

    public MapJoinOperator generateMapJoinOperator(ParseContext pctx, JoinOperator op, QBJoinTree joinTree, int mapJoinPos) throws SemanticException {
        HiveConf hiveConf = pctx.getConf();
        boolean noCheckOuterJoin = HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTSORTMERGEBUCKETMAPJOIN) && HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTBUCKETMAPJOIN);
        LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext> opParseCtxMap = pctx.getOpParseCtx();
        MapJoinOperator mapJoinOp = MapJoinProcessor.convertMapJoin(opParseCtxMap, op, joinTree, mapJoinPos, noCheckOuterJoin);
        this.genSelectPlan(pctx, mapJoinOp);
        return mapJoinOp;
    }

    public static HashSet<Integer> getBigTableCandidates(JoinCondDesc[] condns) {
        HashSet<Integer> bigTableCandidates = new HashSet<Integer>();
        boolean seenOuterJoin = false;
        HashSet<Integer> seenPostitions = new HashSet<Integer>();
        HashSet<Integer> leftPosListOfLastRightOuterJoin = new HashSet<Integer>();
        boolean lastSeenRightOuterJoin = false;
        for (JoinCondDesc condn : condns) {
            int joinType = condn.getType();
            seenPostitions.add(condn.getLeft());
            seenPostitions.add(condn.getRight());
            if (joinType == 3) {
                seenOuterJoin = true;
                lastSeenRightOuterJoin = false;
                return null;
            }
            if (joinType == 1 || joinType == 5) {
                seenOuterJoin = true;
                if (bigTableCandidates.size() == 0) {
                    bigTableCandidates.add(condn.getLeft());
                }
                lastSeenRightOuterJoin = false;
                continue;
            }
            if (joinType == 2) {
                seenOuterJoin = true;
                lastSeenRightOuterJoin = true;
                leftPosListOfLastRightOuterJoin.clear();
                leftPosListOfLastRightOuterJoin.addAll(seenPostitions);
                leftPosListOfLastRightOuterJoin.remove(condn.getRight());
                bigTableCandidates.clear();
                bigTableCandidates.add(condn.getRight());
                continue;
            }
            if (joinType != 0 || seenOuterJoin && !lastSeenRightOuterJoin) continue;
            if (!leftPosListOfLastRightOuterJoin.contains(condn.getLeft())) {
                bigTableCandidates.add(condn.getLeft());
            }
            if (leftPosListOfLastRightOuterJoin.contains(condn.getRight())) continue;
            bigTableCandidates.add(condn.getRight());
        }
        return bigTableCandidates;
    }

    public static void checkMapJoin(int mapJoinPos, JoinCondDesc[] condns) throws SemanticException {
        HashSet<Integer> bigTableCandidates = MapJoinProcessor.getBigTableCandidates(condns);
        if (bigTableCandidates == null || !bigTableCandidates.contains(mapJoinPos)) {
            throw new SemanticException(ErrorMsg.NO_OUTER_MAPJOIN.getMsg());
        }
    }

    private void genSelectPlan(ParseContext pctx, MapJoinOperator input) throws SemanticException {
        List<Operator<? extends OperatorDesc>> childOps = input.getChildOperators();
        input.setChildOperators(null);
        RowResolver inputRR = pctx.getOpParseCtx().get(input).getRowResolver();
        ArrayList<ExprNodeDesc> exprs = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputs = new ArrayList<String>();
        List<String> outputCols = ((MapJoinDesc)input.getConf()).getOutputColumnNames();
        RowResolver outputRS = new RowResolver();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < outputCols.size(); ++i) {
            String internalName = outputCols.get(i);
            String[] nm = inputRR.reverseLookup(internalName);
            ColumnInfo valueInfo = inputRR.get(nm[0], nm[1]);
            ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), nm[0], valueInfo.getIsVirtualCol());
            exprs.add(colDesc);
            outputs.add(internalName);
            outputRS.put(nm[0], nm[1], new ColumnInfo(internalName, valueInfo.getType(), nm[0], valueInfo.getIsVirtualCol(), valueInfo.isHiddenVirtualCol()));
            colExprMap.put(internalName, colDesc);
        }
        SelectDesc select = new SelectDesc(exprs, outputs, false);
        SelectOperator sel = (SelectOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(select, new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        sel.setColumnExprMap(colExprMap);
        sel.setChildOperators(childOps);
        for (Operator<? extends OperatorDesc> ch : childOps) {
            ch.replaceParent(input, sel);
        }
    }

    private int mapSideJoin(JoinOperator op, QBJoinTree joinTree) throws SemanticException {
        int mapJoinPos = -1;
        if (joinTree.isMapSideJoin()) {
            int pos = 0;
            if (joinTree.getJoinSrc() != null) {
                mapJoinPos = pos;
            }
            for (String src : joinTree.getBaseSrc()) {
                if (src != null && !joinTree.getMapAliases().contains(src)) {
                    if (mapJoinPos >= 0) {
                        return -1;
                    }
                    mapJoinPos = pos;
                }
                ++pos;
            }
            if (mapJoinPos == -1) {
                throw new SemanticException(ErrorMsg.INVALID_MAPJOIN_HINT.getMsg(this.pGraphContext.getQB().getParseInfo().getHints()));
            }
        }
        return mapJoinPos;
    }

    @Override
    public ParseContext transform(ParseContext pactx) throws SemanticException {
        this.pGraphContext = pactx;
        ArrayList<MapJoinOperator> listMapJoinOps = new ArrayList<MapJoinOperator>();
        if (this.pGraphContext.getJoinContext() != null) {
            HashMap<JoinOperator, QBJoinTree> joinMap = new HashMap<JoinOperator, QBJoinTree>();
            Map<MapJoinOperator, QBJoinTree> mapJoinMap = this.pGraphContext.getMapJoinContext();
            if (mapJoinMap == null) {
                mapJoinMap = new HashMap<MapJoinOperator, QBJoinTree>();
                this.pGraphContext.setMapJoinContext(mapJoinMap);
            }
            Set<Map.Entry<JoinOperator, QBJoinTree>> joinCtx = this.pGraphContext.getJoinContext().entrySet();
            for (Map.Entry<JoinOperator, QBJoinTree> joinEntry : joinCtx) {
                QBJoinTree qbJoin;
                JoinOperator joinOp = joinEntry.getKey();
                int mapJoinPos = this.mapSideJoin(joinOp, qbJoin = joinEntry.getValue());
                if (mapJoinPos >= 0) {
                    MapJoinOperator mapJoinOp = this.generateMapJoinOperator(pactx, joinOp, qbJoin, mapJoinPos);
                    listMapJoinOps.add(mapJoinOp);
                    mapJoinMap.put(mapJoinOp, qbJoin);
                    continue;
                }
                joinMap.put(joinOp, qbJoin);
            }
            this.pGraphContext.setJoinContext(joinMap);
        }
        ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinOpsNoRed = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R0", MapJoinOperator.getOperatorName() + "%"), MapJoinProcessor.getCurrentMapJoin());
        opRules.put(new RuleRegExp("R1", MapJoinOperator.getOperatorName() + "%.*" + FileSinkOperator.getOperatorName() + "%"), MapJoinProcessor.getMapJoinFS());
        opRules.put(new RuleRegExp("R2", MapJoinOperator.getOperatorName() + "%.*" + ReduceSinkOperator.getOperatorName() + "%"), MapJoinProcessor.getMapJoinDefault());
        opRules.put(new RuleRegExp("R4", MapJoinOperator.getOperatorName() + "%.*" + UnionOperator.getOperatorName() + "%"), MapJoinProcessor.getMapJoinDefault());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(MapJoinProcessor.getDefault(), opRules, new MapJoinWalkerCtx(listMapJoinOpsNoRed, this.pGraphContext));
        GenMapRedWalker ogw = new GenMapRedWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(listMapJoinOps);
        ogw.startWalking(topNodes, null);
        this.pGraphContext.setListMapJoinOpsNoReducer(listMapJoinOpsNoRed);
        return this.pGraphContext;
    }

    private static void addNoReducerMapJoinToCtx(MapJoinWalkerCtx ctx, AbstractMapJoinOperator<? extends MapJoinDesc> mapJoin) {
        if (ctx.getListRejectedMapJoins() != null && ctx.getListRejectedMapJoins().contains(mapJoin)) {
            return;
        }
        List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed = ctx.getListMapJoinsNoRed();
        if (listMapJoinsNoRed == null) {
            listMapJoinsNoRed = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        }
        if (!listMapJoinsNoRed.contains(mapJoin)) {
            listMapJoinsNoRed.add(mapJoin);
        }
        ctx.setListMapJoins(listMapJoinsNoRed);
    }

    private static void addRejectMapJoinToCtx(MapJoinWalkerCtx ctx, AbstractMapJoinOperator<? extends MapJoinDesc> mapjoin) {
        if (mapjoin == null) {
            return;
        }
        List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins = ctx.getListRejectedMapJoins();
        if (listRejectedMapJoins == null) {
            listRejectedMapJoins = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        }
        if (!listRejectedMapJoins.contains(mapjoin)) {
            listRejectedMapJoins.add(mapjoin);
        }
        if (ctx.getListMapJoinsNoRed() != null && ctx.getListMapJoinsNoRed().contains(mapjoin)) {
            ctx.getListMapJoinsNoRed().remove(mapjoin);
        }
        ctx.setListRejectedMapJoins(listRejectedMapJoins);
    }

    public static NodeProcessor getMapJoinFS() {
        return new MapJoinFS();
    }

    public static NodeProcessor getMapJoinDefault() {
        return new MapJoinDefault();
    }

    public static NodeProcessor getDefault() {
        return new Default();
    }

    public static NodeProcessor getCurrentMapJoin() {
        return new CurrentMapJoin();
    }

    public static class MapJoinWalkerCtx
    implements NodeProcessorCtx {
        private ParseContext pGraphContext;
        private List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed;
        private List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins;
        private AbstractMapJoinOperator<? extends MapJoinDesc> currMapJoinOp;

        public MapJoinWalkerCtx(List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed, ParseContext pGraphContext) {
            this.listMapJoinsNoRed = listMapJoinsNoRed;
            this.currMapJoinOp = null;
            this.listRejectedMapJoins = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
            this.pGraphContext = pGraphContext;
        }

        public List<AbstractMapJoinOperator<? extends MapJoinDesc>> getListMapJoinsNoRed() {
            return this.listMapJoinsNoRed;
        }

        public void setListMapJoins(List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed) {
            this.listMapJoinsNoRed = listMapJoinsNoRed;
        }

        public AbstractMapJoinOperator<? extends MapJoinDesc> getCurrMapJoinOp() {
            return this.currMapJoinOp;
        }

        public void setCurrMapJoinOp(AbstractMapJoinOperator<? extends MapJoinDesc> currMapJoinOp) {
            this.currMapJoinOp = currMapJoinOp;
        }

        public List<AbstractMapJoinOperator<? extends MapJoinDesc>> getListRejectedMapJoins() {
            return this.listRejectedMapJoins;
        }

        public void setListRejectedMapJoins(List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins) {
            this.listRejectedMapJoins = listRejectedMapJoins;
        }

        public ParseContext getpGraphContext() {
            return this.pGraphContext;
        }

        public void setpGraphContext(ParseContext pGraphContext) {
            this.pGraphContext = pGraphContext;
        }
    }

    public static class Default
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class MapJoinDefault
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            MapJoinWalkerCtx ctx = (MapJoinWalkerCtx)procCtx;
            AbstractMapJoinOperator<? extends MapJoinDesc> mapJoin = ctx.getCurrMapJoinOp();
            MapJoinProcessor.addRejectMapJoinToCtx(ctx, mapJoin);
            return null;
        }
    }

    public static class MapJoinFS
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            MapJoinWalkerCtx ctx = (MapJoinWalkerCtx)procCtx;
            AbstractMapJoinOperator<? extends MapJoinDesc> mapJoin = ctx.getCurrMapJoinOp();
            List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins = ctx.getListRejectedMapJoins();
            if (listRejectedMapJoins != null && listRejectedMapJoins.contains(mapJoin)) {
                return null;
            }
            MapJoinProcessor.addNoReducerMapJoinToCtx(ctx, mapJoin);
            return null;
        }
    }

    public static class CurrentMapJoin
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            MapJoinWalkerCtx ctx = (MapJoinWalkerCtx)procCtx;
            MapJoinOperator mapJoin = (MapJoinOperator)nd;
            if (ctx.getListRejectedMapJoins() != null && !ctx.getListRejectedMapJoins().contains(mapJoin)) {
                Boolean bigBranch = this.findGrandChildSubqueryMapjoin(ctx, mapJoin);
                if (bigBranch == null) {
                    ctx.setCurrMapJoinOp(mapJoin);
                    return null;
                }
                if (bigBranch.booleanValue()) {
                    MapJoinProcessor.addNoReducerMapJoinToCtx(ctx, mapJoin);
                } else {
                    MapJoinProcessor.addRejectMapJoinToCtx(ctx, mapJoin);
                }
            } else {
                ctx.setCurrMapJoinOp(mapJoin);
            }
            return null;
        }

        private Boolean findGrandChildSubqueryMapjoin(MapJoinWalkerCtx ctx, MapJoinOperator mapJoin) {
            Operator parent = mapJoin;
            while (parent.getChildOperators() != null && parent.getChildOperators().size() == 1) {
                Operator<OperatorDesc> ch = parent.getChildOperators().get(0);
                if (ch instanceof MapJoinOperator) {
                    if (!this.nonSubqueryMapJoin(ctx.getpGraphContext(), (MapJoinOperator)ch, mapJoin) && ch.getParentOperators().indexOf(parent) == ((MapJoinDesc)((MapJoinOperator)ch).getConf()).getPosBigTable()) {
                        return true;
                    }
                    return false;
                }
                if (ch instanceof JoinOperator || ch instanceof UnionOperator || ch instanceof ReduceSinkOperator || ch instanceof LateralViewJoinOperator || ch instanceof GroupByOperator || ch instanceof ScriptOperator) {
                    return null;
                }
                parent = ch;
            }
            return null;
        }

        private boolean nonSubqueryMapJoin(ParseContext pGraphContext, MapJoinOperator mapJoin, MapJoinOperator parentMapJoin) {
            QBJoinTree joinTree = pGraphContext.getMapJoinContext().get(mapJoin);
            QBJoinTree parentJoinTree = pGraphContext.getMapJoinContext().get(parentMapJoin);
            return joinTree.getJoinSrc() != null && joinTree.getJoinSrc().equals(parentJoinTree);
        }
    }
}

