/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeNullDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.util.StringUtils;

public class GroupByOptimizer
implements Transform {
    private static final Log LOG = LogFactory.getLog((String)GroupByOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        HiveConf conf = pctx.getConf();
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEGROUPBYSKEW)) {
            opRules.put(new RuleRegExp("R1", GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%"), this.getMapSortedGroupbyProc(pctx));
        } else {
            opRules.put(new RuleRegExp("R2", GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%"), this.getMapSortedGroupbySkewProc(pctx));
        }
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this.getDefaultProc(), opRules, new GroupByOptimizerContext(conf));
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private NodeProcessor getDefaultProc() {
        return new NodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        };
    }

    private NodeProcessor getMapSortedGroupbyProc(ParseContext pctx) {
        return new SortGroupByProcessor(pctx);
    }

    private NodeProcessor getMapSortedGroupbySkewProc(ParseContext pctx) {
        return new SortGroupBySkewProcessor(pctx);
    }

    public class GroupByOptimizerContext
    implements NodeProcessorCtx {
        List<GroupByOperator> listGroupByOperatorsProcessed;
        HiveConf conf;

        public GroupByOptimizerContext(HiveConf conf) {
            this.conf = conf;
            this.listGroupByOperatorsProcessed = new ArrayList<GroupByOperator>();
        }

        public List<GroupByOperator> getListGroupByOperatorsProcessed() {
            return this.listGroupByOperatorsProcessed;
        }

        public void setListGroupByOperatorsProcessed(List<GroupByOperator> listGroupByOperatorsProcessed) {
            this.listGroupByOperatorsProcessed = listGroupByOperatorsProcessed;
        }

        public HiveConf getConf() {
            return this.conf;
        }

        public void setConf(HiveConf conf) {
            this.conf = conf;
        }
    }

    public class SortGroupBySkewProcessor
    extends SortGroupByProcessor {
        public SortGroupBySkewProcessor(ParseContext pGraphContext) {
            super(pGraphContext);
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GroupByOptimizerContext ctx = (GroupByOptimizerContext)procCtx;
            GroupByOperator groupByOp = (GroupByOperator)stack.get(stack.size() - 5);
            if (!this.checkGroupByOperatorProcessed(ctx, groupByOp)) {
                this.processGroupBy(ctx, stack, groupByOp, 4);
            }
            return null;
        }
    }

    public class SortGroupByProcessor
    implements NodeProcessor {
        protected ParseContext pGraphContext;

        public SortGroupByProcessor(ParseContext pGraphContext) {
            this.pGraphContext = pGraphContext;
        }

        protected boolean checkGroupByOperatorProcessed(GroupByOptimizerContext groupBySortOptimizerContext, GroupByOperator groupByOp) {
            if (groupBySortOptimizerContext.getListGroupByOperatorsProcessed().contains(groupByOp)) {
                return true;
            }
            groupBySortOptimizerContext.getListGroupByOperatorsProcessed().add(groupByOp);
            return false;
        }

        protected void processGroupBy(GroupByOptimizerContext ctx, Stack<Node> stack, GroupByOperator groupByOp, int depth) throws SemanticException {
            HiveConf hiveConf = ctx.getConf();
            GroupByOptimizerSortMatch match = this.checkSortGroupBy(stack, groupByOp);
            boolean useMapperSort = HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVE_MAP_GROUPBY_SORT);
            if (useMapperSort && match == GroupByOptimizerSortMatch.COMPLETE_MATCH) {
                this.convertGroupByMapSideSortedGroupBy(groupByOp, depth);
            } else if (match == GroupByOptimizerSortMatch.PARTIAL_MATCH || match == GroupByOptimizerSortMatch.COMPLETE_MATCH) {
                ((GroupByDesc)groupByOp.getConf()).setBucketGroup(true);
            }
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GroupByOptimizerContext ctx = (GroupByOptimizerContext)procCtx;
            GroupByOperator groupByOp = (GroupByOperator)stack.get(stack.size() - 3);
            if (!this.checkGroupByOperatorProcessed(ctx, groupByOp)) {
                this.processGroupBy(ctx, stack, groupByOp, 2);
            }
            return null;
        }

        protected GroupByOptimizerSortMatch checkSortGroupBy(Stack<Node> stack, GroupByOperator groupByOp) throws SemanticException {
            if (((GroupByDesc)groupByOp.getConf()).getMode() != GroupByDesc.Mode.HASH) {
                return GroupByOptimizerSortMatch.NO_MATCH;
            }
            Operator currOp = groupByOp;
            currOp = currOp.getParentOperators().get(0);
            while (currOp.getParentOperators() != null) {
                if (currOp.getParentOperators().size() > 1 || !currOp.columnNamesRowResolvedCanBeObtained()) {
                    return GroupByOptimizerSortMatch.NO_MATCH;
                }
                currOp = currOp.getParentOperators().get(0);
            }
            TableScanOperator tableScanOp = (TableScanOperator)currOp;
            int stackPos = 0;
            assert (stack.get(0) == tableScanOp);
            HashMap<String, String> tableColsMapping = new HashMap<String, String>();
            HashSet constantCols = new HashSet();
            Table table = this.pGraphContext.getTopToTable().get(currOp);
            for (FieldSchema col : table.getAllCols()) {
                tableColsMapping.put(col.getName(), col.getName());
            }
            while (currOp != groupByOp) {
                SelectOperator selectOp;
                SelectDesc selectDesc;
                Operator processOp = currOp;
                HashSet<String> newConstantCols = new HashSet<String>();
                currOp = (Operator)stack.get(++stackPos);
                if (!(processOp instanceof SelectOperator) || (selectDesc = (SelectDesc)(selectOp = (SelectOperator)processOp).getConf()).isSelStarNoCompute()) continue;
                for (int pos = 0; pos < selectDesc.getColList().size(); ++pos) {
                    String outputColumnName = selectDesc.getOutputColumnNames().get(pos);
                    if (constantCols.contains(outputColumnName)) {
                        tableColsMapping.remove(outputColumnName);
                        newConstantCols.add(outputColumnName);
                        continue;
                    }
                    ExprNodeDesc selectColList = selectDesc.getColList().get(pos);
                    if (selectColList instanceof ExprNodeColumnDesc) {
                        String newValue = (String)tableColsMapping.get(((ExprNodeColumnDesc)selectColList).getColumn());
                        tableColsMapping.put(outputColumnName, newValue);
                        continue;
                    }
                    tableColsMapping.remove(outputColumnName);
                    if (!(selectColList instanceof ExprNodeConstantDesc) && !(selectColList instanceof ExprNodeNullDesc)) continue;
                    newConstantCols.add(outputColumnName);
                }
                constantCols = newConstantCols;
            }
            boolean sortGroupBy = true;
            ArrayList<String> groupByCols = new ArrayList<String>();
            for (ExprNodeDesc expr : ((GroupByDesc)groupByOp.getConf()).getKeys()) {
                if (expr instanceof ExprNodeColumnDesc) {
                    String groupByKeyColumn = ((ExprNodeColumnDesc)expr).getColumn();
                    if (constantCols.contains(groupByKeyColumn)) continue;
                    if (tableColsMapping.containsKey(groupByKeyColumn)) {
                        groupByCols.add((String)tableColsMapping.get(groupByKeyColumn));
                        continue;
                    }
                    return GroupByOptimizerSortMatch.NO_MATCH;
                }
                if (expr instanceof ExprNodeConstantDesc || expr instanceof ExprNodeNullDesc) continue;
                return GroupByOptimizerSortMatch.NO_MATCH;
            }
            if (!table.isPartitioned()) {
                List<String> sortCols = Utilities.getColumnNamesFromSortCols(table.getSortCols());
                List<String> bucketCols = table.getBucketCols();
                return this.matchBucketSortCols(groupByCols, bucketCols, sortCols);
            }
            PrunedPartitionList partsList = null;
            try {
                partsList = this.pGraphContext.getOpToPartList().get(tableScanOp);
                if (partsList == null) {
                    partsList = PartitionPruner.prune(table, this.pGraphContext.getOpToPartPruner().get(tableScanOp), this.pGraphContext.getConf(), table.getTableName(), this.pGraphContext.getPrunedPartitions());
                    this.pGraphContext.getOpToPartList().put(tableScanOp, partsList);
                }
            }
            catch (HiveException e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new SemanticException(e.getMessage(), e);
            }
            GroupByOptimizerSortMatch currentMatch = GroupByOptimizerSortMatch.COMPLETE_MATCH;
            for (Partition part : partsList.getNotDeniedPartns()) {
                List<String> sortCols = part.getSortColNames();
                List<String> bucketCols = part.getBucketCols();
                GroupByOptimizerSortMatch match = this.matchBucketSortCols(groupByCols, bucketCols, sortCols);
                if (match == GroupByOptimizerSortMatch.NO_MATCH) {
                    return match;
                }
                if (match != GroupByOptimizerSortMatch.PARTIAL_MATCH) continue;
                currentMatch = match;
            }
            return currentMatch;
        }

        private ColumnOrderMatch matchColumnOrder(List<String> cols1, List<String> cols2) {
            int numCols2;
            int numCols1 = cols1 == null ? 0 : cols1.size();
            int n = numCols2 = cols2 == null ? 0 : cols2.size();
            if (numCols1 == 0 || numCols2 == 0) {
                return ColumnOrderMatch.NO_MATCH;
            }
            for (int pos = 0; pos < Math.min(numCols1, numCols2); ++pos) {
                if (cols1.get(pos).equals(cols2.get(pos))) continue;
                return ColumnOrderMatch.NO_MATCH;
            }
            return numCols1 == numCols2 ? ColumnOrderMatch.COMPLETE_MATCH : (numCols1 < numCols2 ? ColumnOrderMatch.PREFIX_COL1_MATCH : ColumnOrderMatch.PREFIX_COL2_MATCH);
        }

        private GroupByOptimizerSortMatch matchBucketSortCols(List<String> groupByCols, List<String> bucketCols, List<String> sortCols) throws SemanticException {
            ColumnOrderMatch bucketSortColsMatch = this.matchColumnOrder(bucketCols, sortCols);
            ColumnOrderMatch sortGroupByColsMatch = this.matchColumnOrder(sortCols, groupByCols);
            switch (sortGroupByColsMatch) {
                case NO_MATCH: {
                    return GroupByOptimizerSortMatch.NO_MATCH;
                }
                case COMPLETE_MATCH: {
                    return bucketCols != null && !bucketCols.isEmpty() && sortCols.containsAll(bucketCols) ? GroupByOptimizerSortMatch.COMPLETE_MATCH : GroupByOptimizerSortMatch.PARTIAL_MATCH;
                }
                case PREFIX_COL1_MATCH: {
                    return GroupByOptimizerSortMatch.NO_MATCH;
                }
                case PREFIX_COL2_MATCH: {
                    return bucketSortColsMatch == ColumnOrderMatch.NO_MATCH || bucketCols.size() > groupByCols.size() ? GroupByOptimizerSortMatch.PARTIAL_MATCH : GroupByOptimizerSortMatch.COMPLETE_MATCH;
                }
            }
            return GroupByOptimizerSortMatch.NO_MATCH;
        }

        protected void convertGroupByMapSideSortedGroupBy(GroupByOperator groupByOp, int depth) {
            if (groupByOp.removeChildren(depth)) {
                groupByOp.setUseBucketizedHiveInputFormat(true);
                ((GroupByDesc)groupByOp.getConf()).setMode(GroupByDesc.Mode.FINAL);
            }
        }
    }

    private static enum ColumnOrderMatch {
        NO_MATCH,
        PREFIX_COL1_MATCH,
        PREFIX_COL2_MATCH,
        COMPLETE_MATCH;

    }

    public static enum GroupByOptimizerSortMatch {
        NO_MATCH,
        PARTIAL_MATCH,
        COMPLETE_MATCH;

    }
}

