/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroGenericRecordWriter;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class AvroContainerOutputFormat
implements HiveOutputFormat<LongWritable, AvroGenericRecordWritable> {
    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Path path, Class<? extends Writable> valueClass, boolean isCompressed, Properties properties, Progressable progressable) throws IOException {
        Schema schema;
        try {
            schema = AvroSerdeUtils.determineSchemaOrThrowException(properties);
        }
        catch (AvroSerdeException e) {
            throw new IOException(e);
        }
        GenericDatumWriter gdw = new GenericDatumWriter(schema);
        DataFileWriter<GenericRecord> dfw = new DataFileWriter<GenericRecord>(gdw);
        if (isCompressed) {
            int level = jobConf.getInt("avro.mapred.deflate.level", 1);
            String codecName = jobConf.get("avro.output.codec", "deflate");
            CodecFactory factory = codecName.equals("deflate") ? CodecFactory.deflateCodec(level) : CodecFactory.fromString(codecName);
            dfw.setCodec(factory);
        }
        dfw.create(schema, (OutputStream)path.getFileSystem((Configuration)jobConf).create(path));
        return new AvroGenericRecordWriter(dfw);
    }

    public RecordWriter<LongWritable, AvroGenericRecordWritable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) {
        return new RecordWriter<LongWritable, AvroGenericRecordWritable>(){

            public void write(LongWritable key, AvroGenericRecordWritable value) {
                throw new RuntimeException("Should not be called");
            }

            public void close(Reporter reporter) {
            }
        };
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
    }
}

