/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractMapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinDoubleKeys;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinSingleKey;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class JoinUtil {
    private static final byte[] MASKS = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

    public static HashMap<Byte, List<ObjectInspector>> getObjectInspectorsFromEvaluators(Map<Byte, List<ExprNodeEvaluator>> exprEntries, ObjectInspector[] inputObjInspector, int posBigTableAlias) throws HiveException {
        HashMap<Byte, List<ObjectInspector>> result = new HashMap<Byte, List<ObjectInspector>>();
        for (Map.Entry<Byte, List<ExprNodeEvaluator>> exprEntry : exprEntries.entrySet()) {
            Byte alias = exprEntry.getKey();
            if (alias == (byte)posBigTableAlias) continue;
            List<ExprNodeEvaluator> exprList = exprEntry.getValue();
            ArrayList<ObjectInspector> fieldOIList = new ArrayList<ObjectInspector>();
            for (int i = 0; i < exprList.size(); ++i) {
                fieldOIList.add(exprList.get(i).initialize(inputObjInspector[alias]));
            }
            result.put(alias, fieldOIList);
        }
        return result;
    }

    public static HashMap<Byte, List<ObjectInspector>> getStandardObjectInspectors(Map<Byte, List<ObjectInspector>> aliasToObjectInspectors, int posBigTableAlias) {
        HashMap<Byte, List<ObjectInspector>> result = new HashMap<Byte, List<ObjectInspector>>();
        for (Map.Entry<Byte, List<ObjectInspector>> oiEntry : aliasToObjectInspectors.entrySet()) {
            Byte alias = oiEntry.getKey();
            if (alias == (byte)posBigTableAlias) continue;
            List<ObjectInspector> oiList = oiEntry.getValue();
            ArrayList<ObjectInspector> fieldOIList = new ArrayList<ObjectInspector>(oiList.size());
            for (int i = 0; i < oiList.size(); ++i) {
                fieldOIList.add(ObjectInspectorUtils.getStandardObjectInspector(oiList.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
            }
            result.put(alias, fieldOIList);
        }
        return result;
    }

    public static int populateJoinKeyValue(Map<Byte, List<ExprNodeEvaluator>> outMap, Map<Byte, List<ExprNodeDesc>> inputMap, Byte[] order, int posBigTableAlias) {
        int total = 0;
        for (Map.Entry<Byte, List<ExprNodeDesc>> e : inputMap.entrySet()) {
            Byte key = order[e.getKey()];
            ArrayList<ExprNodeEvaluator> valueFields = new ArrayList<ExprNodeEvaluator>();
            List<ExprNodeDesc> expr = e.getValue();
            int sz = expr.size();
            total += sz;
            for (int j = 0; j < sz; ++j) {
                if (key == (byte)posBigTableAlias) {
                    valueFields.add(null);
                    continue;
                }
                valueFields.add(ExprNodeEvaluatorFactory.get(expr.get(j)));
            }
            outMap.put(key, valueFields);
        }
        return total;
    }

    public static ArrayList<Object> computeKeys(Object row, List<ExprNodeEvaluator> keyFields, List<ObjectInspector> keyFieldsOI) throws HiveException {
        ArrayList<Object> nr = new ArrayList<Object>(keyFields.size());
        for (int i = 0; i < keyFields.size(); ++i) {
            nr.add(ObjectInspectorUtils.copyToStandardObject(keyFields.get(i).evaluate(row), keyFieldsOI.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
        }
        return nr;
    }

    public static AbstractMapJoinKey computeMapJoinKeys(Object row, List<ExprNodeEvaluator> keyFields, List<ObjectInspector> keyFieldsOI) throws HiveException {
        int size = keyFields.size();
        if (size == 1) {
            Object obj = ObjectInspectorUtils.copyToStandardObject(keyFields.get(0).evaluate(row), keyFieldsOI.get(0), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            MapJoinSingleKey key = new MapJoinSingleKey(obj);
            return key;
        }
        if (size == 2) {
            Object obj1 = ObjectInspectorUtils.copyToStandardObject(keyFields.get(0).evaluate(row), keyFieldsOI.get(0), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            Object obj2 = ObjectInspectorUtils.copyToStandardObject(keyFields.get(1).evaluate(row), keyFieldsOI.get(1), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            MapJoinDoubleKeys key = new MapJoinDoubleKeys(obj1, obj2);
            return key;
        }
        Object[] nr = new Object[keyFields.size()];
        for (int i = 0; i < keyFields.size(); ++i) {
            nr[i] = ObjectInspectorUtils.copyToStandardObject(keyFields.get(i).evaluate(row), keyFieldsOI.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        MapJoinObjectKey key = new MapJoinObjectKey(nr);
        return key;
    }

    public static Object[] computeMapJoinValues(Object row, List<ExprNodeEvaluator> valueFields, List<ObjectInspector> valueFieldsOI, List<ExprNodeEvaluator> filters, List<ObjectInspector> filtersOI, int[] filterMap) throws HiveException {
        Object[] nr;
        if (filterMap != null) {
            nr = new Object[valueFields.size() + 1];
            nr[valueFields.size()] = new ByteWritable(JoinUtil.isFiltered(row, filters, filtersOI, filterMap));
        } else {
            nr = new Object[valueFields.size()];
        }
        for (int i = 0; i < valueFields.size(); ++i) {
            nr[i] = ObjectInspectorUtils.copyToStandardObject(valueFields.get(i).evaluate(row), valueFieldsOI.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        return nr;
    }

    public static ArrayList<Object> computeValues(Object row, List<ExprNodeEvaluator> valueFields, List<ObjectInspector> valueFieldsOI, List<ExprNodeEvaluator> filters, List<ObjectInspector> filtersOI, int[] filterMap) throws HiveException {
        ArrayList<Object> nr = new ArrayList<Object>(valueFields.size());
        for (int i = 0; i < valueFields.size(); ++i) {
            nr.add(ObjectInspectorUtils.copyToStandardObject(valueFields.get(i).evaluate(row), valueFieldsOI.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
        }
        if (filterMap != null) {
            nr.add(new ByteWritable(JoinUtil.isFiltered(row, filters, filtersOI, filterMap)));
        }
        return nr;
    }

    protected static byte isFiltered(Object row, List<ExprNodeEvaluator> filters, List<ObjectInspector> ois, int[] filterMap) throws HiveException {
        byte ret = 0;
        int j = 0;
        for (int i = 0; i < filterMap.length; i += 2) {
            int tag = filterMap[i];
            int length = filterMap[i + 1];
            boolean passed = true;
            while (length > 0) {
                if (passed) {
                    Object condition = filters.get(j).evaluate(row);
                    Boolean result = (Boolean)((PrimitiveObjectInspector)ois.get(j)).getPrimitiveJavaObject(condition);
                    if (result == null || !result.booleanValue()) {
                        passed = false;
                    }
                }
                --length;
                ++j;
            }
            if (passed) continue;
            ret = (byte)(ret | MASKS[tag]);
        }
        return ret;
    }

    protected static boolean isFiltered(byte filter, int tag) {
        return (filter & MASKS[tag]) != 0;
    }

    protected static boolean hasAnyFiltered(byte tag) {
        return tag != 0;
    }

    public static TableDesc getSpillTableDesc(Byte alias, Map<Byte, TableDesc> spillTableDesc, JoinDesc conf, boolean noFilter) {
        if (spillTableDesc == null || spillTableDesc.size() == 0) {
            spillTableDesc = JoinUtil.initSpillTables(conf, noFilter);
        }
        return spillTableDesc.get(alias);
    }

    public static Map<Byte, TableDesc> getSpillTableDesc(Map<Byte, TableDesc> spillTableDesc, JoinDesc conf, boolean noFilter) {
        if (spillTableDesc == null) {
            spillTableDesc = JoinUtil.initSpillTables(conf, noFilter);
        }
        return spillTableDesc;
    }

    public static SerDe getSpillSerDe(byte alias, Map<Byte, TableDesc> spillTableDesc, JoinDesc conf, boolean noFilter) {
        TableDesc desc = JoinUtil.getSpillTableDesc(alias, spillTableDesc, conf, noFilter);
        if (desc == null) {
            return null;
        }
        SerDe sd = (SerDe)ReflectionUtils.newInstance(desc.getDeserializerClass(), null);
        try {
            sd.initialize(null, desc.getProperties());
        }
        catch (SerDeException e) {
            e.printStackTrace();
            return null;
        }
        return sd;
    }

    public static Map<Byte, TableDesc> initSpillTables(JoinDesc conf, boolean noFilter) {
        Map<Byte, List<ExprNodeDesc>> exprs = conf.getExprs();
        HashMap<Byte, TableDesc> spillTableDesc = new HashMap<Byte, TableDesc>(exprs.size());
        for (int tag = 0; tag < exprs.size(); ++tag) {
            List<ExprNodeDesc> valueCols = exprs.get((byte)tag);
            int columnSize = valueCols.size();
            StringBuilder colNames = new StringBuilder();
            StringBuilder colTypes = new StringBuilder();
            if (columnSize <= 0) continue;
            for (int k = 0; k < columnSize; ++k) {
                String newColName = tag + "_VALUE_" + k;
                colNames.append(newColName);
                colNames.append(',');
                colTypes.append(valueCols.get(k).getTypeString());
                colTypes.append(',');
            }
            if (!noFilter) {
                colNames.append("filtered");
                colNames.append(',');
                colTypes.append(TypeInfoFactory.byteTypeInfo.getTypeName());
                colTypes.append(',');
            }
            colNames.setLength(colNames.length() - 1);
            colTypes.setLength(colTypes.length() - 1);
            TableDesc tblDesc = new TableDesc(LazyBinarySerDe.class, SequenceFileInputFormat.class, HiveSequenceFileOutputFormat.class, Utilities.makeProperties("serialization.format", "1", "columns", colNames.toString(), "columns.types", colTypes.toString()));
            spillTableDesc.put((byte)tag, tblDesc);
        }
        return spillTableDesc;
    }

    public static RowContainer getRowContainer(Configuration hconf, List<ObjectInspector> structFieldObjectInspectors, Byte alias, int containerSize, Map<Byte, TableDesc> spillTableDesc, JoinDesc conf, boolean noFilter, Reporter reporter) throws HiveException {
        TableDesc tblDesc = JoinUtil.getSpillTableDesc(alias, spillTableDesc, conf, noFilter);
        SerDe serde = JoinUtil.getSpillSerDe(alias, spillTableDesc, conf, noFilter);
        if (serde == null) {
            containerSize = -1;
        }
        RowContainer rc = new RowContainer(containerSize, hconf, reporter);
        StandardStructObjectInspector rcOI = null;
        if (tblDesc != null) {
            List<String> colNames = Utilities.getColumnNames(tblDesc.getProperties());
            rcOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, structFieldObjectInspectors);
        }
        rc.setSerDe(serde, rcOI);
        rc.setTableDesc(tblDesc);
        return rc;
    }
}

