/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

public class ExprNodeGenericFuncEvaluator
extends ExprNodeEvaluator {
    private static final Log LOG = LogFactory.getLog((String)ExprNodeGenericFuncEvaluator.class.getName());
    protected ExprNodeGenericFuncDesc expr;
    transient GenericUDF genericUDF;
    transient Object rowObject;
    transient ObjectInspector outputOI;
    transient ExprNodeEvaluator[] children;
    transient GenericUDF.DeferredObject[] deferredChildren;
    transient boolean isEager;

    public ExprNodeGenericFuncEvaluator(ExprNodeGenericFuncDesc expr) {
        int i;
        this.expr = expr;
        this.children = new ExprNodeEvaluator[expr.getChildExprs().size()];
        this.isEager = false;
        for (i = 0; i < this.children.length; ++i) {
            GenericUDF childUDF;
            ExprNodeEvaluator nodeEvaluator;
            ExprNodeDesc child = expr.getChildExprs().get(i);
            this.children[i] = nodeEvaluator = ExprNodeEvaluatorFactory.get(child);
            if (!(nodeEvaluator instanceof ExprNodeGenericFuncEvaluator)) continue;
            if (((ExprNodeGenericFuncEvaluator)nodeEvaluator).isEager) {
                this.isEager = true;
            }
            if (!FunctionRegistry.isStateful(childUDF = ((ExprNodeGenericFuncDesc)child).getGenericUDF())) continue;
            this.isEager = true;
        }
        this.deferredChildren = new GenericUDF.DeferredObject[expr.getChildExprs().size()];
        for (i = 0; i < this.deferredChildren.length; ++i) {
            this.deferredChildren[i] = this.isEager ? new EagerExprObject(this.children[i]) : new DeferredExprObject(this.children[i]);
        }
    }

    @Override
    public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] childrenOIs = new ObjectInspector[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            childrenOIs[i] = this.children[i].initialize(rowInspector);
        }
        this.genericUDF = this.expr.getGenericUDF();
        if (this.isEager && (this.genericUDF instanceof GenericUDFCase || this.genericUDF instanceof GenericUDFWhen)) {
            throw new HiveException("Stateful expressions cannot be used inside of CASE");
        }
        this.outputOI = this.genericUDF.initializeAndFoldConstants(childrenOIs);
        return this.outputOI;
    }

    @Override
    public boolean isDeterministic() {
        boolean result = FunctionRegistry.isDeterministic(this.genericUDF);
        for (ExprNodeEvaluator child : this.children) {
            result = result && child.isDeterministic();
        }
        return result;
    }

    @Override
    public Object evaluate(Object row) throws HiveException {
        this.rowObject = row;
        if (ObjectInspectorUtils.isConstantObjectInspector(this.outputOI) && this.isDeterministic()) {
            return ((ConstantObjectInspector)this.outputOI).getWritableConstantValue();
        }
        if (this.isEager) {
            for (int i = 0; i < this.deferredChildren.length; ++i) {
                ((EagerExprObject)this.deferredChildren[i]).evaluate();
            }
        }
        return this.genericUDF.evaluate(this.deferredChildren);
    }

    public Integer compare(Object row) throws HiveException {
        if (!this.expr.isSortedExpr() || !(this.genericUDF instanceof GenericUDFBaseCompare)) {
            for (ExprNodeEvaluator evaluator : this.children) {
                Integer comparison;
                if (!(evaluator instanceof ExprNodeGenericFuncEvaluator) || (comparison = ((ExprNodeGenericFuncEvaluator)evaluator).compare(row)) == null) continue;
                return comparison;
            }
            return null;
        }
        this.rowObject = row;
        if (this.isEager) {
            for (int i = 0; i < this.deferredChildren.length; ++i) {
                ((EagerExprObject)this.deferredChildren[i]).evaluate();
            }
        }
        return ((GenericUDFBaseCompare)this.genericUDF).compare(this.deferredChildren);
    }

    class EagerExprObject
    implements GenericUDF.DeferredObject {
        ExprNodeEvaluator eval;
        transient Object obj;

        EagerExprObject(ExprNodeEvaluator eval) {
            this.eval = eval;
        }

        void evaluate() throws HiveException {
            this.obj = this.eval.evaluate(ExprNodeGenericFuncEvaluator.this.rowObject);
        }

        @Override
        public Object get() throws HiveException {
            return this.obj;
        }
    }

    class DeferredExprObject
    implements GenericUDF.DeferredObject {
        ExprNodeEvaluator eval;

        DeferredExprObject(ExprNodeEvaluator eval) {
            this.eval = eval;
        }

        @Override
        public Object get() throws HiveException {
            return this.eval.evaluate(ExprNodeGenericFuncEvaluator.this.rowObject);
        }
    }
}

