/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.messaging;

import org.apache.hcatalog.messaging.AddPartitionMessage;
import org.apache.hcatalog.messaging.CreateDatabaseMessage;
import org.apache.hcatalog.messaging.CreateTableMessage;
import org.apache.hcatalog.messaging.DropDatabaseMessage;
import org.apache.hcatalog.messaging.DropPartitionMessage;
import org.apache.hcatalog.messaging.DropTableMessage;
import org.apache.hcatalog.messaging.HCatEventMessage;

public abstract class MessageDeserializer {
    public HCatEventMessage getHCatEventMessage(String eventTypeString, String messageBody) {
        switch (HCatEventMessage.EventType.valueOf(eventTypeString)) {
            case CREATE_DATABASE: {
                return this.getCreateDatabaseMessage(messageBody);
            }
            case DROP_DATABASE: {
                return this.getDropDatabaseMessage(messageBody);
            }
            case CREATE_TABLE: {
                return this.getCreateTableMessage(messageBody);
            }
            case DROP_TABLE: {
                return this.getDropTableMessage(messageBody);
            }
            case ADD_PARTITION: {
                return this.getAddPartitionMessage(messageBody);
            }
            case DROP_PARTITION: {
                return this.getDropPartitionMessage(messageBody);
            }
        }
        throw new IllegalArgumentException("Unsupported event-type: " + eventTypeString);
    }

    public abstract CreateDatabaseMessage getCreateDatabaseMessage(String var1);

    public abstract DropDatabaseMessage getDropDatabaseMessage(String var1);

    public abstract CreateTableMessage getCreateTableMessage(String var1);

    public abstract DropTableMessage getDropTableMessage(String var1);

    public abstract AddPartitionMessage getAddPartitionMessage(String var1);

    public abstract DropPartitionMessage getDropPartitionMessage(String var1);

    protected MessageDeserializer() {
    }
}

