/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.pig;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.data.DefaultHCatRecord;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.pig.PigHCatUtil;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.BackendException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;

abstract class HCatBaseStorer
extends StoreFunc
implements StoreMetadata {
    private static final List<HCatFieldSchema.Type> SUPPORTED_INTEGER_CONVERSIONS = Lists.newArrayList((Object[])new HCatFieldSchema.Type[]{HCatFieldSchema.Type.TINYINT, HCatFieldSchema.Type.SMALLINT, HCatFieldSchema.Type.INT});
    protected static final String COMPUTED_OUTPUT_SCHEMA = "hcat.output.schema";
    protected final List<String> partitionKeys = new ArrayList<String>();
    protected final Map<String, String> partitions = new HashMap<String, String>();
    protected Schema pigSchema;
    private RecordWriter<WritableComparable<?>, HCatRecord> writer;
    protected HCatSchema computedSchema;
    protected static final String PIG_SCHEMA = "hcat.pig.store.schema";
    protected String sign;

    public HCatBaseStorer(String partSpecs, String schema) throws Exception {
        if (partSpecs != null && !partSpecs.trim().isEmpty()) {
            String[] partKVPs;
            for (String partKVP : partKVPs = partSpecs.split(",")) {
                String[] partKV = partKVP.split("=");
                if (partKV.length != 2) {
                    throw new FrontendException("Invalid partition column specification. " + partSpecs, 1115);
                }
                String partKey = partKV[0].trim();
                this.partitionKeys.add(partKey);
                this.partitions.put(partKey, partKV[1].trim());
            }
        }
        if (schema != null) {
            this.pigSchema = Utils.getSchemaFromString((String)schema);
        }
    }

    public void checkSchema(ResourceSchema resourceSchema) throws IOException {
        Schema runtimeSchema = Schema.getPigSchema((ResourceSchema)resourceSchema);
        if (this.pigSchema != null) {
            if (!Schema.equals((Schema)runtimeSchema, (Schema)this.pigSchema, (boolean)false, (boolean)true)) {
                throw new FrontendException("Schema provided in store statement doesn't match with the Schemareturned by Pig run-time. Schema provided in HCatStorer: " + this.pigSchema.toString() + " Schema received from Pig runtime: " + runtimeSchema.toString(), 1115);
            }
        } else {
            this.pigSchema = runtimeSchema;
        }
        UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.sign}).setProperty(PIG_SCHEMA, ObjectSerializer.serialize((Serializable)this.pigSchema));
    }

    protected HCatSchema convertPigSchemaToHCatSchema(Schema pigSchema, HCatSchema tableSchema) throws FrontendException {
        ArrayList<HCatFieldSchema> fieldSchemas = new ArrayList<HCatFieldSchema>(pigSchema.size());
        for (Schema.FieldSchema fSchema : pigSchema.getFields()) {
            try {
                HCatFieldSchema hcatFieldSchema = this.getColFromSchema(fSchema.alias, tableSchema);
                fieldSchemas.add(this.getHCatFSFromPigFS(fSchema, hcatFieldSchema));
            }
            catch (HCatException he) {
                throw new FrontendException(he.getMessage(), 1115, (Throwable)he);
            }
        }
        return new HCatSchema(fieldSchemas);
    }

    public static boolean removeTupleFromBag(HCatFieldSchema hcatFieldSchema, Schema.FieldSchema bagFieldSchema) throws HCatException {
        if (hcatFieldSchema != null && hcatFieldSchema.getArrayElementSchema().get(0).getType() != HCatFieldSchema.Type.STRUCT) {
            return true;
        }
        List tupSchema = bagFieldSchema.schema.getFields();
        return hcatFieldSchema == null && tupSchema.size() == 1 && (((Schema.FieldSchema)tupSchema.get((int)0)).schema == null || ((Schema.FieldSchema)tupSchema.get((int)0)).type == 110 && ((Schema.FieldSchema)tupSchema.get((int)0)).schema.size() == 1);
    }

    private HCatFieldSchema getHCatFSFromPigFS(Schema.FieldSchema fSchema, HCatFieldSchema hcatFieldSchema) throws FrontendException, HCatException {
        byte type = fSchema.type;
        switch (type) {
            case 55: 
            case 60: {
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.STRING, null);
            }
            case 10: {
                if (hcatFieldSchema != null) {
                    if (!SUPPORTED_INTEGER_CONVERSIONS.contains(hcatFieldSchema.getType())) {
                        throw new FrontendException("Unsupported type: " + type + "  in Pig's schema", 1115);
                    }
                    return new HCatFieldSchema(fSchema.alias, hcatFieldSchema.getType(), null);
                }
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.INT, null);
            }
            case 15: {
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.BIGINT, null);
            }
            case 20: {
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.FLOAT, null);
            }
            case 25: {
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.DOUBLE, null);
            }
            case 50: {
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.BINARY, null);
            }
            case 120: {
                Schema bagSchema = fSchema.schema;
                ArrayList<HCatFieldSchema> arrFields = new ArrayList<HCatFieldSchema>(1);
                Schema.FieldSchema field = HCatBaseStorer.removeTupleFromBag(hcatFieldSchema, fSchema) ? bagSchema.getField((int)0).schema.getField(0) : bagSchema.getField(0);
                arrFields.add(this.getHCatFSFromPigFS(field, hcatFieldSchema == null ? null : hcatFieldSchema.getArrayElementSchema().get(0)));
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.ARRAY, new HCatSchema(arrFields), "");
            }
            case 110: {
                ArrayList<String> fieldNames = new ArrayList<String>();
                ArrayList<HCatFieldSchema> hcatFSs = new ArrayList<HCatFieldSchema>();
                HCatSchema structSubSchema = hcatFieldSchema == null ? null : hcatFieldSchema.getStructSubSchema();
                List fields = fSchema.schema.getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.FieldSchema fieldSchema = (Schema.FieldSchema)fields.get(i);
                    fieldNames.add(fieldSchema.alias);
                    hcatFSs.add(this.getHCatFSFromPigFS(fieldSchema, structSubSchema == null ? null : structSubSchema.get(i)));
                }
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.STRUCT, new HCatSchema(hcatFSs), "");
            }
            case 100: {
                ArrayList<HCatFieldSchema> valFSList = new ArrayList<HCatFieldSchema>(1);
                if (hcatFieldSchema != null) {
                    return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.MAP, HCatFieldSchema.Type.STRING, hcatFieldSchema.getMapValueSchema(), "");
                }
                HCatFieldSchema valFS = new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.STRING, "");
                valFSList.add(valFS);
                return new HCatFieldSchema(fSchema.alias, HCatFieldSchema.Type.MAP, HCatFieldSchema.Type.STRING, new HCatSchema(valFSList), "");
            }
        }
        throw new FrontendException("Unsupported type: " + type + "  in Pig's schema", 1115);
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
        this.computedSchema = (HCatSchema)ObjectSerializer.deserialize((String)UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.sign}).getProperty(COMPUTED_OUTPUT_SCHEMA));
    }

    public void putNext(Tuple tuple) throws IOException {
        ArrayList<Object> outgoing = new ArrayList<Object>(tuple.size());
        int i = 0;
        for (HCatFieldSchema fSchema : this.computedSchema.getFields()) {
            outgoing.add(this.getJavaObj(tuple.get(i++), fSchema));
        }
        try {
            this.writer.write(null, (Object)new DefaultHCatRecord(outgoing));
        }
        catch (InterruptedException e) {
            throw new BackendException("Error while writing tuple: " + tuple, 1115, (Throwable)e);
        }
    }

    private Object getJavaObj(Object pigObj, HCatFieldSchema hcatFS) throws HCatException, BackendException {
        try {
            HCatFieldSchema.Type type = hcatFS.getType();
            switch (type) {
                case BINARY: {
                    if (pigObj == null) {
                        return null;
                    }
                    return ((DataByteArray)pigObj).get();
                }
                case STRUCT: {
                    if (pigObj == null) {
                        return null;
                    }
                    HCatSchema structSubSchema = hcatFS.getStructSubSchema();
                    List all = ((Tuple)pigObj).getAll();
                    ArrayList<Object> converted = new ArrayList<Object>(all.size());
                    for (int i = 0; i < all.size(); ++i) {
                        converted.add(this.getJavaObj(all.get(i), structSubSchema.get(i)));
                    }
                    return converted;
                }
                case ARRAY: {
                    if (pigObj == null) {
                        return null;
                    }
                    DataBag pigBag = (DataBag)pigObj;
                    HCatFieldSchema tupFS = hcatFS.getArrayElementSchema().get(0);
                    boolean needTuple = tupFS.getType() == HCatFieldSchema.Type.STRUCT;
                    ArrayList<Object> bagContents = new ArrayList<Object>((int)pigBag.size());
                    Iterator bagItr = pigBag.iterator();
                    while (bagItr.hasNext()) {
                        bagContents.add(this.getJavaObj(needTuple ? bagItr.next() : ((Tuple)bagItr.next()).get(0), tupFS));
                    }
                    return bagContents;
                }
                case MAP: {
                    if (pigObj == null) {
                        return null;
                    }
                    Map pigMap = (Map)pigObj;
                    HashMap<String, Object> typeMap = new HashMap<String, Object>();
                    for (Map.Entry entry : pigMap.entrySet()) {
                        typeMap.put((String)entry.getKey(), this.getJavaObj(entry.getValue(), hcatFS.getMapValueSchema().get(0)));
                    }
                    return typeMap;
                }
                case STRING: 
                case INT: 
                case BIGINT: 
                case FLOAT: 
                case DOUBLE: {
                    return pigObj;
                }
                case SMALLINT: {
                    if (pigObj == null) {
                        return null;
                    }
                    if ((Integer)pigObj < Short.MIN_VALUE || (Integer)pigObj > Short.MAX_VALUE) {
                        throw new BackendException("Value " + pigObj + " is outside the bounds of column " + hcatFS.getName() + " with type " + hcatFS.getType(), 1115);
                    }
                    return ((Integer)pigObj).shortValue();
                }
                case TINYINT: {
                    if (pigObj == null) {
                        return null;
                    }
                    if ((Integer)pigObj < -128 || (Integer)pigObj > 127) {
                        throw new BackendException("Value " + pigObj + " is outside the bounds of column " + hcatFS.getName() + " with type " + hcatFS.getType(), 1115);
                    }
                    return ((Integer)pigObj).byteValue();
                }
                case BOOLEAN: {
                    throw new BackendException("Incompatible type " + type + " found in hcat table schema: " + hcatFS, 1115);
                }
            }
            throw new BackendException("Unexpected type " + type + " for value " + pigObj + (pigObj == null ? "" : " of class " + pigObj.getClass().getName()), 1115);
        }
        catch (BackendException e) {
            throw new BackendException((hcatFS.getName() == null ? " " : hcatFS.getName() + ".") + e.getMessage(), e.getCause() == null ? e : e.getCause());
        }
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.sign = signature;
    }

    protected void doSchemaValidations(Schema pigSchema, HCatSchema tblSchema) throws FrontendException, HCatException {
        for (Schema.FieldSchema pigField : pigSchema.getFields()) {
            HCatFieldSchema hcatField = this.getColFromSchema(pigField.alias, tblSchema);
            this.validateSchema(pigField, hcatField);
        }
        try {
            PigHCatUtil.validateHCatTableSchemaFollowsPigRules(tblSchema);
        }
        catch (IOException e) {
            throw new FrontendException("HCatalog schema is not compatible with Pig: " + e.getMessage(), 1115, (Throwable)e);
        }
    }

    private void validateSchema(Schema.FieldSchema pigField, HCatFieldSchema hcatField) throws HCatException, FrontendException {
        this.validateAlias(pigField.alias);
        byte type = pigField.type;
        if (DataType.isComplex((byte)type)) {
            switch (type) {
                case 100: {
                    if (hcatField == null || hcatField.getMapKeyType() == HCatFieldSchema.Type.STRING) break;
                    throw new FrontendException("Key Type of map must be String " + hcatField, 1115);
                }
                case 120: {
                    HCatSchema arrayElementSchema = hcatField == null ? null : hcatField.getArrayElementSchema();
                    for (Schema.FieldSchema innerField : pigField.schema.getField((int)0).schema.getFields()) {
                        this.validateSchema(innerField, this.getColFromSchema(pigField.alias, arrayElementSchema));
                    }
                    break;
                }
                case 110: {
                    HCatSchema structSubSchema = hcatField == null ? null : hcatField.getStructSubSchema();
                    for (Schema.FieldSchema innerField : pigField.schema.getFields()) {
                        this.validateSchema(innerField, this.getColFromSchema(pigField.alias, structSubSchema));
                    }
                    break;
                }
                default: {
                    throw new FrontendException("Internal Error.", 1115);
                }
            }
        }
    }

    private void validateAlias(String alias) throws FrontendException {
        if (alias == null) {
            throw new FrontendException("Column name for a field is not specified. Please provide the full schema as an argument to HCatStorer.", 1115);
        }
        if (alias.matches(".*[A-Z]+.*")) {
            throw new FrontendException("Column names should all be in lowercase. Invalid name found: " + alias, 1115);
        }
    }

    private HCatFieldSchema getColFromSchema(String alias, HCatSchema tblSchema) {
        if (tblSchema != null) {
            for (HCatFieldSchema hcatField : tblSchema.getFields()) {
                if (hcatField == null || hcatField.getName() == null || !hcatField.getName().equalsIgnoreCase(alias)) continue;
                return hcatField;
            }
        }
        return null;
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
    }

    public void storeStatistics(ResourceStatistics stats, String arg1, Job job) throws IOException {
    }
}

