/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.mqtt;

import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufHolder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.mqtt.MqttFixedHeader;
import org.apache.hbase.thirdparty.io.netty.handler.codec.mqtt.MqttMessage;
import org.apache.hbase.thirdparty.io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import org.apache.hbase.thirdparty.io.netty.util.IllegalReferenceCountException;

public class MqttPublishMessage
extends MqttMessage
implements ByteBufHolder {
    public MqttPublishMessage(MqttFixedHeader mqttFixedHeader, MqttPublishVariableHeader variableHeader, ByteBuf payload) {
        super(mqttFixedHeader, variableHeader, payload);
    }

    @Override
    public MqttPublishVariableHeader variableHeader() {
        return (MqttPublishVariableHeader)super.variableHeader();
    }

    @Override
    public ByteBuf payload() {
        return this.content();
    }

    @Override
    public ByteBuf content() {
        ByteBuf data = (ByteBuf)super.payload();
        if (data.refCnt() <= 0) {
            throw new IllegalReferenceCountException(data.refCnt());
        }
        return data;
    }

    @Override
    public MqttPublishMessage copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public MqttPublishMessage duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public MqttPublishMessage retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public MqttPublishMessage replace(ByteBuf content) {
        return new MqttPublishMessage(this.fixedHeader(), this.variableHeader(), content);
    }

    @Override
    public int refCnt() {
        return this.content().refCnt();
    }

    @Override
    public MqttPublishMessage retain() {
        this.content().retain();
        return this;
    }

    @Override
    public MqttPublishMessage retain(int increment) {
        this.content().retain(increment);
        return this;
    }

    @Override
    public MqttPublishMessage touch() {
        this.content().touch();
        return this;
    }

    @Override
    public MqttPublishMessage touch(Object hint) {
        this.content().touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        return this.content().release();
    }

    @Override
    public boolean release(int decrement) {
        return this.content().release(decrement);
    }
}

