/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.spark.ByteArrayComparable;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.DynamicLogicExpressionBuilder;
import org.apache.hadoop.hbase.spark.datasources.BytesEncoder;
import org.apache.hadoop.hbase.spark.datasources.JavaBytesEncoder;
import org.apache.hadoop.hbase.spark.protobuf.generated.SparkFilterProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.yetus.audience.InterfaceAudience;
import scala.collection.mutable.MutableList;

@InterfaceAudience.Private
public class SparkSQLPushDownFilter
extends FilterBase {
    protected static final Log log = LogFactory.getLog(SparkSQLPushDownFilter.class);
    DynamicLogicExpression dynamicLogicExpression;
    byte[][] valueFromQueryArray;
    HashMap<ByteArrayComparable, HashMap<ByteArrayComparable, String>> currentCellToColumnIndexMap;
    HashMap<String, ByteArrayComparable> columnToCurrentRowValueMap = null;
    static final byte[] rowKeyFamily = new byte[0];
    static final byte[] rowKeyQualifier = Bytes.toBytes((String)"key");
    String encoderClassName;

    public SparkSQLPushDownFilter(DynamicLogicExpression dynamicLogicExpression, byte[][] valueFromQueryArray, HashMap<ByteArrayComparable, HashMap<ByteArrayComparable, String>> currentCellToColumnIndexMap, String encoderClassName) {
        this.dynamicLogicExpression = dynamicLogicExpression;
        this.valueFromQueryArray = valueFromQueryArray;
        this.currentCellToColumnIndexMap = currentCellToColumnIndexMap;
        this.encoderClassName = encoderClassName;
    }

    public SparkSQLPushDownFilter(DynamicLogicExpression dynamicLogicExpression, byte[][] valueFromQueryArray, MutableList<Field> fields, String encoderClassName) {
        this.dynamicLogicExpression = dynamicLogicExpression;
        this.valueFromQueryArray = valueFromQueryArray;
        this.encoderClassName = encoderClassName;
        this.currentCellToColumnIndexMap = new HashMap();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.apply(i);
            byte[] cfBytes = field.cfBytes();
            ByteArrayComparable familyByteComparable = new ByteArrayComparable(cfBytes, 0, cfBytes.length);
            HashMap<ByteArrayComparable, String> qualifierIndexMap = this.currentCellToColumnIndexMap.get(familyByteComparable);
            if (qualifierIndexMap == null) {
                qualifierIndexMap = new HashMap();
                this.currentCellToColumnIndexMap.put(familyByteComparable, qualifierIndexMap);
            }
            byte[] qBytes = field.colBytes();
            ByteArrayComparable qualifierByteComparable = new ByteArrayComparable(qBytes, 0, qBytes.length);
            qualifierIndexMap.put(qualifierByteComparable, field.colName());
        }
    }

    public Filter.ReturnCode filterCell(Cell c) throws IOException {
        String columnName;
        ByteArrayComparable currentFamilyByteComparable;
        HashMap<ByteArrayComparable, String> qualifierColumnMap;
        if (this.columnToCurrentRowValueMap == null) {
            String rowKeyColumnName;
            this.columnToCurrentRowValueMap = new HashMap();
            HashMap<ByteArrayComparable, String> qualifierColumnMap2 = this.currentCellToColumnIndexMap.get(new ByteArrayComparable(rowKeyFamily, 0, rowKeyFamily.length));
            if (qualifierColumnMap2 != null && (rowKeyColumnName = qualifierColumnMap2.get(new ByteArrayComparable(rowKeyQualifier, 0, rowKeyQualifier.length))) != null) {
                this.columnToCurrentRowValueMap.put(rowKeyColumnName, new ByteArrayComparable(c.getRowArray(), c.getRowOffset(), c.getRowLength()));
            }
        }
        if ((qualifierColumnMap = this.currentCellToColumnIndexMap.get(currentFamilyByteComparable = new ByteArrayComparable(c.getFamilyArray(), c.getFamilyOffset(), c.getFamilyLength()))) != null && (columnName = qualifierColumnMap.get(new ByteArrayComparable(c.getQualifierArray(), c.getQualifierOffset(), c.getQualifierLength()))) != null) {
            this.columnToCurrentRowValueMap.put(columnName, new ByteArrayComparable(c.getValueArray(), c.getValueOffset(), c.getValueLength()));
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public boolean filterRow() throws IOException {
        try {
            boolean result = this.dynamicLogicExpression.execute(this.columnToCurrentRowValueMap, this.valueFromQueryArray);
            this.columnToCurrentRowValueMap = null;
            return !result;
        }
        catch (Throwable e) {
            log.error((Object)"Error running dynamic logic on row", e);
            return false;
        }
    }

    public static SparkSQLPushDownFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        SparkFilterProtos.SQLPredicatePushDownFilter proto;
        try {
            proto = SparkFilterProtos.SQLPredicatePushDownFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        String encoder = proto.getEncoderClassName();
        BytesEncoder enc = JavaBytesEncoder.create(encoder);
        DynamicLogicExpression dynamicLogicExpression = DynamicLogicExpressionBuilder.build(proto.getDynamicLogicExpression(), enc);
        List<ByteString> valueFromQueryArrayList = proto.getValueFromQueryArrayList();
        byte[][] valueFromQueryArray = new byte[valueFromQueryArrayList.size()][];
        for (int i = 0; i < valueFromQueryArrayList.size(); ++i) {
            valueFromQueryArray[i] = valueFromQueryArrayList.get(i).toByteArray();
        }
        HashMap<ByteArrayComparable, HashMap<ByteArrayComparable, String>> currentCellToColumnIndexMap = new HashMap<ByteArrayComparable, HashMap<ByteArrayComparable, String>>();
        for (SparkFilterProtos.SQLPredicatePushDownCellToColumnMapping sqlPredicatePushDownCellToColumnMapping : proto.getCellToColumnMappingList()) {
            byte[] familyArray = sqlPredicatePushDownCellToColumnMapping.getColumnFamily().toByteArray();
            ByteArrayComparable familyByteComparable = new ByteArrayComparable(familyArray, 0, familyArray.length);
            HashMap<ByteArrayComparable, String> qualifierMap = currentCellToColumnIndexMap.get(familyByteComparable);
            if (qualifierMap == null) {
                qualifierMap = new HashMap();
                currentCellToColumnIndexMap.put(familyByteComparable, qualifierMap);
            }
            byte[] qualifierArray = sqlPredicatePushDownCellToColumnMapping.getQualifier().toByteArray();
            ByteArrayComparable qualifierByteComparable = new ByteArrayComparable(qualifierArray, 0, qualifierArray.length);
            qualifierMap.put(qualifierByteComparable, sqlPredicatePushDownCellToColumnMapping.getColumnName());
        }
        return new SparkSQLPushDownFilter(dynamicLogicExpression, (byte[][])valueFromQueryArray, currentCellToColumnIndexMap, encoder);
    }

    public byte[] toByteArray() {
        SparkFilterProtos.SQLPredicatePushDownFilter.Builder builder = SparkFilterProtos.SQLPredicatePushDownFilter.newBuilder();
        SparkFilterProtos.SQLPredicatePushDownCellToColumnMapping.Builder columnMappingBuilder = SparkFilterProtos.SQLPredicatePushDownCellToColumnMapping.newBuilder();
        builder.setDynamicLogicExpression(this.dynamicLogicExpression.toExpressionString());
        for (byte[] valueFromQuery : this.valueFromQueryArray) {
            builder.addValueFromQueryArray(ByteStringer.wrap((byte[])valueFromQuery));
        }
        Object object = this.currentCellToColumnIndexMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry familyEntry = (Map.Entry)object.next();
            for (Map.Entry qualifierEntry : ((HashMap)familyEntry.getValue()).entrySet()) {
                columnMappingBuilder.setColumnFamily(ByteStringer.wrap((byte[])((ByteArrayComparable)familyEntry.getKey()).bytes()));
                columnMappingBuilder.setQualifier(ByteStringer.wrap((byte[])((ByteArrayComparable)qualifierEntry.getKey()).bytes()));
                columnMappingBuilder.setColumnName((String)qualifierEntry.getValue());
                builder.addCellToColumnMapping(columnMappingBuilder.build());
            }
        }
        builder.setEncoderClassName(this.encoderClassName);
        return builder.build().toByteArray();
    }
}

