/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.spark.DefaultSourceStaticUtils$;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.ExecutionRuleForUnitTesting;
import org.apache.hadoop.hbase.spark.RowKeyFilter;
import org.apache.hadoop.hbase.types.RawDouble;
import org.apache.hadoop.hbase.types.RawFloat;
import org.apache.hadoop.hbase.types.RawInteger;
import org.apache.hadoop.hbase.types.RawLong;
import org.apache.hadoop.hbase.types.RawString;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Predef$;
import scala.collection.immutable.StringOps;

@InterfaceAudience.Private
public final class DefaultSourceStaticUtils$ {
    public static final DefaultSourceStaticUtils$ MODULE$;
    private final RawInteger rawInteger;
    private final RawLong rawLong;
    private final RawFloat rawFloat;
    private final RawDouble rawDouble;
    private final RawString rawString;
    private final ThreadLocal<PositionedByteRange> byteRange;
    private final ConcurrentLinkedQueue<ExecutionRuleForUnitTesting> lastFiveExecutionRules;

    static {
        new DefaultSourceStaticUtils$();
    }

    public RawInteger rawInteger() {
        return this.rawInteger;
    }

    public RawLong rawLong() {
        return this.rawLong;
    }

    public RawFloat rawFloat() {
        return this.rawFloat;
    }

    public RawDouble rawDouble() {
        return this.rawDouble;
    }

    public RawString rawString() {
        return this.rawString;
    }

    public ThreadLocal<PositionedByteRange> byteRange() {
        return this.byteRange;
    }

    public PositionedByteRange getFreshByteRange(byte[] bytes) {
        return this.getFreshByteRange(bytes, 0, bytes.length);
    }

    public PositionedByteRange getFreshByteRange(byte[] bytes, int offset, int length2) {
        return this.byteRange().get().set(bytes).setLength(length2).setOffset(offset);
    }

    public int getFreshByteRange$default$2() {
        return 0;
    }

    public ConcurrentLinkedQueue<ExecutionRuleForUnitTesting> lastFiveExecutionRules() {
        return this.lastFiveExecutionRules;
    }

    public void populateLatestExecutionRules(RowKeyFilter rowKeyFilter, DynamicLogicExpression dynamicLogicExpression) {
        this.lastFiveExecutionRules().add(new ExecutionRuleForUnitTesting(rowKeyFilter, dynamicLogicExpression));
        while (this.lastFiveExecutionRules().size() > 5) {
            this.lastFiveExecutionRules().poll();
        }
    }

    public Object getValue(Field field, Result r) {
        Integer n;
        if (field.isRowKey()) {
            Object object;
            byte[] row = r.getRow();
            DataType dataType = field.dt();
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            DataType dataType2 = dataType;
            if (!(integerType$ != null ? !integerType$.equals(dataType2) : dataType2 != null)) {
                object = this.rawInteger().decode(this.getFreshByteRange(row));
            } else {
                LongType$ longType$ = LongType$.MODULE$;
                DataType dataType3 = dataType;
                if (!(longType$ != null ? !longType$.equals(dataType3) : dataType3 != null)) {
                    object = this.rawLong().decode(this.getFreshByteRange(row));
                } else {
                    FloatType$ floatType$ = FloatType$.MODULE$;
                    DataType dataType4 = dataType;
                    if (!(floatType$ != null ? !floatType$.equals(dataType4) : dataType4 != null)) {
                        object = this.rawFloat().decode(this.getFreshByteRange(row));
                    } else {
                        DoubleType$ doubleType$ = DoubleType$.MODULE$;
                        DataType dataType5 = dataType;
                        if (!(doubleType$ != null ? !doubleType$.equals(dataType5) : dataType5 != null)) {
                            object = this.rawDouble().decode(this.getFreshByteRange(row));
                        } else {
                            StringType$ stringType$ = StringType$.MODULE$;
                            DataType dataType6 = dataType;
                            if (!(stringType$ != null ? !stringType$.equals(dataType6) : dataType6 != null)) {
                                object = this.rawString().decode(this.getFreshByteRange(row));
                            } else {
                                TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                DataType dataType7 = dataType;
                                object = !(timestampType$ != null ? !timestampType$.equals(dataType7) : dataType7 != null) ? this.rawLong().decode(this.getFreshByteRange(row)) : Bytes.toString((byte[])row);
                            }
                        }
                    }
                }
            }
            n = object;
        } else {
            Cell cellByteValue = r.getColumnLatestCell(field.cfBytes(), field.colBytes());
            if (cellByteValue == null) {
                n = null;
            } else {
                Object object;
                DataType dataType = field.dt();
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                DataType dataType8 = dataType;
                if (!(integerType$ != null ? !integerType$.equals(dataType8) : dataType8 != null)) {
                    object = this.rawInteger().decode(this.getFreshByteRange(cellByteValue.getValueArray(), cellByteValue.getValueOffset(), cellByteValue.getValueLength()));
                } else {
                    LongType$ longType$ = LongType$.MODULE$;
                    DataType dataType9 = dataType;
                    if (!(longType$ != null ? !longType$.equals(dataType9) : dataType9 != null)) {
                        object = this.rawLong().decode(this.getFreshByteRange(cellByteValue.getValueArray(), cellByteValue.getValueOffset(), cellByteValue.getValueLength()));
                    } else {
                        FloatType$ floatType$ = FloatType$.MODULE$;
                        DataType dataType10 = dataType;
                        if (!(floatType$ != null ? !floatType$.equals(dataType10) : dataType10 != null)) {
                            object = this.rawFloat().decode(this.getFreshByteRange(cellByteValue.getValueArray(), cellByteValue.getValueOffset(), cellByteValue.getValueLength()));
                        } else {
                            DoubleType$ doubleType$ = DoubleType$.MODULE$;
                            DataType dataType11 = dataType;
                            if (!(doubleType$ != null ? !doubleType$.equals(dataType11) : dataType11 != null)) {
                                object = this.rawDouble().decode(this.getFreshByteRange(cellByteValue.getValueArray(), cellByteValue.getValueOffset(), cellByteValue.getValueLength()));
                            } else {
                                StringType$ stringType$ = StringType$.MODULE$;
                                DataType dataType12 = dataType;
                                if (!(stringType$ != null ? !stringType$.equals(dataType12) : dataType12 != null)) {
                                    object = Bytes.toString((byte[])cellByteValue.getValueArray(), (int)cellByteValue.getValueOffset(), (int)cellByteValue.getValueLength());
                                } else {
                                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                    DataType dataType13 = dataType;
                                    object = !(timestampType$ != null ? !timestampType$.equals(dataType13) : dataType13 != null) ? this.rawLong().decode(this.getFreshByteRange(cellByteValue.getValueArray(), cellByteValue.getValueOffset(), cellByteValue.getValueLength())) : Bytes.toString((byte[])cellByteValue.getValueArray(), (int)cellByteValue.getValueOffset(), (int)cellByteValue.getValueLength());
                                }
                            }
                        }
                    }
                }
                n = object;
            }
        }
        return n;
    }

    public byte[] getByteValue(Field field, String value) {
        byte[] byArray;
        DataType dataType = field.dt();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        DataType dataType2 = dataType;
        if (!(integerType$ != null ? !integerType$.equals(dataType2) : dataType2 != null)) {
            byte[] result = new byte[4];
            PositionedByteRange localDataRange = this.getFreshByteRange(result);
            this.rawInteger().encode(localDataRange, Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(value)).toInt()));
            byArray = localDataRange.getBytes();
        } else {
            LongType$ longType$ = LongType$.MODULE$;
            DataType dataType3 = dataType;
            if (!(longType$ != null ? !longType$.equals(dataType3) : dataType3 != null)) {
                byte[] result = new byte[8];
                PositionedByteRange localDataRange = this.getFreshByteRange(result);
                this.rawLong().encode(localDataRange, Predef$.MODULE$.long2Long(new StringOps(Predef$.MODULE$.augmentString(value)).toLong()));
                byArray = localDataRange.getBytes();
            } else {
                FloatType$ floatType$ = FloatType$.MODULE$;
                DataType dataType4 = dataType;
                if (!(floatType$ != null ? !floatType$.equals(dataType4) : dataType4 != null)) {
                    byte[] result = new byte[4];
                    PositionedByteRange localDataRange = this.getFreshByteRange(result);
                    this.rawFloat().encode(localDataRange, Predef$.MODULE$.float2Float(new StringOps(Predef$.MODULE$.augmentString(value)).toFloat()));
                    byArray = localDataRange.getBytes();
                } else {
                    DoubleType$ doubleType$ = DoubleType$.MODULE$;
                    DataType dataType5 = dataType;
                    if (!(doubleType$ != null ? !doubleType$.equals(dataType5) : dataType5 != null)) {
                        byte[] result = new byte[8];
                        PositionedByteRange localDataRange = this.getFreshByteRange(result);
                        this.rawDouble().encode(localDataRange, Predef$.MODULE$.double2Double(new StringOps(Predef$.MODULE$.augmentString(value)).toDouble()));
                        byArray = localDataRange.getBytes();
                    } else {
                        StringType$ stringType$ = StringType$.MODULE$;
                        DataType dataType6 = dataType;
                        if (!(stringType$ != null ? !stringType$.equals(dataType6) : dataType6 != null)) {
                            byArray = Bytes.toBytes((String)value);
                        } else {
                            TimestampType$ timestampType$ = TimestampType$.MODULE$;
                            DataType dataType7 = dataType;
                            if (!(timestampType$ != null ? !timestampType$.equals(dataType7) : dataType7 != null)) {
                                byte[] result = new byte[8];
                                PositionedByteRange localDataRange = this.getFreshByteRange(result);
                                this.rawLong().encode(localDataRange, Predef$.MODULE$.long2Long(new StringOps(Predef$.MODULE$.augmentString(value)).toLong()));
                                byArray = localDataRange.getBytes();
                            } else {
                                byArray = Bytes.toBytes((String)value);
                            }
                        }
                    }
                }
            }
        }
        return byArray;
    }

    private DefaultSourceStaticUtils$() {
        MODULE$ = this;
        this.rawInteger = new RawInteger();
        this.rawLong = new RawLong();
        this.rawFloat = new RawFloat();
        this.rawDouble = new RawDouble();
        this.rawString = RawString.ASCENDING;
        this.byteRange = new anon.1();
        this.lastFiveExecutionRules = new ConcurrentLinkedQueue();
    }
}

