/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.DNSToSwitchMappingWithDependency;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.ScriptBasedMapping;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ScriptBasedMappingWithDependency
extends ScriptBasedMapping
implements DNSToSwitchMappingWithDependency {
    static final String DEPENDENCY_SCRIPT_FILENAME_KEY = "org.apache.hadoop.hbase.shaded.net.topology.dependency.script.file.name";
    private Map<String, List<String>> dependencyCache = new ConcurrentHashMap<String, List<String>>();

    public ScriptBasedMappingWithDependency() {
        super(new RawScriptBasedMappingWithDependency());
    }

    private RawScriptBasedMappingWithDependency getRawMapping() {
        return (RawScriptBasedMappingWithDependency)this.rawMapping;
    }

    @Override
    public String toString() {
        return "script-based mapping with " + this.getRawMapping().toString();
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.getRawMapping().setConf(conf);
    }

    @Override
    public List<String> getDependency(String name) {
        if ((name = NetUtils.normalizeHostName(name)) == null) {
            return Collections.emptyList();
        }
        List<String> dependencies = this.dependencyCache.get(name);
        if (dependencies == null && (dependencies = this.getRawMapping().getDependency(name)) != null) {
            this.dependencyCache.put(name, dependencies);
        }
        return dependencies;
    }

    private static final class RawScriptBasedMappingWithDependency
    extends ScriptBasedMapping.RawScriptBasedMapping
    implements DNSToSwitchMappingWithDependency {
        private String dependencyScriptName;

        @Override
        public void setConf(Configuration conf) {
            super.setConf(conf);
            this.dependencyScriptName = conf != null ? conf.get(ScriptBasedMappingWithDependency.DEPENDENCY_SCRIPT_FILENAME_KEY) : null;
        }

        @Override
        public List<String> getDependency(String name) {
            if (name == null || this.dependencyScriptName == null) {
                return Collections.emptyList();
            }
            LinkedList<String> m = new LinkedList<String>();
            ArrayList<String> args = new ArrayList<String>(1);
            args.add(name);
            String output = this.runResolveCommand(args, this.dependencyScriptName);
            if (output != null) {
                StringTokenizer allSwitchInfo = new StringTokenizer(output);
                while (allSwitchInfo.hasMoreTokens()) {
                    String switchInfo = allSwitchInfo.nextToken();
                    m.add(switchInfo);
                }
            } else {
                return null;
            }
            return m;
        }

        @Override
        public String toString() {
            return "dependency script " + this.dependencyScriptName;
        }
    }
}

