/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.curator.connection;

import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.shaded.org.apache.curator.CuratorZookeeperClient;
import org.apache.hadoop.hbase.shaded.org.apache.curator.RetryLoop;
import org.apache.hadoop.hbase.shaded.org.apache.curator.connection.ConnectionHandlingPolicy;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.org.apache.curator.utils.ThreadUtils;

public class StandardConnectionHandlingPolicy
implements ConnectionHandlingPolicy {
    private final int expirationPercent;

    public StandardConnectionHandlingPolicy() {
        this(100);
    }

    public StandardConnectionHandlingPolicy(int expirationPercent) {
        Preconditions.checkArgument(expirationPercent > 0 && expirationPercent <= 100, "expirationPercent must be > 0 and <= 100");
        this.expirationPercent = expirationPercent;
    }

    @Override
    public int getSimulatedSessionExpirationPercent() {
        return this.expirationPercent;
    }

    @Override
    public <T> T callWithRetry(CuratorZookeeperClient client, Callable<T> proc) throws Exception {
        client.internalBlockUntilConnectedOrTimedOut();
        T result = null;
        RetryLoop retryLoop = client.newRetryLoop();
        while (retryLoop.shouldContinue()) {
            try {
                result = proc.call();
                retryLoop.markComplete();
            }
            catch (Exception e) {
                ThreadUtils.checkInterrupted(e);
                retryLoop.takeException(e);
            }
        }
        return result;
    }

    @Override
    public ConnectionHandlingPolicy.CheckTimeoutsResult checkTimeouts(Callable<String> hasNewConnectionString, long connectionStartMs, int sessionTimeoutMs, int connectionTimeoutMs) throws Exception {
        if (hasNewConnectionString.call() != null) {
            return ConnectionHandlingPolicy.CheckTimeoutsResult.NEW_CONNECTION_STRING;
        }
        return ConnectionHandlingPolicy.CheckTimeoutsResult.NOP;
    }
}

