/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto;

import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.CriticalHeaderParamsAware;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWEDecrypter;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.KeyLengthException;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.ContentCryptoProvider;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.CriticalHeaderParamsDeferral;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.DirectCryptoProvider;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.OctetSequenceKey;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.hbase.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DirectDecrypter
extends DirectCryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public DirectDecrypter(SecretKey key) throws KeyLengthException {
        super(key);
    }

    public DirectDecrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public DirectDecrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    public DirectDecrypter(SecretKey key, Set<String> defCritHeaders) throws KeyLengthException {
        super(key);
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        if (encryptedKey != null) {
            throw new JOSEException("Unexpected present JWE encrypted key");
        }
        if (iv == null) {
            throw new JOSEException("Unexpected present JWE initialization vector (IV)");
        }
        if (authTag == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        JWEAlgorithm alg = header.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        this.critPolicy.ensureHeaderPasses(header);
        return ContentCryptoProvider.decrypt(header, null, iv, cipherText, authTag, this.getKey(), this.getJCAContext());
    }
}

