/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hbase.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hbase.thirdparty.com.google.common.base.Objects;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MetricsInfoImpl
implements MetricsInfo {
    private final String name;
    private final String description;

    MetricsInfoImpl(String name, String description) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.description = Preconditions.checkNotNull(description, "description");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetricsInfo) {
            MetricsInfo other = (MetricsInfo)obj;
            return Objects.equal(this.name, other.name()) && Objects.equal(this.description, other.description());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.description);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("description", this.description).toString();
    }
}

