/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.CipherProvider;
import org.apache.hadoop.hbase.io.crypto.aes.CommonsCryptoAES;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class CryptoCipherProvider
implements CipherProvider {
    private static CryptoCipherProvider instance;
    private Configuration conf = HBaseConfiguration.create();

    @SuppressWarnings(value={"MS_EXPOSE_REP"}, justification="singleton pattern")
    public static CryptoCipherProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new CryptoCipherProvider();
        return instance;
    }

    private CryptoCipherProvider() {
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public String getName() {
        return "commons";
    }

    @Override
    public Cipher getCipher(String name) {
        if (name.equalsIgnoreCase("AES")) {
            return new CommonsCryptoAES(this);
        }
        throw new RuntimeException("Cipher '" + name + "' is not supported by provider '" + this.getName() + "'");
    }

    @Override
    public String[] getSupportedCiphers() {
        return new String[]{"AES"};
    }
}

