/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CustomCellTieredUtils {
    private CustomCellTieredUtils() {
    }

    public static void checkForModifyTable(TableDescriptor newTable) throws IOException {
        for (ColumnFamilyDescriptor descriptor : newTable.getColumnFamilies()) {
            String storeEngineClassName = descriptor.getConfigurationValue(StoreEngine.STORE_ENGINE_CLASS_KEY);
            if (storeEngineClassName == null || !storeEngineClassName.contains("CustomCellTieredStoreEngine") || descriptor.getConfigurationValue("TIERING_CELL_QUALIFIER") != null) continue;
            throw new DoNotRetryIOException("StoreEngine " + storeEngineClassName + " is missing required " + "TIERING_CELL_QUALIFIER" + " parameter.");
        }
    }
}

