/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractCloseTableRegionsProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CloseExcessRegionReplicasProcedure
extends AbstractCloseTableRegionsProcedure<MasterProcedureProtos.CloseExcessRegionReplicasProcedureState> {
    private int newReplicaCount;

    public CloseExcessRegionReplicasProcedure() {
    }

    public CloseExcessRegionReplicasProcedure(TableName tableName, int newReplicaCount) {
        super(tableName);
        this.newReplicaCount = newReplicaCount;
    }

    protected MasterProcedureProtos.CloseExcessRegionReplicasProcedureState getState(int stateId) {
        return MasterProcedureProtos.CloseExcessRegionReplicasProcedureState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.CloseExcessRegionReplicasProcedureState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.CloseExcessRegionReplicasProcedureState getInitialState() {
        return MasterProcedureProtos.CloseExcessRegionReplicasProcedureState.CLOSE_EXCESS_REGION_REPLICAS_SCHEDULE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.CloseExcessRegionReplicasProcedureStateData data = MasterProcedureProtos.CloseExcessRegionReplicasProcedureStateData.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName)).setNewReplicaCount(this.newReplicaCount).build();
        serializer.serialize((Message)data);
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.CloseExcessRegionReplicasProcedureStateData data = (MasterProcedureProtos.CloseExcessRegionReplicasProcedureStateData)serializer.deserialize(MasterProcedureProtos.CloseExcessRegionReplicasProcedureStateData.class);
        this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)data.getTableName());
        this.newReplicaCount = data.getNewReplicaCount();
    }

    @Override
    protected MasterProcedureProtos.CloseExcessRegionReplicasProcedureState getConfirmState() {
        return MasterProcedureProtos.CloseExcessRegionReplicasProcedureState.CLOSE_EXCESS_REGION_REPLICAS_CONFIRM;
    }

    @Override
    protected int submitUnassignProcedure(MasterProcedureEnv env, Consumer<TransitRegionStateProcedure> submit) {
        return env.getAssignmentManager().submitUnassignProcedureForClosingExcessRegionReplicas(this.tableName, this.newReplicaCount, submit);
    }

    @Override
    protected int numberOfUnclosedRegions(MasterProcedureEnv env) {
        return env.getAssignmentManager().numberOfUnclosedExcessRegionReplicas(this.tableName, this.newReplicaCount);
    }
}

