/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.Size;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class BalancerRegionLoad {
    private final long readRequestsCount;
    private final long writeRequestsCount;
    private final int memStoreSizeMB;
    private final int storefileSizeMB;
    private final int regionSizeMB;
    private final float currentRegionPrefetchRatio;

    BalancerRegionLoad(RegionMetrics regionMetrics) {
        this.readRequestsCount = regionMetrics.getReadRequestCount();
        this.writeRequestsCount = regionMetrics.getWriteRequestCount();
        this.memStoreSizeMB = (int)regionMetrics.getMemStoreSize().get(Size.Unit.MEGABYTE);
        this.storefileSizeMB = (int)regionMetrics.getStoreFileSize().get(Size.Unit.MEGABYTE);
        this.regionSizeMB = (int)regionMetrics.getRegionSizeMB().get(Size.Unit.MEGABYTE);
        this.currentRegionPrefetchRatio = regionMetrics.getCurrentRegionCachedRatio();
    }

    public long getReadRequestsCount() {
        return this.readRequestsCount;
    }

    public long getWriteRequestsCount() {
        return this.writeRequestsCount;
    }

    public int getMemStoreSizeMB() {
        return this.memStoreSizeMB;
    }

    public int getStorefileSizeMB() {
        return this.storefileSizeMB;
    }

    public int getRegionSizeMB() {
        return this.regionSizeMB;
    }

    public float getCurrentRegionCacheRatio() {
        return this.currentRegionPrefetchRatio;
    }
}

