/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StorefileRefresherChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(StorefileRefresherChore.class);
    public static final String REGIONSERVER_STOREFILE_REFRESH_PERIOD = "hbase.regionserver.storefile.refresh.period";
    static final int DEFAULT_REGIONSERVER_STOREFILE_REFRESH_PERIOD = 0;
    public static final String REGIONSERVER_META_STOREFILE_REFRESH_PERIOD = "hbase.regionserver.meta.storefile.refresh.period";
    private HRegionServer regionServer;
    private long hfileTtl;
    private int period;
    private boolean onlyMetaRefresh = true;
    private Map<String, Long> lastRefreshTimes;

    public StorefileRefresherChore(int period, boolean onlyMetaRefresh, HRegionServer regionServer, Stoppable stoppable) {
        super("StorefileRefresherChore", stoppable, period);
        this.period = period;
        this.regionServer = regionServer;
        this.hfileTtl = this.regionServer.getConfiguration().getLong("hbase.master.hfilecleaner.ttl", 300000L);
        this.onlyMetaRefresh = onlyMetaRefresh;
        if ((long)period > this.hfileTtl / 2L) {
            throw new RuntimeException("hbase.regionserver.storefile.refresh.period should be set smaller than half of hbase.master.hfilecleaner.ttl");
        }
        this.lastRefreshTimes = new HashMap<String, Long>();
    }

    protected void chore() {
        for (Region region : this.regionServer.getOnlineRegionsLocalContext()) {
            if (!region.isReadOnly() || this.onlyMetaRefresh && !region.getRegionInfo().isMetaRegion()) continue;
            String encodedName = region.getRegionInfo().getEncodedName();
            long time = EnvironmentEdgeManager.currentTime();
            if (!this.lastRefreshTimes.containsKey(encodedName)) {
                this.lastRefreshTimes.put(encodedName, time);
            }
            try {
                for (Store store : region.getStores()) {
                    store.refreshStoreFiles();
                }
            }
            catch (IOException ex) {
                LOG.warn("Exception while trying to refresh store files for region:" + region.getRegionInfo() + ", exception:" + StringUtils.stringifyException((Throwable)ex));
                if (!this.isRegionStale(encodedName, time)) continue;
                ((HRegion)region).setReadsEnabled(false);
                continue;
            }
            this.lastRefreshTimes.put(encodedName, time);
            ((HRegion)region).setReadsEnabled(true);
        }
        Iterator<String> lastRefreshTimesIter = this.lastRefreshTimes.keySet().iterator();
        while (lastRefreshTimesIter.hasNext()) {
            String string = lastRefreshTimesIter.next();
            if (this.regionServer.getRegion(string) != null) continue;
            lastRefreshTimesIter.remove();
        }
    }

    protected boolean isRegionStale(String encodedName, long time) {
        long lastRefreshTime = this.lastRefreshTimes.get(encodedName);
        return time - lastRefreshTime > this.hfileTtl - (long)this.period;
    }
}

