/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TestProtobufRpcServiceImpl
implements TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface {
    public static final BlockingService SERVICE = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService((TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface)new TestProtobufRpcServiceImpl());

    public static TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface newBlockingStub(RpcClient client, InetSocketAddress addr) throws IOException {
        return TestProtobufRpcServiceImpl.newBlockingStub(client, addr, User.getCurrent());
    }

    public static TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface newBlockingStub(RpcClient client, InetSocketAddress addr, User user) throws IOException {
        return TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub((BlockingRpcChannel)client.createBlockingRpcChannel(ServerName.valueOf((String)addr.getHostName(), (int)addr.getPort(), (long)EnvironmentEdgeManager.currentTime()), user, 0));
    }

    public static TestRpcServiceProtos.TestProtobufRpcProto.Interface newStub(RpcClient client, InetSocketAddress addr) throws IOException {
        return TestRpcServiceProtos.TestProtobufRpcProto.newStub((RpcChannel)client.createRpcChannel(ServerName.valueOf((String)addr.getHostName(), (int)addr.getPort(), (long)EnvironmentEdgeManager.currentTime()), User.getCurrent(), 0));
    }

    public TestProtos.EmptyResponseProto ping(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
        return TestProtos.EmptyResponseProto.getDefaultInstance();
    }

    public TestProtos.EchoResponseProto echo(RpcController controller, TestProtos.EchoRequestProto request) throws ServiceException {
        if (controller instanceof HBaseRpcController) {
            HBaseRpcController pcrc = (HBaseRpcController)controller;
            CellScanner cellScanner = pcrc.cellScanner();
            ArrayList<Cell> list = null;
            if (cellScanner != null) {
                list = new ArrayList<Cell>();
                try {
                    while (cellScanner.advance()) {
                        list.add(cellScanner.current());
                    }
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            cellScanner = CellUtil.createCellScanner(list);
            pcrc.setCellScanner(cellScanner);
        }
        return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
    }

    public TestProtos.EmptyResponseProto error(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("server error!"));
    }

    public TestProtos.EmptyResponseProto pause(RpcController controller, TestProtos.PauseRequestProto request) throws ServiceException {
        Threads.sleepWithoutInterrupt((long)request.getMs());
        return TestProtos.EmptyResponseProto.getDefaultInstance();
    }

    public TestProtos.AddrResponseProto addr(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
        return TestProtos.AddrResponseProto.newBuilder().setAddr(((InetAddress)RpcServer.getRemoteAddress().get()).getHostAddress()).build();
    }
}

