/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hadoop.hbase.io.hfile.bucket.CacheFullException;
import org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={IOTests.class, SmallTests.class})
public class TestBucketWriterThread {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBucketWriterThread.class);
    private BucketCache bc;
    private BucketCache.WriterThread wt;
    private BlockingQueue<BucketCache.RAMQueueEntry> q;
    private Cacheable plainCacheable;
    private BlockCacheKey plainKey;

    @Before
    public void setUp() throws Exception {
        int capacity = 16;
        boolean writerThreadsCount = true;
        this.bc = new MockBucketCache("offheap", 16L, 1, new int[]{1}, 1, 16, null, 100);
        Assert.assertEquals((long)1L, (long)this.bc.writerThreads.length);
        Assert.assertEquals((long)1L, (long)this.bc.writerQueues.size());
        this.wt = this.bc.writerThreads[0];
        this.q = (BlockingQueue)this.bc.writerQueues.get(0);
        this.wt.disableWriter();
        this.plainKey = new BlockCacheKey("f", 0L);
        this.plainCacheable = (Cacheable)Mockito.mock(Cacheable.class);
        MatcherAssert.assertThat((Object)this.bc.ramCache.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertTrue((boolean)this.q.isEmpty());
    }

    @After
    public void tearDown() throws Exception {
        if (this.bc != null) {
            this.bc.shutdown();
        }
    }

    @Test
    public void testNonErrorCase() throws IOException, InterruptedException {
        this.bc.cacheBlock(this.plainKey, this.plainCacheable);
        TestBucketWriterThread.doDrainOfOneEntry(this.bc, this.wt, this.q);
    }

    @Test
    public void testTooBigEntry() throws InterruptedException {
        Cacheable tooBigCacheable = (Cacheable)Mockito.mock(Cacheable.class);
        Mockito.when((Object)tooBigCacheable.getSerializedLength()).thenReturn((Object)Integer.MAX_VALUE);
        this.bc.cacheBlock(this.plainKey, tooBigCacheable);
        TestBucketWriterThread.doDrainOfOneEntry(this.bc, this.wt, this.q);
    }

    @Test
    public void testIOE() throws IOException, InterruptedException {
        this.bc.cacheBlock(this.plainKey, this.plainCacheable);
        BucketCache.RAMQueueEntry rqe = (BucketCache.RAMQueueEntry)this.q.remove();
        BucketCache.RAMQueueEntry spiedRqe = (BucketCache.RAMQueueEntry)Mockito.spy((Object)rqe);
        ((BucketCache.RAMQueueEntry)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Mocked!")}).when((Object)spiedRqe)).writeToCache((IOEngine)Mockito.any(), (BucketAllocator)Mockito.any(), (LongAdder)Mockito.any(), (Function)Mockito.any(), (ByteBuffer)Mockito.any());
        this.q.add(spiedRqe);
        TestBucketWriterThread.doDrainOfOneEntry(this.bc, this.wt, this.q);
        Assert.assertTrue((!this.bc.isCacheEnabled() ? 1 : 0) != 0);
    }

    @Test
    public void testCacheFullException() throws IOException, InterruptedException {
        this.bc.cacheBlock(this.plainKey, this.plainCacheable);
        BucketCache.RAMQueueEntry rqe = (BucketCache.RAMQueueEntry)this.q.remove();
        BucketCache.RAMQueueEntry spiedRqe = (BucketCache.RAMQueueEntry)Mockito.spy((Object)rqe);
        CacheFullException cfe = new CacheFullException(0, 0);
        BucketEntry mockedBucketEntry = (BucketEntry)Mockito.mock(BucketEntry.class);
        ((BucketCache.RAMQueueEntry)Mockito.doThrow((Throwable[])new Throwable[]{cfe}).doReturn((Object)mockedBucketEntry).when((Object)spiedRqe)).writeToCache((IOEngine)Mockito.any(), (BucketAllocator)Mockito.any(), (LongAdder)Mockito.any(), (Function)Mockito.any(), (ByteBuffer)Mockito.any());
        this.q.add(spiedRqe);
        TestBucketWriterThread.doDrainOfOneEntry(this.bc, this.wt, this.q);
    }

    private static void doDrainOfOneEntry(BucketCache bc, BucketCache.WriterThread wt, BlockingQueue<BucketCache.RAMQueueEntry> q) throws InterruptedException {
        List rqes = BucketCache.getRAMQueueEntries(q, new ArrayList(1));
        bc.doDrain(rqes, ByteBuffer.allocate(13));
        Assert.assertTrue((boolean)q.isEmpty());
        Assert.assertTrue((boolean)bc.ramCache.isEmpty());
        Assert.assertEquals((long)0L, (long)bc.heapSize());
    }

    private static class MockBucketCache
    extends BucketCache {
        public MockBucketCache(String ioEngineName, long capacity, int blockSize, int[] bucketSizes, int writerThreadNum, int writerQLen, String persistencePath, int ioErrorsTolerationDuration) throws IOException {
            super(ioEngineName, capacity, blockSize, bucketSizes, writerThreadNum, writerQLen, persistencePath, ioErrorsTolerationDuration, HBaseConfiguration.create());
        }

        protected void startWriterThreads() {
        }
    }
}

