/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ReplicationSinkService;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationLoad;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSink;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationSinkServiceImpl
implements ReplicationSinkService {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSinkServiceImpl.class);
    private Configuration conf;
    private Server server;
    private ReplicationSink replicationSink;
    private ReplicationLoad replicationLoad;
    private int statsPeriodInSecond;

    @Override
    public void replicateLogEntries(List<AdminProtos.WALEntry> entries, CellScanner cells, String replicationClusterId, String sourceBaseNamespaceDirPath, String sourceHFileArchiveDirPath) throws IOException {
        this.replicationSink.replicateEntries(entries, cells, replicationClusterId, sourceBaseNamespaceDirPath, sourceHFileArchiveDirPath);
    }

    @Override
    public void initialize(Server server, FileSystem fs, Path logdir, Path oldLogDir, WALFactory walFactory) throws IOException {
        this.server = server;
        this.conf = server.getConfiguration();
        this.statsPeriodInSecond = this.conf.getInt("replication.stats.thread.period.seconds", 300);
        this.replicationLoad = new ReplicationLoad();
    }

    @Override
    public void startReplicationService() throws IOException {
        RegionServerCoprocessorHost rsServerHost = null;
        if (this.server instanceof HRegionServer) {
            rsServerHost = ((HRegionServer)this.server).getRegionServerCoprocessorHost();
        }
        this.replicationSink = new ReplicationSink(this.conf, rsServerHost);
        this.server.getChoreService().scheduleChore((ScheduledChore)new ReplicationStatisticsChore("ReplicationSinkStatistics", this.server, (int)TimeUnit.SECONDS.toMillis(this.statsPeriodInSecond)));
    }

    @Override
    public void stopReplicationService() {
        if (this.replicationSink != null) {
            this.replicationSink.stopReplicationSinkServices();
        }
    }

    @Override
    public ReplicationLoad refreshAndGetReplicationLoad() {
        if (this.replicationLoad == null) {
            return null;
        }
        this.replicationLoad.buildReplicationLoad(Collections.emptyList(), this.replicationSink.getSinkMetrics());
        return this.replicationLoad;
    }

    private final class ReplicationStatisticsChore
    extends ScheduledChore {
        ReplicationStatisticsChore(String name, Stoppable stopper, int period) {
            super(name, stopper, period);
        }

        protected void chore() {
            this.printStats(ReplicationSinkServiceImpl.this.replicationSink.getStats());
        }

        private void printStats(String stats) {
            if (!stats.isEmpty()) {
                LOG.info(stats);
            }
        }
    }
}

