/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.concurrent.ThreadLocalRandom;
import org.agrona.collections.Int2IntCounterMap;
import org.agrona.collections.IntArrayList;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.RandomCandidateGenerator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionReplicaCandidateGenerator
extends CandidateGenerator {
    protected final RandomCandidateGenerator randomGenerator = new RandomCandidateGenerator();

    RegionReplicaCandidateGenerator() {
    }

    int selectCoHostedRegionPerGroup(Int2IntCounterMap colocatedReplicaCountsPerGroup, int[] regionsPerGroup, int[] regionIndexToPrimaryIndex) {
        IntArrayList colocated = new IntArrayList(colocatedReplicaCountsPerGroup.size(), -1);
        colocatedReplicaCountsPerGroup.forEach((primary, count) -> {
            if (count > 1) {
                colocated.add(Integer.valueOf(primary));
            }
        });
        if (!colocated.isEmpty()) {
            int rand = ThreadLocalRandom.current().nextInt(colocated.size());
            int selectedPrimaryIndex = colocated.get(rand);
            for (int regionIndex : regionsPerGroup) {
                if (selectedPrimaryIndex != regionIndexToPrimaryIndex[regionIndex] || selectedPrimaryIndex == regionIndex) continue;
                return regionIndex;
            }
        }
        return -1;
    }

    @Override
    BalanceAction generate(BalancerClusterState cluster) {
        int serverIndex = this.pickRandomServer(cluster);
        if (cluster.numServers <= 1 || serverIndex == -1) {
            return BalanceAction.NULL_ACTION;
        }
        int regionIndex = this.selectCoHostedRegionPerGroup(cluster.colocatedReplicaCountsPerServer[serverIndex], cluster.regionsPerServer[serverIndex], cluster.regionIndexToPrimaryIndex);
        if (regionIndex == -1) {
            return this.randomGenerator.generate(cluster);
        }
        int toServerIndex = this.pickOtherRandomServer(cluster, serverIndex);
        int toRegionIndex = this.pickRandomRegion(cluster, toServerIndex, 0.9f);
        return this.getAction(serverIndex, regionIndex, toServerIndex, toRegionIndex);
    }
}

