/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionServerList;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestUnknownServers {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestUnknownServers.class);
    private static HBaseTestingUtility UTIL;
    private static Admin ADMIN;
    private static final int SLAVES = 2;
    private static boolean IS_UNKNOWN_SERVER;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL = new HBaseTestingUtility();
        UTIL.getConfiguration().setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        UTIL.startMiniCluster(2);
        ADMIN = UTIL.getAdmin();
    }

    @Test
    public void testListUnknownServers() throws Exception {
        Assert.assertEquals((long)ADMIN.listUnknownServers().size(), (long)2L);
        IS_UNKNOWN_SERVER = false;
        Assert.assertEquals((long)ADMIN.listUnknownServers().size(), (long)0L);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (ADMIN != null) {
            ADMIN.close();
        }
        if (UTIL != null) {
            UTIL.shutdownMiniCluster();
        }
    }

    static {
        IS_UNKNOWN_SERVER = true;
    }

    private static final class ServerManagerForTest
    extends ServerManager {
        public ServerManagerForTest(MasterServices master, RegionServerList storage) {
            super(master, storage);
        }

        public boolean isServerUnknown(ServerName serverName) {
            return IS_UNKNOWN_SERVER;
        }
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected ServerManager createServerManager(MasterServices master, RegionServerList storage) throws IOException {
            this.setupClusterConnection();
            return new ServerManagerForTest(master, storage);
        }
    }
}

