/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.regionserver.wal.AsyncProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.ReaderBase;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.Parser;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix", "Configuration"})
public class ProtobufLogReader
extends ReaderBase {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufLogReader.class);
    @InterfaceAudience.Private
    public static final byte[] PB_WAL_MAGIC = Bytes.toBytes((String)"PWAL");
    @InterfaceAudience.Private
    public static final byte[] PB_WAL_COMPLETE_MAGIC = Bytes.toBytes((String)"LAWP");
    static final String WAL_TRAILER_WARN_SIZE = "hbase.regionserver.waltrailer.warn.size";
    static final int DEFAULT_WAL_TRAILER_WARN_SIZE = 0x100000;
    protected FSDataInputStream inputStream;
    protected Codec.Decoder cellDecoder;
    protected WALCellCodec.ByteStringUncompressor byteStringUncompressor;
    protected boolean hasCompression = false;
    protected boolean hasTagCompression = false;
    private long walEditsStopOffset;
    private boolean trailerPresent;
    protected WALProtos.WALTrailer trailer;
    protected int trailerWarnSize;
    private static List<String> writerClsNames = new ArrayList<String>();
    private String codecClsName = null;
    private boolean resetCompression;

    @InterfaceAudience.Private
    public long trailerSize() {
        if (this.trailerPresent) {
            long expectedSize = this.fileLength - this.walEditsStopOffset;
            long calculatedSize = (long)PB_WAL_COMPLETE_MAGIC.length + 4L + (long)this.trailer.getSerializedSize();
            if (expectedSize != calculatedSize) {
                LOG.warn("After parsing the trailer, we expect the total footer to be {} bytes, but we calculate it as being {}", (Object)expectedSize, (Object)calculatedSize);
            }
            return expectedSize;
        }
        return -1L;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    @Override
    public long getPosition() throws IOException {
        return this.inputStream.getPos();
    }

    @Override
    public void reset() throws IOException {
        String clsName = this.initInternal(null, false);
        if (this.resetCompression) {
            this.resetCompression();
        }
        this.initAfterCompression(clsName);
    }

    @Override
    public void init(FileSystem fs, Path path, Configuration conf, FSDataInputStream stream) throws IOException {
        this.trailerWarnSize = conf.getInt(WAL_TRAILER_WARN_SIZE, 0x100000);
        super.init(fs, path, conf, stream);
    }

    @Override
    protected String initReader(FSDataInputStream stream) throws IOException {
        return this.initInternal(stream, true);
    }

    public List<String> getWriterClsNames() {
        return writerClsNames;
    }

    public String getCodecClsName() {
        return this.codecClsName;
    }

    protected WALHdrContext readHeader(WALProtos.WALHeader.Builder builder, FSDataInputStream stream) throws IOException {
        boolean res = builder.mergeDelimitedFrom((InputStream)stream);
        if (!res) {
            return new WALHdrContext(WALHdrResult.EOF, null);
        }
        if (builder.hasWriterClsName() && !this.getWriterClsNames().contains(builder.getWriterClsName())) {
            return new WALHdrContext(WALHdrResult.UNKNOWN_WRITER_CLS, null);
        }
        String clsName = null;
        if (builder.hasCellCodecClsName()) {
            clsName = builder.getCellCodecClsName();
        }
        return new WALHdrContext(WALHdrResult.SUCCESS, clsName);
    }

    private String initInternal(FSDataInputStream stream, boolean isFirst) throws IOException {
        this.close();
        if (!isFirst) {
            this.fileLength = this.fs.getFileStatus(this.path).getLen();
        }
        long expectedPos = PB_WAL_MAGIC.length;
        if (stream == null) {
            stream = this.fs.open(this.path);
            stream.seek(expectedPos);
        }
        if (stream.getPos() != expectedPos) {
            throw new IOException("The stream is at invalid position: " + stream.getPos());
        }
        WALProtos.WALHeader.Builder builder = WALProtos.WALHeader.newBuilder();
        WALHdrContext hdrCtxt = this.readHeader(builder, stream);
        WALHdrResult walHdrRes = hdrCtxt.getResult();
        if (walHdrRes == WALHdrResult.EOF) {
            throw new EOFException("Couldn't read WAL PB header");
        }
        if (walHdrRes == WALHdrResult.UNKNOWN_WRITER_CLS) {
            throw new IOException("Got unknown writer class: " + builder.getWriterClsName());
        }
        if (isFirst) {
            WALProtos.WALHeader header = builder.build();
            this.hasCompression = header.hasHasCompression() && header.getHasCompression();
            this.hasTagCompression = header.hasHasTagCompression() && header.getHasTagCompression();
        }
        this.inputStream = stream;
        this.walEditsStopOffset = this.fileLength;
        long currentPosition = stream.getPos();
        this.trailerPresent = this.setTrailerIfPresent();
        this.seekOnFs(currentPosition);
        if (LOG.isTraceEnabled()) {
            LOG.trace("After reading the trailer: walEditsStopOffset: " + this.walEditsStopOffset + ", fileLength: " + this.fileLength + ", trailerPresent: " + (this.trailerPresent ? "true, size: " + this.trailer.getSerializedSize() : "false") + ", currentPosition: " + currentPosition);
        }
        this.codecClsName = hdrCtxt.getCellCodecClsName();
        return hdrCtxt.getCellCodecClsName();
    }

    private boolean setTrailerIfPresent() {
        try {
            long trailerSizeOffset = this.fileLength - (long)(PB_WAL_COMPLETE_MAGIC.length + 4);
            if (trailerSizeOffset <= 0L) {
                return false;
            }
            this.seekOnFs(trailerSizeOffset);
            int trailerSize = this.inputStream.readInt();
            ByteBuffer buf = ByteBuffer.allocate(PB_WAL_COMPLETE_MAGIC.length);
            this.inputStream.readFully(buf.array(), buf.arrayOffset(), buf.capacity());
            if (!Arrays.equals(buf.array(), PB_WAL_COMPLETE_MAGIC)) {
                LOG.trace("No trailer found.");
                return false;
            }
            if (trailerSize < 0) {
                LOG.warn("Invalid trailer Size " + trailerSize + ", ignoring the trailer");
                return false;
            }
            if (trailerSize > this.trailerWarnSize) {
                LOG.warn("Please investigate WALTrailer usage. Trailer size > maximum configured size : " + trailerSize + " > " + this.trailerWarnSize);
            }
            long positionOfTrailer = trailerSizeOffset - (long)trailerSize;
            this.seekOnFs(positionOfTrailer);
            buf = ByteBuffer.allocate(trailerSize);
            this.inputStream.readFully(buf.array(), buf.arrayOffset(), buf.capacity());
            this.trailer = WALProtos.WALTrailer.parseFrom((byte[])buf.array());
            this.walEditsStopOffset = positionOfTrailer;
            return true;
        }
        catch (IOException ioe) {
            LOG.warn("Got IOE while reading the trailer. Continuing as if no trailer is present.", (Throwable)ioe);
            return false;
        }
    }

    protected WALCellCodec getCodec(Configuration conf, String cellCodecClsName, CompressionContext compressionContext) throws IOException {
        return WALCellCodec.create(conf, cellCodecClsName, compressionContext);
    }

    @Override
    protected void initAfterCompression() throws IOException {
        this.initAfterCompression(null);
    }

    @Override
    protected void initAfterCompression(String cellCodecClsName) throws IOException {
        WALCellCodec codec = this.getCodec(this.conf, cellCodecClsName, this.compressionContext);
        this.cellDecoder = codec.getDecoder((InputStream)this.inputStream);
        this.byteStringUncompressor = this.hasCompression ? codec.getByteStringUncompressor() : WALCellCodec.getNoneUncompressor();
    }

    @Override
    protected boolean hasCompression() {
        return this.hasCompression;
    }

    @Override
    protected boolean hasTagCompression() {
        return this.hasTagCompression;
    }

    @Override
    protected boolean readNext(WAL.Entry entry) throws IOException {
        this.resetCompression = false;
        long originalPosition = this.inputStream.getPos();
        if (this.trailerPresent && originalPosition > 0L && originalPosition == this.walEditsStopOffset) {
            LOG.trace("Reached end of expected edits area at offset {}", (Object)originalPosition);
            return false;
        }
        boolean resetPosition = false;
        try {
            WALProtos.WALKey walKey;
            try {
                walKey = (WALProtos.WALKey)ProtobufUtil.parseDelimitedFrom((InputStream)this.inputStream, (Parser)WALProtos.WALKey.parser());
            }
            catch (InvalidProtocolBufferException e) {
                if (ProtobufUtil.isEOF((InvalidProtocolBufferException)e) || this.isWALTrailer(originalPosition)) {
                    resetPosition = true;
                    throw (EOFException)new EOFException("Invalid PB, EOF? Ignoring; originalPosition=" + originalPosition + ", currentPosition=" + this.inputStream.getPos()).initCause(e);
                }
                throw e;
            }
            catch (EOFException e) {
                throw (EOFException)new EOFException("EOF while reading WAL key; originalPosition=" + originalPosition + ", currentPosition=" + this.inputStream.getPos()).initCause(e);
            }
            entry.getKey().readFieldsFromPb(walKey, this.byteStringUncompressor);
            if (!walKey.hasFollowingKvCount() || 0 == walKey.getFollowingKvCount()) {
                LOG.debug("WALKey has no KVs that follow it; trying the next one. current offset={}", (Object)this.inputStream.getPos());
                return true;
            }
            this.resetCompression = true;
            int expectedCells = walKey.getFollowingKvCount();
            long posBefore = this.inputStream.getPos();
            try {
                int actualCells = entry.getEdit().readFromCells(this.cellDecoder, expectedCells);
                if (expectedCells != actualCells) {
                    resetPosition = true;
                    throw new EOFException("Only read " + actualCells);
                }
            }
            catch (Exception ex) {
                String posAfterStr = "<unknown>";
                try {
                    posAfterStr = this.inputStream.getPos() + "";
                }
                catch (Throwable t) {
                    LOG.trace("Error getting pos for error message - ignoring", t);
                }
                String message = " while reading " + expectedCells + " WAL KVs; started reading at " + posBefore + " and read up to " + posAfterStr;
                IOException realEofEx = this.extractHiddenEof(ex);
                throw (EOFException)new EOFException("EOF " + message).initCause(realEofEx != null ? realEofEx : ex);
            }
            if (this.trailerPresent && this.inputStream.getPos() > this.walEditsStopOffset) {
                LOG.error("Read WALTrailer while reading WALEdits. wal: " + this.path + ", inputStream.getPos(): " + this.inputStream.getPos() + ", walEditsStopOffset: " + this.walEditsStopOffset);
                throw new EOFException("Read WALTrailer while reading WALEdits");
            }
        }
        catch (EOFException eof) {
            if (originalPosition < 0L) {
                LOG.debug("Encountered a malformed edit, but can't seek back to last good position because originalPosition is negative. last offset={}", (Object)this.inputStream.getPos(), (Object)eof);
                throw eof;
            }
            if (this.inputStream.getPos() == originalPosition) {
                if (resetPosition) {
                    LOG.debug("Encountered a malformed edit, seeking to the beginning of the WAL since current position and original position match at {}", (Object)originalPosition);
                    this.seekOnFs(0L);
                } else {
                    LOG.debug("EOF at position {}", (Object)originalPosition);
                }
            } else {
                LOG.debug("Encountered a malformed edit, seeking back to last good position in file, from {} to {}", new Object[]{this.inputStream.getPos(), originalPosition, eof});
                this.seekOnFs(originalPosition);
            }
            return false;
        }
        return true;
    }

    private IOException extractHiddenEof(Exception ex) {
        IOException ioEx = null;
        if (ex instanceof EOFException) {
            return (EOFException)ex;
        }
        if (ex instanceof IOException) {
            ioEx = (IOException)ex;
        } else if (ex instanceof RuntimeException && ex.getCause() != null && ex.getCause() instanceof IOException) {
            ioEx = (IOException)ex.getCause();
        }
        if (ioEx != null && ioEx.getMessage() != null) {
            if (ioEx.getMessage().contains("EOF")) {
                return ioEx;
            }
            return null;
        }
        return null;
    }

    private boolean isWALTrailer(long startPosition) throws IOException {
        int r;
        int i;
        int trailerSize = PB_WAL_COMPLETE_MAGIC.length + 4;
        if (this.fileLength - startPosition >= (long)trailerSize) {
            return false;
        }
        this.inputStream.seek(startPosition);
        for (i = 0; i < 4; ++i) {
            r = this.inputStream.read();
            if (r == -1) {
                return true;
            }
            if (r == 0) continue;
            return false;
        }
        for (i = 0; i < PB_WAL_COMPLETE_MAGIC.length; ++i) {
            r = this.inputStream.read();
            if (r == -1) {
                return true;
            }
            if (r == (PB_WAL_COMPLETE_MAGIC[i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void seekOnFs(long pos) throws IOException {
        this.inputStream.seek(pos);
    }

    static {
        writerClsNames.add(ProtobufLogWriter.class.getSimpleName());
        writerClsNames.add(AsyncProtobufLogWriter.class.getSimpleName());
    }

    static class WALHdrContext {
        WALHdrResult result;
        String cellCodecClsName;

        WALHdrContext(WALHdrResult result, String cellCodecClsName) {
            this.result = result;
            this.cellCodecClsName = cellCodecClsName;
        }

        WALHdrResult getResult() {
            return this.result;
        }

        String getCellCodecClsName() {
            return this.cellCodecClsName;
        }
    }

    static enum WALHdrResult {
        EOF,
        SUCCESS,
        UNKNOWN_WRITER_CLS;

    }
}

