/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.io.ByteBufferWriterOutputStream;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SecureWALCellCodec
extends WALCellCodec {
    private Encryptor encryptor;
    private Decryptor decryptor;

    public SecureWALCellCodec(Configuration conf, CompressionContext compression) {
        super(conf, compression);
    }

    public SecureWALCellCodec(Configuration conf, Encryptor encryptor) {
        super(conf, null);
        this.encryptor = encryptor;
    }

    public SecureWALCellCodec(Configuration conf, Decryptor decryptor) {
        super(conf, null);
        this.decryptor = decryptor;
    }

    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new EncryptedKvDecoder(is, this.decryptor);
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new EncryptedKvEncoder(os, this.encryptor);
    }

    public static WALCellCodec getCodec(Configuration conf, Encryptor encryptor) {
        return new SecureWALCellCodec(conf, encryptor);
    }

    public static WALCellCodec getCodec(Configuration conf, Decryptor decryptor) {
        return new SecureWALCellCodec(conf, decryptor);
    }

    static class EncryptedKvEncoder
    extends KeyValueCodecWithTags.KeyValueEncoder {
        private Encryptor encryptor;
        private final ThreadLocal<byte[]> iv = new ThreadLocal<byte[]>(this){
            final /* synthetic */ EncryptedKvEncoder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected byte[] initialValue() {
                byte[] iv = new byte[this.this$0.encryptor.getIvLength()];
                Bytes.secureRandom((byte[])iv);
                return iv;
            }
        };

        protected byte[] nextIv() {
            byte[] b = this.iv.get();
            byte[] ret = new byte[b.length];
            System.arraycopy(b, 0, ret, 0, b.length);
            return ret;
        }

        protected void incrementIv(int v) {
            Encryption.incrementIv((byte[])this.iv.get(), (int)(1 + v / this.encryptor.getBlockSize()));
        }

        public EncryptedKvEncoder(OutputStream os) {
            super(os);
        }

        public EncryptedKvEncoder(OutputStream os, Encryptor encryptor) {
            super(os);
            this.encryptor = encryptor;
        }

        public void write(Cell cell) throws IOException {
            if (this.encryptor == null) {
                super.write(cell);
                return;
            }
            byte[] iv = this.nextIv();
            this.encryptor.setIv(iv);
            this.encryptor.reset();
            StreamUtils.writeRawVInt32((OutputStream)this.out, (int)iv.length);
            this.out.write(iv);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStream cout = this.encryptor.createEncryptionStream((OutputStream)baos);
            ByteBufferWriterOutputStream bos = new ByteBufferWriterOutputStream(cout);
            int tlen = cell.getTagsLength();
            StreamUtils.writeRawVInt32((OutputStream)bos, (int)KeyValueUtil.keyLength((Cell)cell));
            StreamUtils.writeRawVInt32((OutputStream)bos, (int)cell.getValueLength());
            StreamUtils.writeRawVInt32((OutputStream)bos, (int)tlen);
            short rowLength = cell.getRowLength();
            StreamUtils.writeRawVInt32((OutputStream)bos, (int)rowLength);
            PrivateCellUtil.writeRow((OutputStream)bos, (Cell)cell, (short)rowLength);
            byte familyLength = cell.getFamilyLength();
            StreamUtils.writeRawVInt32((OutputStream)bos, (int)familyLength);
            PrivateCellUtil.writeFamily((OutputStream)bos, (Cell)cell, (byte)familyLength);
            int qualifierLength = cell.getQualifierLength();
            StreamUtils.writeRawVInt32((OutputStream)bos, (int)qualifierLength);
            PrivateCellUtil.writeQualifier((OutputStream)bos, (Cell)cell, (int)qualifierLength);
            StreamUtils.writeLong((OutputStream)bos, (long)cell.getTimestamp());
            bos.write((int)cell.getTypeByte());
            PrivateCellUtil.writeValue((OutputStream)bos, (Cell)cell, (int)cell.getValueLength());
            if (tlen > 0) {
                PrivateCellUtil.writeTags((OutputStream)bos, (Cell)cell, (int)tlen);
            }
            bos.close();
            StreamUtils.writeRawVInt32((OutputStream)this.out, (int)baos.size());
            baos.writeTo(this.out);
            this.incrementIv(baos.size());
        }
    }

    static class EncryptedKvDecoder
    extends KeyValueCodecWithTags.KeyValueDecoder {
        private Decryptor decryptor;
        private byte[] iv;

        public EncryptedKvDecoder(InputStream in) {
            super(in);
        }

        public EncryptedKvDecoder(InputStream in, Decryptor decryptor) {
            super(in);
            this.decryptor = decryptor;
            if (decryptor != null) {
                this.iv = new byte[decryptor.getIvLength()];
            }
        }

        protected Cell parseCell() throws IOException {
            if (this.decryptor == null) {
                return super.parseCell();
            }
            int ivLength = 0;
            ivLength = StreamUtils.readRawVarint32((InputStream)this.in);
            if (ivLength != this.iv.length) {
                throw new IOException("Incorrect IV length: expected=" + this.iv.length + " have=" + ivLength);
            }
            IOUtils.readFully((InputStream)this.in, (byte[])this.iv);
            int codedLength = StreamUtils.readRawVarint32((InputStream)this.in);
            byte[] codedBytes = new byte[codedLength];
            IOUtils.readFully((InputStream)this.in, (byte[])codedBytes);
            this.decryptor.setIv(this.iv);
            this.decryptor.reset();
            InputStream cin = this.decryptor.createDecryptionStream((InputStream)new ByteArrayInputStream(codedBytes));
            int keylength = StreamUtils.readRawVarint32((InputStream)cin);
            int vlength = StreamUtils.readRawVarint32((InputStream)cin);
            int tagsLength = StreamUtils.readRawVarint32((InputStream)cin);
            int length = 0;
            length = tagsLength == 0 ? 8 + keylength + vlength : 10 + keylength + vlength + tagsLength;
            byte[] backingArray = new byte[length];
            int pos = 0;
            pos = Bytes.putInt((byte[])backingArray, (int)pos, (int)keylength);
            pos = Bytes.putInt((byte[])backingArray, (int)pos, (int)vlength);
            int elemLen = StreamUtils.readRawVarint32((InputStream)cin);
            pos = Bytes.putShort((byte[])backingArray, (int)pos, (short)((short)elemLen));
            IOUtils.readFully((InputStream)cin, (byte[])backingArray, (int)pos, (int)elemLen);
            pos += elemLen;
            elemLen = StreamUtils.readRawVarint32((InputStream)cin);
            pos = Bytes.putByte((byte[])backingArray, (int)pos, (byte)((byte)elemLen));
            IOUtils.readFully((InputStream)cin, (byte[])backingArray, (int)pos, (int)elemLen);
            pos += elemLen;
            elemLen = StreamUtils.readRawVarint32((InputStream)cin);
            IOUtils.readFully((InputStream)cin, (byte[])backingArray, (int)pos, (int)elemLen);
            IOUtils.readFully((InputStream)cin, (byte[])backingArray, (int)(pos += elemLen), (int)(length - pos));
            return new KeyValue(backingArray, 0, length);
        }
    }
}

