/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.throttle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.throttle.StoreHotnessProtector;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestStoreHotnessProtector {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStoreHotnessProtector.class);

    @Test
    public void testPreparePutCounter() throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        Configuration conf = new Configuration();
        conf.setInt("hbase.region.store.parallel.put.limit.min.column.count", 0);
        conf.setInt("hbase.region.store.parallel.put.limit", 10);
        conf.setInt("hbase.region.store.parallel.prepare.put.multiplier", 3);
        Region mockRegion = (Region)Mockito.mock(Region.class);
        StoreHotnessProtector storeHotnessProtector = new StoreHotnessProtector(mockRegion, conf);
        Store mockStore1 = (Store)Mockito.mock(Store.class);
        RegionInfo mockRegionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        byte[] family = "testF1".getBytes();
        Mockito.when((Object)mockRegion.getStore(family)).thenReturn((Object)mockStore1);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.getRegionNameAsString()).thenReturn((Object)"test_region_1");
        Mockito.when((Object)mockStore1.getCurrentParallelPutCount()).thenReturn((Object)1);
        Mockito.when((Object)mockStore1.getColumnFamilyName()).thenReturn((Object)"test_Family_1");
        HashMap<byte[], ArrayList> familyMaps = new HashMap<byte[], ArrayList>();
        familyMaps.put(family, Lists.newArrayList((Object[])new Cell[]{(Cell)Mockito.mock(Cell.class), (Cell)Mockito.mock(Cell.class)}));
        AtomicReference<RegionTooBusyException> exception = new AtomicReference<RegionTooBusyException>();
        int threadCount = conf.getInt("hbase.region.store.parallel.put.limit", 10) * conf.getInt("hbase.region.store.parallel.prepare.put.multiplier", 3);
        CountDownLatch countDownLatch = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            executorService.execute(() -> {
                try {
                    storeHotnessProtector.start(familyMaps);
                }
                catch (RegionTooBusyException e) {
                    e.printStackTrace();
                    exception.set(e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        countDownLatch.await(60L, TimeUnit.SECONDS);
        Assert.assertEquals(exception.get(), null);
        Assert.assertEquals((long)storeHotnessProtector.getPreparePutToStoreMap().size(), (long)1L);
        Assert.assertEquals((long)((AtomicInteger)storeHotnessProtector.getPreparePutToStoreMap().get(family)).get(), (long)threadCount);
        try {
            storeHotnessProtector.start(familyMaps);
        }
        catch (RegionTooBusyException e) {
            e.printStackTrace();
            exception.set(e);
        }
        Assert.assertEquals(((Exception)exception.get()).getClass(), RegionTooBusyException.class);
        Assert.assertEquals((long)storeHotnessProtector.getPreparePutToStoreMap().size(), (long)1L);
        Assert.assertEquals((long)((AtomicInteger)storeHotnessProtector.getPreparePutToStoreMap().get(family)).get(), (long)(threadCount + 1));
        storeHotnessProtector.finish(familyMaps);
        Assert.assertEquals((long)((AtomicInteger)storeHotnessProtector.getPreparePutToStoreMap().get(family)).get(), (long)threadCount);
    }
}

