/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischarger;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestRegionMergeTransactionOnCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionMergeTransactionOnCluster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionMergeTransactionOnCluster.class);
    @Rule
    public TestName name = new TestName();
    private static final int NB_SERVERS = 3;
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final int INITIAL_REGION_NUM = 10;
    private static final int ROWSIZE = 200;
    private static byte[][] ROWS = TestRegionMergeTransactionOnCluster.makeN(ROW, 200);
    private static int waitTime = 60000;
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static HMaster MASTER;
    private static Admin ADMIN;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().masterClass(MyMaster.class).numRegionServers(3).numDataNodes(3).build();
        TEST_UTIL.startMiniCluster(option);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        MASTER = cluster.getMaster();
        MASTER.balanceSwitch(false);
        ADMIN = TEST_UTIL.getConnection().getAdmin();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        if (ADMIN != null) {
            ADMIN.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWholesomeMerge() throws Exception {
        LOG.info("Starting " + this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            Table table = this.createTableAndLoadData(MASTER, tableName);
            this.mergeRegionsAndVerifyRegionNum(MASTER, tableName, 0, 1, 9);
            PairOfSameType<RegionInfo> mergedRegions = this.mergeRegionsAndVerifyRegionNum(MASTER, tableName, 1, 2, 8);
            this.verifyRowCount(table, 200);
            RegionInfo hri = RandomUtils.nextBoolean() ? (RegionInfo)mergedRegions.getFirst() : (RegionInfo)mergedRegions.getSecond();
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            AssignmentManager am = cluster.getMaster().getAssignmentManager();
            RegionStates regionStates = am.getRegionStates();
            am.assign(hri);
            Assert.assertFalse((String)"Merged region can't be assigned", (boolean)regionStates.isRegionInTransition(hri));
            am.unassign(hri);
            Assert.assertFalse((String)"Merged region can't be unassigned", (boolean)regionStates.isRegionInTransition(hri));
            table.close();
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeAndRestartingMaster() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            Table table = this.createTableAndLoadData(MASTER, tableName);
            try {
                MyMasterRpcServices.enabled.set(true);
                this.mergeRegionsAndVerifyRegionNum(MASTER, tableName, 0, 1, 9);
            }
            finally {
                MyMasterRpcServices.enabled.set(false);
            }
            table.close();
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanMergeReference() throws Exception {
        LOG.info("Starting " + this.name.getMethodName());
        ADMIN.enableCatalogJanitor(false);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            Table table = this.createTableAndLoadData(MASTER, tableName);
            this.mergeRegionsAndVerifyRegionNum(MASTER, tableName, 0, 1, 9);
            this.verifyRowCount(table, 200);
            table.close();
            List tableRegions = MetaTableAccessor.getTableRegionsAndLocations((Connection)MASTER.getConnection(), (TableName)tableName);
            RegionInfo mergedRegionInfo = (RegionInfo)((Pair)tableRegions.get(0)).getFirst();
            TableDescriptor tableDescriptor = MASTER.getTableDescriptors().get(tableName);
            Result mergedRegionResult = MetaTableAccessor.getRegionResult((Connection)MASTER.getConnection(), (byte[])mergedRegionInfo.getRegionName());
            Assert.assertTrue((boolean)MetaTableAccessor.hasMergeRegions((Cell[])mergedRegionResult.rawCells()));
            List p = MetaTableAccessor.getMergeRegions((Cell[])mergedRegionResult.rawCells());
            RegionInfo regionA = (RegionInfo)p.get(0);
            RegionInfo regionB = (RegionInfo)p.get(1);
            FileSystem fs = MASTER.getMasterFileSystem().getFileSystem();
            Path rootDir = MASTER.getMasterFileSystem().getRootDir();
            Path tabledir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)mergedRegionInfo.getTable());
            Path regionAdir = new Path(tabledir, regionA.getEncodedName());
            Path regionBdir = new Path(tabledir, regionB.getEncodedName());
            Assert.assertTrue((boolean)fs.exists(regionAdir));
            Assert.assertTrue((boolean)fs.exists(regionBdir));
            ColumnFamilyDescriptor[] columnFamilies = tableDescriptor.getColumnFamilies();
            HRegionFileSystem hrfs = new HRegionFileSystem(TEST_UTIL.getConfiguration(), fs, tabledir, mergedRegionInfo);
            int count = 0;
            for (ColumnFamilyDescriptor columnFamilyDescriptor : columnFamilies) {
                count += hrfs.getStoreFiles(columnFamilyDescriptor.getName()).size();
            }
            ADMIN.compactRegion(mergedRegionInfo.getRegionName());
            long timeout = System.currentTimeMillis() + (long)waitTime;
            int newcount = 0;
            while (System.currentTimeMillis() < timeout) {
                for (ColumnFamilyDescriptor colFamily : columnFamilies) {
                    newcount += hrfs.getStoreFiles(colFamily.getName()).size();
                }
                if (newcount > count) break;
                Thread.sleep(50L);
            }
            Assert.assertTrue((newcount > count ? 1 : 0) != 0);
            List<JVMClusterUtil.RegionServerThread> list = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
            for (JVMClusterUtil.RegionServerThread rs : list) {
                CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(100, null, (RegionServerServices)rs.getRegionServer(), false);
                cleaner.chore();
                Thread.sleep(1000L);
            }
            while (System.currentTimeMillis() < timeout) {
                int newcount1 = 0;
                for (ColumnFamilyDescriptor colFamily : columnFamilies) {
                    newcount1 += hrfs.getStoreFiles(colFamily.getName()).size();
                }
                if (newcount1 <= 1) break;
                Thread.sleep(50L);
            }
            int cleaned = 0;
            while (cleaned == 0) {
                cleaned = ADMIN.runCatalogScan();
                LOG.debug("catalog janitor returned " + cleaned);
                Thread.sleep(50L);
                ProcedureTestingUtility.waitNoProcedureRunning((ProcedureExecutor)TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor());
            }
            Assert.assertTrue((cleaned > 0 ? 1 : 0) != 0);
            while (MetaTableAccessor.hasMergeRegions((Cell[])(mergedRegionResult = MetaTableAccessor.getRegionResult((Connection)TEST_UTIL.getConnection(), (byte[])mergedRegionInfo.getRegionName())).rawCells())) {
                LOG.info("Waiting on cleanup of merge columns {}", (Object)Arrays.asList(mergedRegionResult.rawCells()).stream().map(c -> c.toString()).collect(Collectors.joining(",")));
                Threads.sleep((long)50L);
            }
            Assert.assertFalse((boolean)MetaTableAccessor.hasMergeRegions((Cell[])mergedRegionResult.rawCells()));
        }
        finally {
            ADMIN.enableCatalogJanitor(true);
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMerge() throws Exception {
        LOG.info("Starting " + this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Admin admin = TEST_UTIL.getAdmin();
        int syncWaitTimeout = 600000;
        try {
            Table table = this.createTableAndLoadData(MASTER, tableName);
            AssignmentManager am = MASTER.getAssignmentManager();
            List regions = am.getRegionStates().getRegionsOfTable(tableName);
            RegionInfo a = (RegionInfo)regions.get(0);
            RegionInfo b = (RegionInfo)regions.get(1);
            am.unassign(b);
            am.offlineRegion(b);
            try {
                admin.mergeRegionsAsync(a.getEncodedNameAsBytes(), b.getEncodedNameAsBytes(), false).get(600000L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"Offline regions should not be able to merge");
            }
            catch (DoNotRetryRegionException ie) {
                System.out.println((Object)ie);
                Assert.assertTrue((boolean)(ie instanceof MergeRegionException));
            }
            try {
                FutureUtils.get((Future)admin.mergeRegionsAsync(b.getEncodedNameAsBytes(), b.getEncodedNameAsBytes(), true));
                Assert.fail((String)"A region should not be able to merge with itself, even forcfully");
            }
            catch (IOException ie) {
                Assert.assertTrue((String)"Exception should mention regions not online", (StringUtils.stringifyException((Throwable)ie).contains("region to itself") && ie instanceof MergeRegionException ? 1 : 0) != 0);
            }
            try {
                admin.mergeRegionsAsync(Bytes.toBytes((String)"-f1"), Bytes.toBytes((String)"-f2"), true);
                Assert.fail((String)"Unknown region could not be merged");
            }
            catch (IOException ie) {
                Assert.assertTrue((String)"UnknownRegionException should be thrown", (boolean)(ie instanceof UnknownRegionException));
            }
            table.close();
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeWithReplicas() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            Table table = this.createTableAndLoadData(MASTER, tableName, 5, 2);
            List initialRegionToServers = MetaTableAccessor.getTableRegionsAndLocations((Connection)TEST_UTIL.getConnection(), (TableName)tableName);
            PairOfSameType<RegionInfo> mergedRegions = this.mergeRegionsAndVerifyRegionNum(MASTER, tableName, 0, 2, 8);
            List currentRegionToServers = MetaTableAccessor.getTableRegionsAndLocations((Connection)TEST_UTIL.getConnection(), (TableName)tableName);
            ArrayList<Object> initialRegions = new ArrayList<Object>();
            for (Pair p : initialRegionToServers) {
                initialRegions.add(p.getFirst());
            }
            ArrayList<Object> currentRegions = new ArrayList<Object>();
            for (Pair p : currentRegionToServers) {
                currentRegions.add(p.getFirst());
            }
            Assert.assertTrue((boolean)initialRegions.contains(mergedRegions.getFirst()));
            Assert.assertTrue((boolean)initialRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)mergedRegions.getFirst()), (int)1)));
            Assert.assertTrue((boolean)initialRegions.contains(mergedRegions.getSecond()));
            Assert.assertTrue((boolean)initialRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)mergedRegions.getSecond()), (int)1)));
            Assert.assertTrue((!initialRegions.contains(currentRegions.get(0)) ? 1 : 0) != 0);
            Assert.assertTrue((!initialRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)currentRegions.get(0)), (int)1)) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)currentRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)currentRegions.get(0)), (int)1)));
            Assert.assertTrue((!currentRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)mergedRegions.getFirst()), (int)1)) ? 1 : 0) != 0);
            Assert.assertTrue((!currentRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)mergedRegions.getSecond()), (int)1)) ? 1 : 0) != 0);
            table.close();
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    private PairOfSameType<RegionInfo> mergeRegionsAndVerifyRegionNum(HMaster master, TableName tablename, int regionAnum, int regionBnum, int expectedRegionNum) throws Exception {
        PairOfSameType<RegionInfo> mergedRegions = this.requestMergeRegion(master, tablename, regionAnum, regionBnum);
        this.waitAndVerifyRegionNum(master, tablename, expectedRegionNum);
        return mergedRegions;
    }

    private PairOfSameType<RegionInfo> requestMergeRegion(HMaster master, TableName tablename, int regionAnum, int regionBnum) throws Exception {
        List tableRegions = MetaTableAccessor.getTableRegionsAndLocations((Connection)TEST_UTIL.getConnection(), (TableName)tablename);
        RegionInfo regionA = (RegionInfo)((Pair)tableRegions.get(regionAnum)).getFirst();
        RegionInfo regionB = (RegionInfo)((Pair)tableRegions.get(regionBnum)).getFirst();
        ADMIN.mergeRegionsAsync(regionA.getEncodedNameAsBytes(), regionB.getEncodedNameAsBytes(), false);
        return new PairOfSameType((Object)regionA, (Object)regionB);
    }

    private void waitAndVerifyRegionNum(HMaster master, TableName tablename, int expectedRegionNum) throws Exception {
        List tableRegionsInMeta;
        long timeout = System.currentTimeMillis() + (long)waitTime;
        while (System.currentTimeMillis() < timeout) {
            tableRegionsInMeta = MetaTableAccessor.getTableRegionsAndLocations((Connection)TEST_UTIL.getConnection(), (TableName)tablename);
            List tableRegionsInMaster = master.getAssignmentManager().getRegionStates().getRegionsOfTable(tablename);
            LOG.info(Objects.toString(tableRegionsInMaster));
            LOG.info(Objects.toString(tableRegionsInMeta));
            int tableRegionsInMetaSize = tableRegionsInMeta.size();
            int tableRegionsInMasterSize = tableRegionsInMaster.size();
            if (tableRegionsInMetaSize == expectedRegionNum && tableRegionsInMasterSize == expectedRegionNum) break;
            Thread.sleep(250L);
        }
        tableRegionsInMeta = MetaTableAccessor.getTableRegionsAndLocations((Connection)TEST_UTIL.getConnection(), (TableName)tablename);
        LOG.info("Regions after merge:" + Joiner.on((char)',').join((Iterable)tableRegionsInMeta));
        Assert.assertEquals((long)expectedRegionNum, (long)tableRegionsInMeta.size());
    }

    private Table createTableAndLoadData(HMaster master, TableName tablename) throws Exception {
        return this.createTableAndLoadData(master, tablename, 10, 1);
    }

    private Table createTableAndLoadData(HMaster master, TableName tablename, int numRegions, int replication) throws Exception {
        Assert.assertTrue((String)("ROWSIZE must > numregions:" + numRegions), (200 > numRegions ? 1 : 0) != 0);
        byte[][] splitRows = new byte[numRegions - 1][];
        for (int i = 0; i < splitRows.length; ++i) {
            splitRows[i] = ROWS[(i + 1) * 200 / numRegions];
        }
        Table table = TEST_UTIL.createTable(tablename, FAMILYNAME, (byte[][])splitRows);
        LOG.info("Created " + table.getName());
        if (replication > 1) {
            HBaseTestingUtility.setReplicas(ADMIN, tablename, replication);
            LOG.info("Set replication of " + replication + " on " + table.getName());
        }
        this.loadData(table);
        LOG.info("Loaded " + table.getName());
        this.verifyRowCount(table, 200);
        LOG.info("Verified " + table.getName());
        TEST_UTIL.waitUntilAllRegionsAssigned(tablename);
        LOG.info("All regions assigned for table - " + table.getName());
        List tableRegions = MetaTableAccessor.getTableRegionsAndLocations((Connection)TEST_UTIL.getConnection(), (TableName)tablename);
        Assert.assertEquals((String)("Wrong number of regions in table " + tablename), (long)(numRegions * replication), (long)tableRegions.size());
        LOG.info(tableRegions.size() + "Regions after load: " + Joiner.on((char)',').join((Iterable)tableRegions));
        Assert.assertEquals((long)(numRegions * replication), (long)tableRegions.size());
        return table;
    }

    private static byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])Bytes.toBytes((String)String.format("%04d", i)));
        }
        return ret;
    }

    private void loadData(Table table) throws IOException {
        for (int i = 0; i < 200; ++i) {
            Put put = new Put(ROWS[i]);
            put.addColumn(FAMILYNAME, QUALIFIER, Bytes.toBytes((int)i));
            table.put(put);
        }
    }

    private void verifyRowCount(Table table, int expectedRegionNum) throws IOException {
        ResultScanner scanner = table.getScanner(new Scan());
        int rowCount = 0;
        while (scanner.next() != null) {
            ++rowCount;
        }
        Assert.assertEquals((long)expectedRegionNum, (long)rowCount);
        scanner.close();
    }

    static class MyMasterRpcServices
    extends MasterRpcServices {
        static AtomicBoolean enabled = new AtomicBoolean(false);
        private HMaster myMaster;

        public MyMasterRpcServices(HMaster master) throws IOException {
            super(master);
            this.myMaster = master;
        }

        public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RpcController c, RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws ServiceException {
            RegionServerStatusProtos.ReportRegionStateTransitionResponse resp = super.reportRegionStateTransition(c, req);
            if (enabled.get() && req.getTransition(0).getTransitionCode() == RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_MERGE && !resp.hasErrorMessage()) {
                RegionStates regionStates = this.myMaster.getAssignmentManager().getRegionStates();
                for (RegionState regionState : regionStates.getRegionsStateInTransition()) {
                    if (!regionState.isMergingNew()) continue;
                    regionStates.deleteRegion(regionState.getRegion());
                }
            }
            return resp;
        }
    }

    public static class MyMaster
    extends HMaster {
        public MyMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new MyMasterRpcServices(this);
        }
    }
}

